/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.relocate.co.aikar.timings;

import co.aikar.timings.Timing;
import net.minecraft.block.Block;
import org.spongepowered.api.block.BlockType;
import org.spongepowered.api.block.tileentity.TileEntity;
import org.spongepowered.api.block.tileentity.TileEntityType;
import org.spongepowered.api.plugin.PluginContainer;
import org.spongepowered.api.scheduler.Task;
import org.spongepowered.common.entity.SpongeEntityType;
import org.spongepowered.common.relocate.co.aikar.timings.SpongeTimingsFactory;
import org.spongepowered.common.relocate.co.aikar.timings.TimingsManager;

public final class SpongeTimings {
    public static final Timing playerListTimer = SpongeTimingsFactory.ofSafe("Player List");
    public static final Timing connectionTimer = SpongeTimingsFactory.ofSafe("Connection Handler");
    public static final Timing tickablesTimer = SpongeTimingsFactory.ofSafe("Tickables");
    public static final Timing schedulerTimer = SpongeTimingsFactory.ofSafe("Scheduler");
    public static final Timing chunkIOTickTimer = SpongeTimingsFactory.ofSafe("ChunkIOTick");
    public static final Timing timeUpdateTimer = SpongeTimingsFactory.ofSafe("Time Update");
    public static final Timing serverCommandTimer = SpongeTimingsFactory.ofSafe("Server Command");
    public static final Timing worldSaveTimer = SpongeTimingsFactory.ofSafe("World Save");
    public static final Timing processQueueTimer = SpongeTimingsFactory.ofSafe("processQueue");
    public static final Timing playerCommandTimer = SpongeTimingsFactory.ofSafe("playerCommand");
    public static final Timing entityActivationCheckTimer = SpongeTimingsFactory.ofSafe("entityActivationCheck");
    public static final Timing checkIfActiveTimer = SpongeTimingsFactory.ofSafe("checkIfActive");
    public static final Timing antiXrayUpdateTimer = SpongeTimingsFactory.ofSafe("anti-xray - update");
    public static final Timing antiXrayObfuscateTimer = SpongeTimingsFactory.ofSafe("anti-xray - obfuscate");
    public static final Timing dataGetManipulator = SpongeTimingsFactory.ofSafe("## getManipulator");
    public static final Timing dataGetOrCreateManipulator = SpongeTimingsFactory.ofSafe("## getOrCreateManipulator");
    public static final Timing dataOfferManipulator = SpongeTimingsFactory.ofSafe("## offerData");
    public static final Timing dataOfferMultiManipulators = SpongeTimingsFactory.ofSafe("## offerManipulators");
    public static final Timing dataRemoveManipulator = SpongeTimingsFactory.ofSafe("## removeManipulator");
    public static final Timing dataSupportsManipulator = SpongeTimingsFactory.ofSafe("## supportsManipulator");
    public static final Timing dataOfferKey = SpongeTimingsFactory.ofSafe("## offerKey");
    public static final Timing dataGetByKey = SpongeTimingsFactory.ofSafe("## getKey");
    public static final Timing dataGetValue = SpongeTimingsFactory.ofSafe("## getValue");
    public static final Timing dataSupportsKey = SpongeTimingsFactory.ofSafe("## supportsKey");
    public static final Timing dataRemoveKey = SpongeTimingsFactory.ofSafe("## removeKey");
    public static final Timing TRACKING_PHASE_UNWINDING = SpongeTimingsFactory.ofSafe("## unwindPhase");

    private SpongeTimings() {
    }

    public static Timing getPluginTaskTimings(Task task, long period) {
        if (task.isAsynchronous()) {
            return null;
        }
        PluginContainer plugin = task.getOwner();
        String name = "Task: " + task.getName();
        name = period > 0L ? name + " (interval:" + period + ")" : name + " (Single)";
        return SpongeTimingsFactory.ofSafe(plugin, name);
    }

    public static Timing getEntityTiming(SpongeEntityType entity) {
        String entityType = entity != null ? entity.getId() : entity.getClass().getName();
        return SpongeTimingsFactory.ofSafe("Minecraft", "## tickEntity - " + entityType);
    }

    public static Timing getTileEntityTiming(TileEntity entity) {
        TileEntityType type = entity.getType();
        String entityType = type != null ? type.getId() : entity.getClass().getName();
        return SpongeTimingsFactory.ofSafe("Minecraft", "## tickTileEntity - " + entityType);
    }

    public static Timing getModTimings(PluginContainer plugin, String context) {
        return SpongeTimingsFactory.ofSafe(plugin.getName(), context, TimingsManager.MOD_EVENT_HANDLER);
    }

    public static Timing getPluginTimings(PluginContainer plugin, String context) {
        return SpongeTimingsFactory.ofSafe(plugin.getName(), context, TimingsManager.PLUGIN_EVENT_HANDLER);
    }

    public static Timing getPluginSchedulerTimings(PluginContainer plugin) {
        return SpongeTimingsFactory.ofSafe(plugin.getName(), TimingsManager.PLUGIN_SCHEDULER_HANDLER);
    }

    public static Timing getCancelTasksTimer() {
        return SpongeTimingsFactory.ofSafe("Cancel Tasks");
    }

    public static Timing getCancelTasksTimer(PluginContainer plugin) {
        return SpongeTimingsFactory.ofSafe(plugin, "Cancel Tasks");
    }

    public static void stopServer() {
        TimingsManager.stopServer();
    }

    public static Timing getBlockTiming(Block block) {
        BlockType type = (BlockType)block;
        return SpongeTimingsFactory.ofSafe("## Scheduled Block: " + type != null ? type.getId() : block.func_149739_a());
    }
}

