/*
 * Decompiled with CFR 0.152.
 */
package lumien.randomthings.container;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import lumien.randomthings.client.gui.GuiChunkAnalyzer;
import lumien.randomthings.handler.chunkanalyzer.ChunkAnalyzerResult;
import lumien.randomthings.item.ModItems;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ContainerChunkAnalyzer
extends Container {
    EntityPlayer player;
    public boolean scanning;
    int chunkX;
    int chunkZ;
    int nextX;
    int nextZ;
    Map<IBlockState, Integer> countMap;
    @SideOnly(value=Side.CLIENT)
    GuiChunkAnalyzer parent;

    public ContainerChunkAnalyzer(EntityPlayer player, World world, int x, int y, int z) {
        this.player = player;
    }

    @SideOnly(value=Side.CLIENT)
    public void setParent(GuiChunkAnalyzer parent) {
        this.parent = parent;
    }

    public void startScanning() {
        this.scanning = true;
        this.countMap = new HashMap<IBlockState, Integer>();
        Chunk targetChunk = this.player.field_70170_p.func_175726_f(this.player.func_180425_c());
        this.chunkX = targetChunk.field_76635_g;
        this.chunkZ = targetChunk.field_76647_h;
        this.sendScanning();
    }

    public void func_75142_b() {
        super.func_75142_b();
        this.player.field_71069_bz.func_75142_b();
        for (int q = 0; q < 10 && this.scanning; ++q) {
            if (!this.scanning) continue;
            Chunk c = this.player.field_70170_p.func_72964_e(this.chunkX, this.chunkZ);
            for (int y = 0; y < c.func_76611_b(this.nextX, this.nextZ); ++y) {
                IBlockState state = c.func_186032_a(this.nextX, y, this.nextZ);
                if (state.func_177230_c().isAir(state, (IBlockAccess)this.player.field_70170_p, new BlockPos(c.field_76635_g + this.nextX, y, c.field_76647_h + this.nextZ))) continue;
                if (this.countMap.containsKey(state)) {
                    this.countMap.put(state, this.countMap.get(state) + 1);
                    continue;
                }
                this.countMap.put(state, 1);
            }
            if (this.nextX == 15) {
                ++this.nextZ;
                this.nextX = 0;
                if (this.nextZ != 16) continue;
                this.nextZ = 0;
                this.nextX = 0;
                ArrayList<BlockResult> resultList = new ArrayList<BlockResult>();
                HashMap<String, BlockResult> nameMap = new HashMap<String, BlockResult>();
                for (Map.Entry<IBlockState, Integer> entry : this.countMap.entrySet()) {
                    String name;
                    IBlockState state = entry.getKey();
                    BlockResult br = new BlockResult();
                    br.state = state;
                    br.count = entry.getValue();
                    int meta = state.func_177230_c().func_176201_c(state);
                    Item i = Item.func_150898_a((Block)br.state.func_177230_c());
                    if (i == null) {
                        name = state.func_177230_c().func_149732_F();
                        br.stack = ItemStack.field_190927_a;
                    } else {
                        br.stack = new ItemStack(i, 1, meta);
                        name = br.stack.func_82833_r();
                        if (name.equals("Air")) {
                            name = state.func_177230_c().func_149732_F();
                        }
                    }
                    if (name == null) continue;
                    br.name = name;
                    if (nameMap.containsKey(name)) {
                        ((BlockResult)nameMap.get((Object)name)).count += br.count;
                        continue;
                    }
                    nameMap.put(name, br);
                    resultList.add(br);
                }
                resultList.sort((a, b) -> b.count - a.count);
                ChunkAnalyzerResult result = new ChunkAnalyzerResult();
                for (BlockResult br : resultList) {
                    result.addBlock(br.stack, br.name, br.count);
                }
                ItemStack itemStack = this.player.func_184614_ca();
                if (itemStack.func_190926_b() || itemStack.func_77973_b() != ModItems.chunkAnalyzer) continue;
                NBTTagCompound cmp = itemStack.func_190925_c("result");
                result.writeToNBT(cmp);
                this.player.field_71069_bz.func_75142_b();
                this.scanning = false;
                this.countMap = null;
                this.sendScanning();
                continue;
            }
            ++this.nextX;
        }
    }

    private void sendScanning() {
        for (int i = 0; i < this.field_75149_d.size(); ++i) {
            IContainerListener icrafting = (IContainerListener)this.field_75149_d.get(i);
            icrafting.func_71112_a((Container)this, 0, this.scanning ? 1 : 0);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_75137_b(int id, int data) {
        super.func_75137_b(id, data);
        if (id == 0) {
            this.scanning = data != 0;
            this.parent.setScanning(this.scanning);
        }
    }

    public boolean func_75145_c(EntityPlayer playerIn) {
        return true;
    }

    static class BlockResult {
        IBlockState state;
        int count;
        String name;
        ItemStack stack;

        BlockResult() {
        }
    }
}

