/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.smeltery.tileentity;

import java.lang.ref.WeakReference;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import slimeknights.tconstruct.library.fluid.FluidHandlerExtractOnlyWrapper;
import slimeknights.tconstruct.library.smeltery.ISmelteryTankHandler;
import slimeknights.tconstruct.library.smeltery.SmelteryTank;
import slimeknights.tconstruct.smeltery.tileentity.TileSmelteryComponent;

public class TileDrain
extends TileSmelteryComponent {
    private FluidHandlerExtractOnlyWrapper drainFluidHandler;
    private WeakReference<ISmelteryTankHandler> oldSmelteryTank;

    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            ISmelteryTankHandler te = this.getSmelteryTankHandler();
            return te != null && te.getTank() != null;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            ISmelteryTankHandler te = this.getSmelteryTankHandler();
            if (te == null) {
                return (T)super.getCapability(capability, facing);
            }
            SmelteryTank tank = te.getTank();
            if (tank == null) {
                return (T)super.getCapability(capability, facing);
            }
            if (facing == null) {
                if (this.drainFluidHandler == null || this.oldSmelteryTank.get() == null || this.oldSmelteryTank == null || !this.drainFluidHandler.hasParent() || !te.equals(this.oldSmelteryTank.get())) {
                    this.drainFluidHandler = new FluidHandlerExtractOnlyWrapper(tank);
                    this.oldSmelteryTank = new WeakReference<ISmelteryTankHandler>(te);
                }
                return (T)((Object)this.drainFluidHandler);
            }
            return (T)tank;
        }
        return (T)super.getCapability(capability, facing);
    }
}

