/*
 * Decompiled with CFR 0.152.
 */
package tinker_io.tileentity;

import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import slimeknights.tconstruct.smeltery.tileentity.TileTank;
import tinker_io.tileentity.energy.EnergyCapability;

public class TileEntityStirlingEngine
extends TileEntity
implements ITickable {
    public static String TAG_ANGLE = "angle";
    public static String TAG_RF_PER_TICK = "rfPerTick";
    private double angle = 0.0;
    private int rfPerTick = 0;
    private int energyExportCount = 0;
    private int syncCount = 0;
    protected EnergyCapability storage = new EnergyCapability(500000, 0, 2000);

    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityEnergy.ENERGY) {
            return (T)this.storage.getStorage();
        }
        return (T)super.getCapability(capability, facing);
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityEnergy.ENERGY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        this.angle = tagCompound.func_74769_h(TAG_ANGLE);
        this.rfPerTick = tagCompound.func_74762_e(TAG_RF_PER_TICK);
        this.storage.readFromNBT(tagCompound);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tagCompound) {
        super.func_189515_b(tagCompound);
        tagCompound.func_74780_a(TAG_ANGLE, (double)((short)this.angle));
        tagCompound.func_74768_a(TAG_RF_PER_TICK, this.rfPerTick);
        this.storage.writeToNBT(tagCompound);
        return tagCompound;
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound nbtTag = new NBTTagCompound();
        this.func_189515_b(nbtTag);
        return new SPacketUpdateTileEntity(this.field_174879_c, 1, nbtTag);
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity packet) {
        this.func_145839_a(packet.func_148857_g());
    }

    public void func_73660_a() {
        FluidTank tank;
        this.rfPerTick = 0;
        if (this.syncCount <= 20) {
            this.notifyBlockUpdate();
            this.func_70296_d();
            ++this.syncCount;
        }
        if ((tank = this.getTankBelow()) != null) {
            this.calculateRfPerTick(tank);
            if (this.rfPerTick != 0 && this.storage.getStorage().getEnergyStored() < this.storage.getStorage().getMaxEnergyStored()) {
                this.storage.setEnergyStored(this.getEnergyStored() + this.rfPerTick);
                this.angle = (this.angle + 1.0) % 61.0;
                this.drainTank(tank);
                this.notifyBlockUpdate();
                this.func_70296_d();
            }
        }
        if (this.extraEnergyToSurroundingMachine()) {
            this.notifyBlockUpdate();
            this.func_70296_d();
        }
    }

    private void calculateRfPerTick(FluidTank tank) {
        Fluid fluid;
        FluidStack fluidStack = tank.getFluid();
        if (fluidStack != null && (fluid = fluidStack.getFluid()) != null) {
            this.rfPerTick = (fluid.getTemperature() - 300) * 15 / 100;
        }
    }

    private void drainTank(FluidTank tank) {
        FluidStack canDrain = tank.drain(1, false);
        if (canDrain != null) {
            tank.drain(2, true);
        }
    }

    public FluidTank getTankBelow() {
        TileEntity te = this.field_145850_b.func_175625_s(this.field_174879_c.func_177977_b());
        if (te instanceof TileTank) {
            return ((TileTank)te).getInternalTank();
        }
        return null;
    }

    private boolean extraEnergyToSurroundingMachine() {
        IEnergyStorage iEnergyStorage;
        TileEntity te;
        int exportPerTick = Math.min(this.storage.getEnergyStored(), 1000);
        EnumFacing facing = null;
        EnumFacing facingOpp = null;
        switch (this.energyExportCount) {
            case 0: {
                facing = EnumFacing.EAST;
                facingOpp = EnumFacing.WEST;
                break;
            }
            case 1: {
                facing = EnumFacing.WEST;
                facingOpp = EnumFacing.EAST;
                break;
            }
            case 2: {
                facing = EnumFacing.SOUTH;
                facingOpp = EnumFacing.NORTH;
                break;
            }
            case 3: {
                facing = EnumFacing.NORTH;
                facingOpp = EnumFacing.SOUTH;
                break;
            }
            case 4: {
                facing = EnumFacing.UP;
                facingOpp = EnumFacing.DOWN;
                break;
            }
            case 5: {
                facing = EnumFacing.DOWN;
                facingOpp = EnumFacing.UP;
                break;
            }
        }
        if (facing != null && (te = this.func_145831_w().func_175625_s(this.func_174877_v().func_177972_a(facing))) != null && (iEnergyStorage = (IEnergyStorage)te.getCapability(CapabilityEnergy.ENERGY, facingOpp)) != null) {
            int estConsume = iEnergyStorage.receiveEnergy(exportPerTick, true);
            iEnergyStorage.receiveEnergy(estConsume, false);
            this.storage.getStorage().extractEnergy(estConsume, false);
            return true;
        }
        this.energyExportCount = this.energyExportCount + 1 >= 6 || this.energyExportCount < 0 ? 0 : ++this.energyExportCount;
        return true;
    }

    public int getRfPerTick() {
        return this.rfPerTick;
    }

    public void setEnergyAmount(int amount) {
        this.storage.setEnergyStored(amount);
    }

    public int getEnergyStored() {
        return this.storage.getEnergyStored();
    }

    public double getAngle() {
        return this.angle;
    }

    public FluidStack getFluid() {
        FluidTank tank = this.getTankBelow();
        if (tank != null && tank.getFluid() != null) {
            return tank.getFluid();
        }
        return null;
    }

    public int getFluidAmount() {
        FluidStack fluidStack = this.getFluid();
        if (fluidStack != null) {
            return fluidStack.amount;
        }
        return 0;
    }

    public int getTemperature() {
        FluidStack fluidStack = this.getFluid();
        if (fluidStack != null && fluidStack.getFluid() != null) {
            return fluidStack.getFluid().getTemperature();
        }
        return 0;
    }

    private void notifyBlockUpdate() {
        if (this.field_145850_b != null && this.field_174879_c != null) {
            IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
            this.field_145850_b.func_184138_a(this.field_174879_c, state, state, 3);
        }
    }
}

