/*
 * Decompiled with CFR 0.152.
 */
package p455w0rd.wpt.init;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.FMLEventChannel;
import net.minecraftforge.fml.common.network.FMLNetworkEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import p455w0rd.ae2wtlib.api.networking.IPacketHandler;
import p455w0rd.wpt.WPT;
import p455w0rd.wpt.init.ModGuiHandler;
import p455w0rd.wpt.sync.WPTPacket;
import p455w0rd.wpt.sync.network.WPTClientPacketHandler;
import p455w0rd.wpt.sync.network.WPTServerPacketHandler;

public class ModNetworking {
    private static final ModNetworking INSTANCE = new ModNetworking();
    private static final String CHANNEL_NAME = "WPT";
    private static final FMLEventChannel CHANNEL = NetworkRegistry.INSTANCE.newEventDrivenChannel("WPT");
    private static final IPacketHandler clientHandler = WPTClientPacketHandler.instance();
    private static final IPacketHandler serverHandler = WPTServerPacketHandler.instance();

    private ModNetworking() {
    }

    public static void preInit() {
        MinecraftForge.EVENT_BUS.register((Object)ModNetworking.instance());
        ModNetworking.getEventChannel().register((Object)ModNetworking.instance());
    }

    public static void postInit() {
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)WPT.INSTANCE, (IGuiHandler)new ModGuiHandler());
    }

    public static ModNetworking instance() {
        return INSTANCE;
    }

    public static FMLEventChannel getEventChannel() {
        return CHANNEL;
    }

    public IPacketHandler getClientHandler() {
        return clientHandler;
    }

    public IPacketHandler getServerHandler() {
        return serverHandler;
    }

    public String getChannel() {
        return CHANNEL_NAME;
    }

    public void sendToAll(WPTPacket message) {
        ModNetworking.getEventChannel().sendToAll(message.getProxy());
    }

    public void sendTo(WPTPacket message, EntityPlayerMP player) {
        ModNetworking.getEventChannel().sendTo(message.getProxy(), player);
    }

    public void sendToAllAround(WPTPacket message, NetworkRegistry.TargetPoint point) {
        ModNetworking.getEventChannel().sendToAllAround(message.getProxy(), point);
    }

    public void sendToDimension(WPTPacket message, int dimensionId) {
        ModNetworking.getEventChannel().sendToDimension(message.getProxy(), dimensionId);
    }

    public void sendToServer(WPTPacket message) {
        ModNetworking.getEventChannel().sendToServer(message.getProxy());
    }

    @SubscribeEvent
    public void serverPacket(FMLNetworkEvent.ServerCustomPacketEvent ev) {
        NetHandlerPlayServer srv = (NetHandlerPlayServer)ev.getPacket().handler();
        WPTServerPacketHandler.instance().onPacketData(null, ev.getHandler(), ev.getPacket(), (EntityPlayer)srv.field_147369_b);
    }

    @SubscribeEvent
    public void clientPacket(FMLNetworkEvent.ClientCustomPacketEvent ev) {
        WPTClientPacketHandler.instance().onPacketData(null, ev.getHandler(), ev.getPacket(), null);
    }
}

