/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.client;

import com.builtbroken.jlib.data.vector.IPos3D;
import icbm.classic.CommonProxy;
import icbm.classic.client.fx.ParticleAirICBM;
import icbm.classic.client.fx.ParticleSmokeICBM;
import icbm.classic.content.entity.missile.EntityMissile;
import icbm.classic.content.entity.missile.MissileFlightType;
import icbm.classic.lib.transform.vector.Pos;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ClientProxy
extends CommonProxy {
    @Override
    public void spawnSmoke(World world, Pos position, double v, double v1, double v2, float red, float green, float blue, float scale, int ticksToLive) {
        if (world != null) {
            ParticleSmokeICBM particleSmokeICBM = new ParticleSmokeICBM(world, position, v, v1, v2, scale);
            particleSmokeICBM.setColor(red, green, blue, true);
            particleSmokeICBM.setAge(ticksToLive);
            Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)particleSmokeICBM);
        }
    }

    @Override
    public void spawnAirParticle(World world, Pos position, double v, double v1, double v2, float red, float green, float blue, float scale, int ticksToLive) {
        if (world != null) {
            ParticleAirICBM particleAirParticleICBM = new ParticleAirICBM(world, position, v, v1, v2, scale);
            particleAirParticleICBM.setColor(red, green, blue, true);
            particleAirParticleICBM.setAge(ticksToLive);
            Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)particleAirParticleICBM);
        }
    }

    @Override
    public void spawnMissileSmoke(EntityMissile missile) {
        block7: {
            block8: {
                Pos position;
                block9: {
                    if (!missile.field_70170_p.field_72995_K) break block7;
                    if (missile.missileType != MissileFlightType.PAD_LAUNCHER) break block8;
                    if (!(missile.field_70181_x > -1.0) || !missile.field_70170_p.field_72995_K || !(missile.field_70181_x > -1.0)) break block7;
                    if (missile.launcherHasAirBelow == -1) {
                        BlockPos bp = new BlockPos(Math.signum(missile.field_70165_t) * Math.floor(Math.abs(missile.field_70165_t)), missile.field_70163_u - 2.0, Math.signum(missile.field_70161_v) * Math.floor(Math.abs(missile.field_70161_v)));
                        missile.launcherHasAirBelow = missile.field_70170_p.func_175623_d(bp) ? 1 : 0;
                    }
                    position = new Pos((IPos3D)missile);
                    double distance = -1.2f;
                    double y = Math.sin(Math.toRadians(missile.field_70125_A)) * distance;
                    double dH = Math.cos(Math.toRadians(missile.field_70125_A)) * distance;
                    double x = Math.sin(Math.toRadians(missile.field_70177_z)) * dH;
                    double z = Math.cos(Math.toRadians(missile.field_70177_z)) * dH;
                    position = (Pos)position.add(x, y, z);
                    if (missile.preLaunchSmokeTimer <= 0 || missile.ticksInAir > missile.getMaxPreLaunchSmokeTimer()) break block9;
                    Pos launcherSmokePosition = (Pos)position.sub(0.0, 2.0, 0.0);
                    if (missile.launcherHasAirBelow == 1) {
                        Pos velocity = (Pos)new Pos(0.0, -1.0, 0.0).addRandom(missile.field_70170_p.field_73012_v, 0.5);
                        for (int i = 0; i < 10; ++i) {
                            this.spawnAirParticle(missile.field_70170_p, launcherSmokePosition, velocity.x(), velocity.y(), velocity.z(), 1.0f, 1.0f, 1.0f, 8.0f, 180);
                            launcherSmokePosition = (Pos)launcherSmokePosition.multiply(1.0 - 0.025 * Math.random(), 1.0 - 0.025 * Math.random(), 1.0 - 0.025 * Math.random());
                        }
                    }
                    for (int i = 0; i < 5; ++i) {
                        Pos velocity = (Pos)new Pos(0.0, 0.25, 0.0).addRandom(missile.field_70170_p.field_73012_v, 0.125);
                        this.spawnAirParticle(missile.field_70170_p, position, velocity.x(), velocity.y(), velocity.z(), 1.0f, 1.0f, 1.0f, 5.0f, 40);
                    }
                    break block7;
                }
                missile.getLastSmokePos().add(position);
                Pos lastPos = null;
                if (missile.getLastSmokePos().size() > 5) {
                    lastPos = missile.getLastSmokePos().get(0);
                    missile.getLastSmokePos().remove(0);
                }
                this.spawnAirParticle(missile.field_70170_p, position, -missile.field_70159_w * 0.75, -missile.field_70181_x * 0.75, -missile.field_70179_y * 0.75, 1.0f, 0.75f, 0.0f, 5.0f, 10);
                if (missile.ticksInAir <= 5 || lastPos == null) break block7;
                for (int i = 0; i < 10; ++i) {
                    this.spawnAirParticle(missile.field_70170_p, lastPos, -missile.field_70159_w * 0.5, -missile.field_70181_x * 0.5, -missile.field_70179_y * 0.5, 1.0f, 1.0f, 1.0f, (int)Math.max(1.0, 6.0 * (1.0 / (1.0 + missile.field_70163_u / 100.0))), 100);
                    position.multiply(1.0 - 0.025 * Math.random(), 1.0 - 0.025 * Math.random(), 1.0 - 0.025 * Math.random());
                }
                break block7;
            }
            Pos position = new Pos((IPos3D)missile);
            double distance = -1.2f;
            double y = Math.sin(Math.toRadians(missile.field_70125_A)) * distance;
            double dH = Math.cos(Math.toRadians(missile.field_70125_A)) * distance;
            double x = Math.sin(Math.toRadians(missile.field_70177_z)) * dH;
            double z = Math.cos(Math.toRadians(missile.field_70177_z)) * dH;
            position = (Pos)position.add(x, y, z);
            for (int i = 0; i < 10; ++i) {
                this.spawnAirParticle(missile.field_70170_p, position, -missile.field_70159_w * 0.5, -missile.field_70181_x * 0.5, -missile.field_70179_y * 0.5, 1.0f, 1.0f, 1.0f, (int)Math.max(1.0, 6.0 * (1.0 / (1.0 + missile.field_70163_u / 100.0))), 100);
                position.multiply(1.0 - 0.025 * Math.random(), 1.0 - 0.025 * Math.random(), 1.0 - 0.025 * Math.random());
            }
        }
    }
}

