/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.item.block;

import ic2.core.IC2;
import ic2.core.item.block.ItemBlockRare;
import ic2.core.platform.lang.components.base.LocaleComp;
import ic2.core.platform.lang.storage.Ic2BlockLang;
import ic2.core.platform.lang.storage.Ic2InfoLang;
import ic2.core.platform.player.PlayerHandler;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemBlockGenerator
extends ItemBlockRare {
    public ItemBlockGenerator(Block block) {
        super(block);
        this.func_77627_a(true);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        PlayerHandler handler = PlayerHandler.getClientPlayerHandler();
        if (handler.hasEUReader()) {
            tooltip.add(Ic2InfoLang.electricProduction.getLocalizedFormatted(this.getProduction(stack.func_77960_j())));
        }
        if (stack.func_77960_j() == 13) {
            tooltip.add(Ic2InfoLang.updatesSlowly.getLocalized());
        }
    }

    private double getEnergyProduction(int meta) {
        switch (meta) {
            case 0: {
                return IC2.config.getInt("energyGeneratorBase");
            }
            case 1: {
                return IC2.config.getInt("energyGeneratorGeo");
            }
            case 2: {
                return IC2.config.getInt("energyGeneratorWater") / 100;
            }
            case 3: {
                return IC2.config.getInt("energyGeneratorSolar") / 100;
            }
            case 7: {
                return 40.0;
            }
            case 8: {
                return IC2.config.getFloat("thermalEnergy");
            }
            case 9: {
                return IC2.config.getInt("energyGeneratorSolarTurbine") / 100 * 10;
            }
            case 11: {
                return IC2.config.getFloat("ScrapGenerator");
            }
        }
        return 0.0;
    }

    private String getProduction(int meta) {
        if (meta == 5 || meta == 6 || meta == 10 || meta == 12 || meta == 13) {
            return Ic2InfoLang.electricTransferRateVariable.getLocalized();
        }
        if (meta == 4) {
            return "1-32";
        }
        return "" + this.getEnergyProduction(meta);
    }

    @Override
    public LocaleComp getLangComponent(ItemStack stack) {
        switch (stack.func_77960_j()) {
            case 0: {
                return Ic2BlockLang.generator;
            }
            case 1: {
                return Ic2BlockLang.geothermalGen;
            }
            case 2: {
                return Ic2BlockLang.waterMill;
            }
            case 3: {
                return Ic2BlockLang.solarPanel;
            }
            case 4: {
                return Ic2BlockLang.windMill;
            }
            case 5: {
                return Ic2BlockLang.nuclearReactor;
            }
            case 6: {
                return Ic2BlockLang.steamReactor;
            }
            case 7: {
                return Ic2BlockLang.steamTurbine;
            }
            case 8: {
                return Ic2BlockLang.thermalGen;
            }
            case 9: {
                return Ic2BlockLang.solarTurbine;
            }
            case 10: {
                return Ic2BlockLang.liquidFuelGenerator;
            }
            case 11: {
                return Ic2BlockLang.slagGenerator;
            }
            case 12: {
                return Ic2BlockLang.waveGenerator;
            }
            case 13: {
                return Ic2BlockLang.oceanGenerator;
            }
            case 14: {
                return Ic2BlockLang.boiler;
            }
        }
        return super.getLangComponent(stack);
    }
}

