/*
 * Decompiled with CFR 0.152.
 */
package vswe.superfactory.components.internal;

import vswe.superfactory.Localization;
import vswe.superfactory.components.ComponentMenu;
import vswe.superfactory.components.ComponentMenuBUDs;
import vswe.superfactory.components.ComponentMenuCamouflage;
import vswe.superfactory.components.ComponentMenuCamouflageInside;
import vswe.superfactory.components.ComponentMenuCamouflageItems;
import vswe.superfactory.components.ComponentMenuCamouflageShape;
import vswe.superfactory.components.ComponentMenuCamouflageSides;
import vswe.superfactory.components.ComponentMenuContainerScrap;
import vswe.superfactory.components.ComponentMenuContainerTypes;
import vswe.superfactory.components.ComponentMenuContainerTypesVariable;
import vswe.superfactory.components.ComponentMenuCrafting;
import vswe.superfactory.components.ComponentMenuCraftingPriority;
import vswe.superfactory.components.ComponentMenuEmitters;
import vswe.superfactory.components.ComponentMenuFluid;
import vswe.superfactory.components.ComponentMenuFluidCondition;
import vswe.superfactory.components.ComponentMenuFluidOutput;
import vswe.superfactory.components.ComponentMenuGroup;
import vswe.superfactory.components.ComponentMenuInterval;
import vswe.superfactory.components.ComponentMenuInventory;
import vswe.superfactory.components.ComponentMenuInventoryCondition;
import vswe.superfactory.components.ComponentMenuItem;
import vswe.superfactory.components.ComponentMenuItemCondition;
import vswe.superfactory.components.ComponentMenuItemOutput;
import vswe.superfactory.components.ComponentMenuListOrder;
import vswe.superfactory.components.ComponentMenuListOrderVariable;
import vswe.superfactory.components.ComponentMenuNodes;
import vswe.superfactory.components.ComponentMenuPulse;
import vswe.superfactory.components.ComponentMenuReceivers;
import vswe.superfactory.components.ComponentMenuRedstoneOutput;
import vswe.superfactory.components.ComponentMenuRedstoneSidesEmitter;
import vswe.superfactory.components.ComponentMenuRedstoneSidesNodes;
import vswe.superfactory.components.ComponentMenuRedstoneSidesTrigger;
import vswe.superfactory.components.ComponentMenuRedstoneStrength;
import vswe.superfactory.components.ComponentMenuRedstoneStrengthNodes;
import vswe.superfactory.components.ComponentMenuResult;
import vswe.superfactory.components.ComponentMenuSignText;
import vswe.superfactory.components.ComponentMenuSigns;
import vswe.superfactory.components.ComponentMenuSplit;
import vswe.superfactory.components.ComponentMenuTank;
import vswe.superfactory.components.ComponentMenuTankCondition;
import vswe.superfactory.components.ComponentMenuTargetInventory;
import vswe.superfactory.components.ComponentMenuTargetTank;
import vswe.superfactory.components.ComponentMenuUpdateBlock;
import vswe.superfactory.components.ComponentMenuVariable;
import vswe.superfactory.components.ComponentMenuVariableContainers;
import vswe.superfactory.components.ComponentMenuVariableLoop;
import vswe.superfactory.components.internal.ConnectionSet;

public enum ComponentType {
    TRIGGER(0, Localization.TRIGGER_SHORT, Localization.TRIGGER_LONG, new ConnectionSet[]{ConnectionSet.CONTINUOUSLY, ConnectionSet.REDSTONE, ConnectionSet.BUD}, ComponentMenuReceivers.class, ComponentMenuBUDs.class, ComponentMenuInterval.class, ComponentMenuRedstoneSidesTrigger.class, ComponentMenuRedstoneStrength.class, ComponentMenuUpdateBlock.class, ComponentMenuResult.class),
    INPUT(1, Localization.INPUT_SHORT, Localization.INPUT_LONG, new ConnectionSet[]{ConnectionSet.STANDARD}, ComponentMenuInventory.class, ComponentMenuTargetInventory.class, ComponentMenuItem.class, ComponentMenuResult.class),
    OUTPUT(2, Localization.OUTPUT_SHORT, Localization.OUTPUT_LONG, new ConnectionSet[]{ConnectionSet.STANDARD}, ComponentMenuInventory.class, ComponentMenuTargetInventory.class, ComponentMenuItemOutput.class, ComponentMenuResult.class),
    CONDITION(3, Localization.CONDITION_SHORT, Localization.CONDITION_LONG, new ConnectionSet[]{ConnectionSet.STANDARD_CONDITION}, ComponentMenuInventoryCondition.class, ComponentMenuTargetInventory.class, ComponentMenuItemCondition.class, ComponentMenuResult.class),
    FLOW_CONTROL(4, Localization.FLOW_CONTROL_SHORT, Localization.FLOW_CONTROL_LONG, new ConnectionSet[]{ConnectionSet.MULTIPLE_INPUT_2, ConnectionSet.MULTIPLE_INPUT_5, ConnectionSet.MULTIPLE_OUTPUT_2, ConnectionSet.MULTIPLE_OUTPUT_5}, ComponentMenuSplit.class, ComponentMenuResult.class),
    FLUID_INPUT(5, Localization.FLUID_INPUT_SHORT, Localization.FLUID_INPUT_LONG, new ConnectionSet[]{ConnectionSet.STANDARD}, ComponentMenuTank.class, ComponentMenuTargetTank.class, ComponentMenuFluid.class, ComponentMenuResult.class),
    FLUID_OUTPUT(6, Localization.FLUID_OUTPUT_SHORT, Localization.FLUID_OUTPUT_LONG, new ConnectionSet[]{ConnectionSet.STANDARD}, ComponentMenuTank.class, ComponentMenuTargetTank.class, ComponentMenuFluidOutput.class, ComponentMenuResult.class),
    FLUID_CONDITION(7, Localization.FLUID_CONDITION_SHORT, Localization.FLUID_CONDITION_LONG, new ConnectionSet[]{ConnectionSet.STANDARD_CONDITION}, ComponentMenuTankCondition.class, ComponentMenuTargetTank.class, ComponentMenuFluidCondition.class, ComponentMenuResult.class),
    REDSTONE_EMITTER(8, Localization.REDSTONE_EMITTER_SHORT, Localization.REDSTONE_EMITTER_LONG, new ConnectionSet[]{ConnectionSet.STANDARD}, ComponentMenuEmitters.class, ComponentMenuRedstoneSidesEmitter.class, ComponentMenuRedstoneOutput.class, ComponentMenuPulse.class, ComponentMenuResult.class),
    REDSTONE_CONDITION(9, Localization.REDSTONE_CONDITION_SHORT, Localization.REDSTONE_CONDITION_LONG, new ConnectionSet[]{ConnectionSet.STANDARD_CONDITION}, ComponentMenuNodes.class, ComponentMenuRedstoneSidesNodes.class, ComponentMenuRedstoneStrengthNodes.class, ComponentMenuResult.class),
    VARIABLE(10, Localization.CONTAINER_VARIABLE_SHORT, Localization.CONTAINER_VARIABLE_LONG, new ConnectionSet[]{ConnectionSet.EMPTY, ConnectionSet.STANDARD}, ComponentMenuVariable.class, ComponentMenuContainerTypesVariable.class, ComponentMenuVariableContainers.class, ComponentMenuListOrderVariable.class, ComponentMenuResult.class),
    FOR_EACH(11, Localization.FOR_EACH_LOOP_SHORT, Localization.FOR_EACH_LOOP_LONG, new ConnectionSet[]{ConnectionSet.FOR_EACH}, ComponentMenuVariableLoop.class, ComponentMenuContainerTypes.class, ComponentMenuListOrder.class, ComponentMenuResult.class),
    AUTO_CRAFTING(12, Localization.AUTO_CRAFTER_SHORT, Localization.AUTO_CRAFTER_LONG, new ConnectionSet[]{ConnectionSet.STANDARD}, ComponentMenuCrafting.class, ComponentMenuCraftingPriority.class, ComponentMenuContainerScrap.class, ComponentMenuResult.class),
    GROUP(13, Localization.GROUP_SHORT, Localization.GROUP_LONG, new ConnectionSet[]{ConnectionSet.DYNAMIC}, ComponentMenuGroup.class, ComponentMenuResult.class),
    NODE(14, Localization.NODE_SHORT, Localization.NODE_LONG, new ConnectionSet[]{ConnectionSet.INPUT_NODE, ConnectionSet.OUTPUT_NODE}, ComponentMenuResult.class),
    CAMOUFLAGE(15, Localization.CAMOUFLAGE_SHORT, Localization.CAMOUFLAGE_LONG, new ConnectionSet[]{ConnectionSet.STANDARD}, ComponentMenuCamouflage.class, ComponentMenuCamouflageShape.class, ComponentMenuCamouflageInside.class, ComponentMenuCamouflageSides.class, ComponentMenuCamouflageItems.class, ComponentMenuResult.class),
    SIGN(16, Localization.SIGN_SHORT, Localization.SIGN_LONG, new ConnectionSet[]{ConnectionSet.STANDARD}, ComponentMenuSigns.class, ComponentMenuSignText.class, ComponentMenuResult.class);

    private Class<? extends ComponentMenu>[] classes;
    private int id;
    private Localization longName;
    private Localization name;
    private ConnectionSet[] sets;

    private ComponentType(int id, Localization name, Localization longName, ConnectionSet[] sets, Class<? extends ComponentMenu> ... classes) {
        this.classes = classes;
        this.id = id;
        this.sets = sets;
        this.name = name;
        this.longName = longName;
    }

    public static ComponentType getTypeFromId(int id) {
        for (ComponentType componentType : ComponentType.values()) {
            if (id != componentType.id) continue;
            return componentType;
        }
        return null;
    }

    public Class<? extends ComponentMenu>[] getClasses() {
        return this.classes;
    }

    public int getId() {
        return this.id;
    }

    public ConnectionSet[] getSets() {
        return this.sets;
    }

    public String toString() {
        return this.getName() + "[" + this.getLongName() + "]";
    }

    public String getName() {
        return this.name.toString();
    }

    public String getLongName() {
        return this.longName.toString();
    }

    public Localization getLongUnLocalizedName() {
        return this.longName;
    }
}

