/*
 * Decompiled with CFR 0.152.
 */
package io.github.aquerr.eaglefactions.common.integrations.dynmap;

import io.github.aquerr.eaglefactions.api.EagleFactions;
import io.github.aquerr.eaglefactions.api.entities.Faction;
import io.github.aquerr.eaglefactions.common.integrations.dynmap.DynmapUpdateTask;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import org.dynmap.DynmapCommonAPI;
import org.dynmap.DynmapCommonAPIListener;
import org.dynmap.markers.AreaMarker;
import org.dynmap.markers.GenericMarker;
import org.dynmap.markers.Marker;
import org.dynmap.markers.MarkerAPI;
import org.dynmap.markers.MarkerSet;
import org.spongepowered.api.scheduler.Task;

public class DynmapService {
    static MarkerAPI markerapi;
    static MarkerSet markerSet;
    static final ArrayList<Faction> drawnFactions;
    static final HashMap<String, Marker> drawnMarkers;
    static final HashMap<String, ArrayList<AreaMarker>> drawnAreas;
    private final EagleFactions plugin;

    public DynmapService(EagleFactions plugin) {
        this.plugin = plugin;
    }

    public void activate() {
        DynmapCommonAPIListener.register((DynmapCommonAPIListener)new DynmapCommonAPIListener(){

            public void apiEnabled(DynmapCommonAPI api) {
                markerapi = api.getMarkerAPI();
                markerSet = markerapi.createMarkerSet("purpleflag", "EagleFactions", markerapi.getMarkerIcons(), false);
                Task.builder().execute((Runnable)new DynmapUpdateTask()).interval(10L, TimeUnit.SECONDS).name("EagleFactions Dynmap Update Task").async().submit((Object)DynmapService.this.plugin);
            }
        });
    }

    public void reload() {
        drawnFactions.clear();
        drawnMarkers.values().forEach(GenericMarker::deleteMarker);
        drawnMarkers.clear();
        drawnAreas.values().forEach(x -> {
            x.forEach(GenericMarker::deleteMarker);
            x.clear();
        });
        drawnAreas.clear();
    }

    static {
        drawnFactions = new ArrayList();
        drawnMarkers = new HashMap();
        drawnAreas = new HashMap();
    }
}

