/*
 * Decompiled with CFR 0.152.
 */
package p455w0rd.wft.sync.packets;

import appeng.api.storage.data.IAEItemStack;
import appeng.client.ClientHelper;
import appeng.container.ContainerOpenContext;
import appeng.helpers.InventoryAction;
import appeng.util.Platform;
import appeng.util.item.AEItemStack;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import p455w0rd.ae2wtlib.api.networking.INetworkInfo;
import p455w0rd.wft.container.ContainerWFT;
import p455w0rd.wft.sync.WFTPacket;

public class PacketInventoryAction
extends WFTPacket {
    private final InventoryAction action;
    private final int slot;
    private final long id;
    private final IAEItemStack slotItem;

    public PacketInventoryAction(ByteBuf stream) throws IOException {
        this.action = InventoryAction.values()[stream.readInt()];
        this.slot = stream.readInt();
        this.id = stream.readLong();
        boolean hasItem = stream.readBoolean();
        this.slotItem = hasItem ? AEItemStack.fromPacket((ByteBuf)stream) : null;
    }

    public PacketInventoryAction(InventoryAction action, int slot, IAEItemStack slotItem) throws IOException {
        if (Platform.isClient()) {
            throw new IllegalStateException("invalid packet, client cannot post inv actions with stacks.");
        }
        this.action = action;
        this.slot = slot;
        this.id = 0L;
        this.slotItem = slotItem;
        ByteBuf data = Unpooled.buffer();
        data.writeInt(this.getPacketID());
        data.writeInt(action.ordinal());
        data.writeInt(slot);
        data.writeLong(this.id);
        if (slotItem == null) {
            data.writeBoolean(false);
        } else {
            data.writeBoolean(true);
            slotItem.writeToPacket(data);
        }
        this.configureWrite(data);
    }

    public PacketInventoryAction(InventoryAction action, int slot, long id) {
        this.action = action;
        this.slot = slot;
        this.id = id;
        this.slotItem = null;
        ByteBuf data = Unpooled.buffer();
        data.writeInt(this.getPacketID());
        data.writeInt(action.ordinal());
        data.writeInt(slot);
        data.writeLong(id);
        data.writeBoolean(false);
        this.configureWrite(data);
    }

    @Override
    public void serverPacketData(INetworkInfo manager, WFTPacket packet, EntityPlayer player) {
        EntityPlayerMP sender = (EntityPlayerMP)player;
        Container baseContainer = sender.field_71070_bA;
        ContainerOpenContext context = null;
        if (sender.field_71070_bA instanceof ContainerWFT) {
            baseContainer = sender.field_71070_bA;
            context = ((ContainerWFT)baseContainer).getOpenContext();
        }
        if (baseContainer instanceof ContainerWFT) {
            ((ContainerWFT)baseContainer).doAction(sender, this.action, this.slot, this.id);
            ((ContainerWFT)baseContainer).func_75142_b();
        }
    }

    @Override
    public void clientPacketData(INetworkInfo network, WFTPacket packet, EntityPlayer player) {
        if (this.action == InventoryAction.UPDATE_HAND) {
            ClientHelper ch = new ClientHelper();
            if (this.slotItem == null) {
                ((EntityPlayer)ch.getPlayers().get((int)0)).field_71071_by.func_70437_b(ItemStack.field_190927_a);
            } else {
                ((EntityPlayer)ch.getPlayers().get((int)0)).field_71071_by.func_70437_b(this.slotItem.createItemStack());
            }
        }
    }
}

