/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.command.utils;

import java.util.ArrayList;
import java.util.List;

public class QuotedStringTokenizer {
    private final String string;
    private int cursor;

    public QuotedStringTokenizer(String string) {
        this.string = string;
    }

    public List<String> tokenize(boolean omitEmptyStringAtEnd) {
        ArrayList<String> output = new ArrayList<String>();
        while (this.hasNext()) {
            output.add(this.readString());
        }
        if (!omitEmptyStringAtEnd && this.cursor > 0 && QuotedStringTokenizer.isWhitespace(this.peek(-1))) {
            output.add("");
        }
        return output;
    }

    private static boolean isQuoteCharacter(char c) {
        return c == '\"' || c == '\u201c' || c == '\u201d';
    }

    private static boolean isWhitespace(char c) {
        return c == ' ';
    }

    private String readString() {
        if (QuotedStringTokenizer.isQuoteCharacter(this.peek())) {
            return this.readQuotedString();
        }
        return this.readUnquotedString();
    }

    private String readUnquotedString() {
        int start = this.cursor;
        while (this.hasNext() && !QuotedStringTokenizer.isWhitespace(this.peek())) {
            this.skip();
        }
        int end = this.cursor;
        if (this.hasNext()) {
            this.skip();
        }
        return this.string.substring(start, end);
    }

    private String readQuotedString() {
        this.skip();
        int start = this.cursor;
        while (this.hasNext() && !QuotedStringTokenizer.isQuoteCharacter(this.peek())) {
            this.skip();
        }
        int end = this.cursor;
        if (this.hasNext()) {
            this.skip();
        }
        if (this.hasNext() && QuotedStringTokenizer.isWhitespace(this.peek())) {
            this.skip();
        }
        return this.string.substring(start, end);
    }

    private boolean hasNext() {
        return this.cursor + 1 <= this.string.length();
    }

    private char peek() {
        return this.string.charAt(this.cursor);
    }

    private char peek(int offset) {
        return this.string.charAt(this.cursor + offset);
    }

    private void skip() {
        ++this.cursor;
    }
}

