/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.sponge.service.model.persisted;

import java.io.IOException;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import me.lucko.luckperms.common.cache.BufferedRequest;
import me.lucko.luckperms.common.plugin.LuckPermsPlugin;
import me.lucko.luckperms.sponge.service.LuckPermsService;
import me.lucko.luckperms.sponge.service.ProxyFactory;
import me.lucko.luckperms.sponge.service.events.UpdateEventHandler;
import me.lucko.luckperms.sponge.service.model.LPSubject;
import me.lucko.luckperms.sponge.service.model.LPSubjectData;
import me.lucko.luckperms.sponge.service.model.ProxiedSubject;
import me.lucko.luckperms.sponge.service.model.calculated.CalculatedSubject;
import me.lucko.luckperms.sponge.service.model.calculated.CalculatedSubjectData;
import me.lucko.luckperms.sponge.service.model.calculated.MonitoredSubjectData;
import me.lucko.luckperms.sponge.service.model.persisted.PersistedCollection;
import me.lucko.luckperms.sponge.service.model.persisted.PersistedSubjectData;
import me.lucko.luckperms.sponge.service.model.persisted.SubjectDataContainer;
import net.luckperms.api.model.data.DataType;
import org.spongepowered.api.command.CommandSource;

public class PersistedSubject
extends CalculatedSubject
implements LPSubject {
    private final LuckPermsService service;
    private final String identifier;
    private final PersistedCollection parentCollection;
    private final PersistedSubjectData subjectData;
    private final CalculatedSubjectData transientSubjectData;
    private ProxiedSubject spongeSubject = null;
    private final SaveBuffer saveBuffer;
    private boolean pendingSave = false;

    public PersistedSubject(LuckPermsService service, PersistedCollection parentCollection, String identifier) {
        super(service.getPlugin());
        this.service = service;
        this.parentCollection = parentCollection;
        this.identifier = identifier;
        this.subjectData = new PersistedSubjectData(this, DataType.NORMAL, service){

            @Override
            protected void onUpdate(boolean success) {
                super.onUpdate(success);
                if (success) {
                    PersistedSubject.this.fireUpdateEvent(this);
                }
            }
        };
        this.transientSubjectData = new MonitoredSubjectData(this, DataType.TRANSIENT, service){

            @Override
            protected void onUpdate(boolean success) {
                if (success) {
                    PersistedSubject.this.fireUpdateEvent(this);
                }
            }
        };
        this.saveBuffer = new SaveBuffer(service.getPlugin());
    }

    private void fireUpdateEvent(LPSubjectData subjectData) {
        UpdateEventHandler.fireUpdateEvent(this.service.getPlugin(), subjectData);
    }

    public void loadData(SubjectDataContainer container) {
        if (this.pendingSave) {
            return;
        }
        this.subjectData.setSave(false);
        container.applyToData(this.subjectData);
        this.subjectData.setSave(true);
    }

    public void save() {
        this.pendingSave = true;
        this.saveBuffer.request();
    }

    void doSave() {
        try {
            this.service.getStorage().saveToFile(this);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            this.pendingSave = false;
        }
    }

    @Override
    public ProxiedSubject sponge() {
        if (this.spongeSubject == null) {
            this.spongeSubject = ProxyFactory.toSponge(this);
        }
        return this.spongeSubject;
    }

    @Override
    public String getIdentifier() {
        return this.identifier;
    }

    @Override
    public LuckPermsService getService() {
        return this.service;
    }

    @Override
    public PersistedCollection getParentCollection() {
        return this.parentCollection;
    }

    @Override
    public PersistedSubjectData getSubjectData() {
        return this.subjectData;
    }

    @Override
    public CalculatedSubjectData getTransientSubjectData() {
        return this.transientSubjectData;
    }

    @Override
    public Optional<CommandSource> getCommandSource() {
        return Optional.empty();
    }

    private final class SaveBuffer
    extends BufferedRequest<Void> {
        public SaveBuffer(LuckPermsPlugin plugin) {
            super(1L, TimeUnit.SECONDS, plugin.getBootstrap().getScheduler());
        }

        @Override
        protected Void perform() {
            PersistedSubject.this.doSave();
            return null;
        }
    }
}

