/*
 * Decompiled with CFR 0.152.
 */
package com.github.terminatornl.laggoggles.profiler;

import com.github.terminatornl.laggoggles.util.ThreadChecker;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicLong;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.eventhandler.Event;

public class TimingManager {
    private Map<Integer, WorldData> WORLD_TIMINGS = Collections.synchronizedMap(new HashMap());
    private Map<EventTimings, AtomicLong> EVENT_TIMES = Collections.synchronizedMap(new HashMap());
    private GuiTimings GUI_TIMINGS = new GuiTimings();

    public HashMap<Integer, WorldData> getTimings() {
        return new HashMap<Integer, WorldData>(this.WORLD_TIMINGS);
    }

    public HashMap<EventTimings, AtomicLong> getEventTimings() {
        return new HashMap<EventTimings, AtomicLong>(this.EVENT_TIMES);
    }

    public TreeMap<BlockPos, Long> getGuiBlockTimings() {
        return this.GUI_TIMINGS.getTileEntityTimes();
    }

    public TreeMap<UUID, Long> getGuiEntityTimings() {
        return this.GUI_TIMINGS.getEntityTimes();
    }

    public void addBlockTime(int dim, BlockPos pos, long time) {
        if (!this.WORLD_TIMINGS.containsKey(dim)) {
            WorldData data = new WorldData();
            data.addBlockTime(pos, time);
            this.WORLD_TIMINGS.put(dim, data);
        } else {
            this.WORLD_TIMINGS.get(dim).addBlockTime(pos, time);
        }
    }

    public void addEntityTime(int dim, UUID uuid, long time) {
        if (!this.WORLD_TIMINGS.containsKey(dim)) {
            WorldData data = new WorldData();
            data.addEntityTime(uuid, time);
            this.WORLD_TIMINGS.put(dim, data);
        } else {
            this.WORLD_TIMINGS.get(dim).addEntityTime(uuid, time);
        }
    }

    public void addEventTime(String listener, Event event, long time) {
        EventTimings timings = new EventTimings(listener, event.getClass(), ThreadChecker.getThreadType());
        if (!this.EVENT_TIMES.containsKey(timings)) {
            this.EVENT_TIMES.put(timings, new AtomicLong(time));
        } else {
            this.EVENT_TIMES.get(timings).addAndGet(time);
        }
    }

    public void addGuiEntityTime(UUID uuid, long time) {
        this.GUI_TIMINGS.addEntityTime(uuid, time);
    }

    public void addGuiBlockTime(BlockPos pos, long time) {
        this.GUI_TIMINGS.addGuiBlockTime(pos, time);
    }

    public static class EventTimings {
        public final String listener;
        public final ThreadType threadType;
        public final Class eventClass;

        EventTimings(String listener, Class eventClass, ThreadType threadType) {
            this.listener = listener;
            this.threadType = threadType;
            this.eventClass = eventClass;
        }

        public int hashCode() {
            return this.listener.hashCode();
        }

        public boolean equals(Object o) {
            if (!(o instanceof EventTimings)) {
                return false;
            }
            EventTimings other = (EventTimings)o;
            return this.listener.equals(other.listener) && this.threadType == other.threadType && this.eventClass.equals(other.eventClass);
        }

        public static enum ThreadType {
            SERVER,
            CLIENT,
            ASYNC;

        }
    }

    public static class GuiTimings {
        private Map<UUID, AtomicLong> ENTITY_TIMINGS = Collections.synchronizedMap(new HashMap());
        private Map<BlockPos, AtomicLong> TILE_TIMINGS = Collections.synchronizedMap(new HashMap());

        public void addGuiBlockTime(BlockPos pos, long time) {
            if (!this.TILE_TIMINGS.containsKey(pos)) {
                this.TILE_TIMINGS.put(pos, new AtomicLong(time));
            } else {
                this.TILE_TIMINGS.get(pos).getAndAdd(time);
            }
        }

        public void addEntityTime(UUID uuid, long time) {
            if (!this.ENTITY_TIMINGS.containsKey(uuid)) {
                this.ENTITY_TIMINGS.put(uuid, new AtomicLong(time));
            } else {
                this.ENTITY_TIMINGS.get(uuid).getAndAdd(time);
            }
        }

        public TreeMap<UUID, Long> getEntityTimes() {
            TreeMap<UUID, Long> data = new TreeMap<UUID, Long>();
            for (Map.Entry<UUID, AtomicLong> entry : this.ENTITY_TIMINGS.entrySet()) {
                data.put(entry.getKey(), entry.getValue().longValue());
            }
            return data;
        }

        public TreeMap<BlockPos, Long> getTileEntityTimes() {
            TreeMap<BlockPos, Long> data = new TreeMap<BlockPos, Long>();
            for (Map.Entry<BlockPos, AtomicLong> entry : this.TILE_TIMINGS.entrySet()) {
                data.put(entry.getKey(), entry.getValue().longValue());
            }
            return data;
        }
    }

    public static class WorldData {
        private Map<BlockPos, AtomicLong> blockTimes = Collections.synchronizedMap(new HashMap());
        private Map<UUID, AtomicLong> entityTimes = Collections.synchronizedMap(new HashMap());

        public void addBlockTime(BlockPos pos, long time) {
            if (!this.blockTimes.containsKey(pos)) {
                this.blockTimes.put(pos, new AtomicLong(time));
            } else {
                this.blockTimes.get(pos).addAndGet(time);
            }
        }

        public void addEntityTime(UUID entity, long time) {
            if (!this.entityTimes.containsKey(entity)) {
                this.entityTimes.put(entity, new AtomicLong(time));
            } else {
                this.entityTimes.get(entity).addAndGet(time);
            }
        }

        public TreeMap<BlockPos, Long> getBlockTimes() {
            TreeMap<BlockPos, Long> data = new TreeMap<BlockPos, Long>();
            for (Map.Entry<BlockPos, AtomicLong> entry : this.blockTimes.entrySet()) {
                data.put(entry.getKey(), entry.getValue().longValue());
            }
            return data;
        }

        public TreeMap<UUID, Long> getEntityTimes() {
            TreeMap<UUID, Long> data = new TreeMap<UUID, Long>();
            for (Map.Entry<UUID, AtomicLong> entry : this.entityTimes.entrySet()) {
                data.put(entry.getKey(), entry.getValue().longValue());
            }
            return data;
        }
    }
}

