/*
 * Decompiled with CFR 0.152.
 */
package com.github.terminatornl.tiquality;

import com.github.terminatornl.tiquality.TiqualityConfig;
import com.github.terminatornl.tiquality.api.Tracking;
import com.github.terminatornl.tiquality.command.CommandHub;
import com.github.terminatornl.tiquality.integration.ExternalHooker;
import com.github.terminatornl.tiquality.interfaces.TickExecutor;
import com.github.terminatornl.tiquality.mixinhelper.MixinConfigPlugin;
import com.github.terminatornl.tiquality.mixinhelper.MixinValidator;
import com.github.terminatornl.tiquality.monitor.BlockPlaceMonitor;
import com.github.terminatornl.tiquality.monitor.ChunkLoadMonitor;
import com.github.terminatornl.tiquality.monitor.EntityMonitor;
import com.github.terminatornl.tiquality.monitor.ServerWorldLoadMonitor;
import com.github.terminatornl.tiquality.monitor.TPSMonitor;
import com.github.terminatornl.tiquality.monitor.TickMaster;
import com.github.terminatornl.tiquality.tracking.ForcedTracker;
import com.github.terminatornl.tiquality.tracking.PlayerTracker;
import com.github.terminatornl.tiquality.tracking.UpdateType;
import com.github.terminatornl.tiquality.tracking.event.EntitySetTrackerEventHandler;
import com.github.terminatornl.tiquality.tracking.tickexecutors.ForgeTickExecutor;
import com.github.terminatornl.tiquality.tracking.tickexecutors.SpongeTickExecutor;
import com.github.terminatornl.tiquality.util.PersistentData;
import com.github.terminatornl.tiquality.util.Scheduler;
import com.github.terminatornl.tiquality.world.WorldHelper;
import java.util.SplittableRandom;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerAboutToStartEvent;
import net.minecraftforge.fml.common.event.FMLServerStoppedEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.FMLNetworkEvent;
import net.minecraftforge.fml.relauncher.IFMLLoadingPlugin;
import org.apache.logging.log4j.Logger;

@Mod(modid="tiquality", name="Tiquality", version="FAT-1.12.2-GAMMA-1.8.1-124", acceptableRemoteVersions="*", acceptedMinecraftVersions="[1.12.2]")
@IFMLLoadingPlugin.SortingIndex(value=1001)
public class Tiquality {
    public static final String NAME = "Tiquality";
    public static final String MODID = "tiquality";
    public static final String VERSION = "FAT-1.12.2-GAMMA-1.8.1-124";
    public static final String DESCRIPTION = "Evenly distribute tick time amongst player, its time we all tick equally!";
    public static final String URL = "https://minecraft.curseforge.com/projects/tiquality";
    public static final String[] AUTHORS = new String[]{"Terminator_NL"};
    public static final String PREFIX = TextFormatting.DARK_GRAY + "[" + TextFormatting.GREEN + "Tiquality" + TextFormatting.DARK_GRAY + "] " + TextFormatting.GRAY;
    public static final SplittableRandom RANDOM = new SplittableRandom();
    public static final TPSMonitor TPS_MONITOR = TPSMonitor.INSTANCE;
    public static final Scheduler SCHEDULER = Scheduler.INSTANCE;
    public static TickExecutor TICK_EXECUTOR = new ForgeTickExecutor();
    public static Tiquality INSTANCE;
    public static Logger LOGGER;
    private TickMaster TICK_MASTER;

    public Tiquality() {
        INSTANCE = this;
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public static void log_sync(final String str) {
        SCHEDULER.schedule(new Runnable(){

            @Override
            public void run() {
                LOGGER.info(str);
            }
        });
    }

    @Mod.EventHandler
    public void preinit(FMLPreInitializationEvent e) {
        LOGGER = e.getModLog();
        if (!MixinConfigPlugin.MIXIN_CONFIG_PLUGIN_WAS_LOADED) {
            LOGGER.fatal("The MixinConfigPlugin has not been activated. (com.github.terminatornl.tiquality.mixinhelper.MixinConfigPlugin)");
            LOGGER.fatal("To prevent you from wasting your time, the process has ended.");
            LOGGER.fatal("-> Did you put the Tiquality.jar directly in /mods? Sub-folders are not supported.");
            LOGGER.fatal("-> Is mixin in the classpath, and initialized? It should have printed some messages by now.");
            try {
                Class.forName("org.spongepowered.asm.launch.MixinTweaker", false, this.getClass().getClassLoader());
                LOGGER.fatal("It looks like you actually have Mixin in the classpath... If you're in a development environment, don't forget to add this argument: ");
                LOGGER.fatal("");
                LOGGER.fatal("--tweakClass org.spongepowered.asm.launch.MixinTweaker");
                LOGGER.fatal("");
                LOGGER.fatal("If you are sure you have done the above correctly, please report this to Terminator_NL.");
            }
            catch (ClassNotFoundException ignored_2) {
                LOGGER.fatal("It looks like you do not have Mixin installed. Please do one of the following solutions: ");
                LOGGER.fatal("- Use the FAT version of Tiquality (Recommended)");
                LOGGER.fatal("- Install SpongeForge");
                LOGGER.fatal("- Install something ships the Mixin library. (See https://github.com/SpongePowered/Mixin)");
                LOGGER.fatal("- Add Mixin to the classpath yourself (See https://github.com/SpongePowered/Mixin)");
            }
            FMLCommonHandler.instance().exitJava(1, true);
        }
        MinecraftForge.EVENT_BUS.register((Object)SCHEDULER);
    }

    @Mod.EventHandler
    public void preinit(FMLInitializationEvent e) {
        if (Loader.isModLoaded((String)"sponge")) {
            TICK_EXECUTOR = new SpongeTickExecutor();
        }
    }

    @SubscribeEvent
    public void onClientConnectedToServerEvent(FMLNetworkEvent.ClientConnectedToServerEvent e) {
        UpdateType.WORLD_IS_REMOTE = !e.isLocal();
    }

    @Mod.EventHandler
    public void onPost(FMLInitializationEvent e) {
        ExternalHooker.init();
        MixinValidator.validate();
    }

    @Mod.EventHandler
    public void onPreServerStart(FMLServerAboutToStartEvent e) {
        if (Loader.isModLoaded((String)"sponge")) {
            CommandHub.INSTANCE.initSponge();
        } else {
            CommandHub.INSTANCE.initForge();
        }
        this.TICK_MASTER = new TickMaster(e.getServer());
        MinecraftForge.EVENT_BUS.register((Object)this.TICK_MASTER);
        MinecraftForge.EVENT_BUS.register((Object)TPS_MONITOR);
        MinecraftForge.EVENT_BUS.register((Object)BlockPlaceMonitor.INSTANCE);
        MinecraftForge.EVENT_BUS.register((Object)ChunkLoadMonitor.INSTANCE);
        MinecraftForge.EVENT_BUS.register((Object)EntityMonitor.INSTANCE);
        MinecraftForge.EVENT_BUS.register((Object)WorldHelper.SmearedAction.INSTANCE);
        MinecraftForge.EVENT_BUS.register((Object)TiqualityConfig.Listener.INSTANCE);
        MinecraftForge.EVENT_BUS.register((Object)EntitySetTrackerEventHandler.INSTANCE);
        MinecraftForge.EVENT_BUS.register((Object)ServerWorldLoadMonitor.INSTANCE);
        TiqualityConfig.QuickConfig.update();
        Tracking.registerCustomTracker("PlayerTracker", PlayerTracker.class);
        Tracking.registerCustomTracker("Forced", ForcedTracker.class);
    }

    @Mod.EventHandler
    public void onServerStopped(FMLServerStoppedEvent e) {
        CommandHub.INSTANCE.reset();
        PersistentData.deactivate();
        if (this.TICK_MASTER != null) {
            MinecraftForge.EVENT_BUS.unregister((Object)this.TICK_MASTER);
        }
        MinecraftForge.EVENT_BUS.unregister((Object)TPS_MONITOR);
        MinecraftForge.EVENT_BUS.unregister((Object)BlockPlaceMonitor.INSTANCE);
        MinecraftForge.EVENT_BUS.unregister((Object)ChunkLoadMonitor.INSTANCE);
        MinecraftForge.EVENT_BUS.unregister((Object)EntityMonitor.INSTANCE);
        MinecraftForge.EVENT_BUS.unregister((Object)WorldHelper.SmearedAction.INSTANCE);
        MinecraftForge.EVENT_BUS.unregister((Object)TiqualityConfig.Listener.INSTANCE);
        MinecraftForge.EVENT_BUS.unregister((Object)EntitySetTrackerEventHandler.INSTANCE);
        MinecraftForge.EVENT_BUS.unregister((Object)ServerWorldLoadMonitor.INSTANCE);
    }
}

