/*
 * Decompiled with CFR 0.152.
 */
package com.github.terminatornl.tiquality;

import com.github.terminatornl.tiquality.Tiquality;
import com.github.terminatornl.tiquality.interfaces.TiqualityEntity;
import com.github.terminatornl.tiquality.interfaces.UpdateTyped;
import com.github.terminatornl.tiquality.monitor.TickMaster;
import com.github.terminatornl.tiquality.tracking.UpdateType;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.command.CommandException;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.init.Blocks;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Config(modid="tiquality", name="Tiquality", type=Config.Type.INSTANCE, category="Tiquality")
public class TiqualityConfig {
    @Config.Comment(value={"Tiquality stores data in every affected chunk, but it's possible", "tiquality's data can get corrupted somehow. In order to still be able to use tiquality", "without resetting your world, we can store data in a different tag in the chunk.", "", "WARNING: Changing this value will erase previous data saved by tiquality, but will not", "affect other data (Your world stays intact, but tiquality has a clean slate)", "", "Just increase this number by one if you run into problems. Don't forget to submit a", "detailed bug report on Github if you run into unexpected problems.", "", "New versions of Tiquality with incompatible storage data will override this setting for you automatically."})
    public static int SAVE_VERSION = 0;
    @Config.Comment(value={"Tiquality pre-allocates the max tick time someone can use.", "This includes offline players (Loaded chunks with an offline player's base, for example)", "With this in mind, what multiplier should we use to assign tick time to them?", "", "Where 0 means offline player's base does not get any pre-allocated tick time and 1 means they will get the same tick time as an online player.", "Keep in mind that people might be living together..."})
    @Config.RangeDouble(min=0.0, max=1.0)
    public static double OFFLINE_PLAYER_TICK_TIME_MULTIPLIER = 0.5;
    @Config.Comment(value={"The alias for the /tiquality command.", "Bear in mind that when this alias is already in use by another mod, we skip command registration entirely. (Even /tiquality)"})
    public static String TIQUALITY_COMMAND_ALIAS = "tq";
    @Config.Comment(value={"A block will tick if at least one of the following statements is true:", "- There's a Tracker assigned and the tracker has enough time to tick the block", "- The block is defined in the config NATURAL_BLOCKS and there's no tracker assigned to it", "- The block is defined in the config NATURAL_BLOCKS and the tracker has enough time to tick the block", "- The block is defined in the config ALWAYS_TICKED_BLOCKS It will tick even if a tracker has been assigned that ran out of time. Note that this will still consume the time on the tracker.", "", "Try running `/tq set <below|feet> DEFAULT`. It will remove the block from the config, returning default behavior.", "Try running `/tq set <below|feet> NATURAL`. It will add the block to the config under NATURAL_BLOCKS.", "Try running `/tq set <below|feet> PRIORITY`. It will add the block to the config under PRIORITY_BLOCKS.", "Try running `/tq set <below|feet> ALWAYS_TICK`. It will add the block to the config under ALWAYS_TICKED_BLOCKS.", "Try running `/tq set <below|feet> TICK_DENIED`. It will add the block to the config under TICK_DENIED_BLOCKS.", "", "Protip: Use /tq info first, to see if you are actually positioned on the block correctly.", "", "For nicer formatting, see: https://github.com/TerminatorNL/Tiquality/blob/master/README.md#my-blocks-dont-tick-what-do-i-do"})
    public static BLOCK_TICKING BLOCK_TICK_BEHAVIOR = new BLOCK_TICKING();
    @Config.Comment(value={"Entity handling is a bit different than blocks. DEFAULT behavior is the same as NATURAL in blocks."})
    public static ENTITY_TICKING ENTITY_TICK_BEHAVIOR = new ENTITY_TICKING();
    @Config.Comment(value={"Between ticks, the server must do some internal processing.", "Increase this value if you see \"can't keep up!\" errors.", "Try to keep this value as low as possible for performance."})
    @Config.RangeInt(min=0)
    public static int TIME_BETWEEN_TICKS_IN_NS = 90000;
    @Config.Comment(value={"Define a maximum square range someone can claim using /tq claim [range].", "This will also be the default value for usage of /tq claim [range] without the range argument"})
    public static int MAX_CLAIM_RADIUS = 50;
    @Config.Comment(value={"When a tracker is being throttled, we can send a notification to the user.", "Throttling is measured by comparing the full tick cycles within ticking queues and comparing that to the server ticks.", "Every 100 server ticks the amount of completed full ticks of the tracker is compared.", "", "If the tracker is falling behind (actively throttling) the value for this tracker gets closer to zero. In", "comparison, a tracker that runs at full speed will have a value of 1 (100%)", "Whenever the value falls below the value specified here, a warning will be sent to the tracker", "", "There's currently a limitation making warning levels between 0.5 and 1.0 unreliable. (Between 50% and 100% speed)", "", "Set to 1 to disable", "", "Note: If the server is ticking at 18 TPS, the tracker can still have a value of 1. Server tick speed does not impact this value."})
    @Config.RangeDouble(min=0.0, max=1.0)
    public static double DEFAULT_THROTTLE_WARNING_LEVEL = 0.5;
    @Config.Comment(value={"When a tracker is being throttled, we can send a notification to the user.", "How often do you want the user to receive a message about his/her personal tick speed?", "", "Note: If you don't want to send a message at all, set DEFAULT_THROTTLE_WARNING_LEVEL to 1."})
    @Config.RangeInt(min=0)
    public static int DEFAULT_THROTTLE_WARNING_INTERVAL_SECONDS = 600;

    public static class Listener {
        public static final Listener INSTANCE = new Listener();

        private Listener() {
        }

        @SubscribeEvent
        public void onConfigurationChangedEvent(ConfigChangedEvent.OnConfigChangedEvent event) {
            if (event.getModID().equalsIgnoreCase("tiquality")) {
                QuickConfig.update();
            }
        }
    }

    public static class QuickConfig {
        private static final HashSet<Block> MODIFIED_BLOCKS = new HashSet();
        private static final HashMap<ResourceLocation, UpdateType> ENTITY_UPDATE_TYPES = new HashMap();

        @Nonnull
        public static UpdateType getEntityUpdateType(ResourceLocation location) {
            UpdateType type = ENTITY_UPDATE_TYPES.get(location);
            return type != null ? type : UpdateType.DEFAULT;
        }

        public static void setEntityUpdateType(UpdateType type, ResourceLocation ... resources) {
            QuickConfig.removeEntityFromConfig(resources);
            block6: for (ResourceLocation location : resources) {
                switch (type) {
                    case DEFAULT: 
                    case NATURAL: {
                        continue block6;
                    }
                    case TICK_DENIED: {
                        TiqualityConfig.ENTITY_TICK_BEHAVIOR.TICK_DENIED_ENTITIES = QuickConfig.expensiveArrayAsListManipulationAdd(TiqualityConfig.ENTITY_TICK_BEHAVIOR.TICK_DENIED_ENTITIES, location.toString());
                        continue block6;
                    }
                    case ALWAYS_TICK: {
                        TiqualityConfig.ENTITY_TICK_BEHAVIOR.ALWAYS_TICKED_ENTITIES = QuickConfig.expensiveArrayAsListManipulationAdd(TiqualityConfig.ENTITY_TICK_BEHAVIOR.ALWAYS_TICKED_ENTITIES, location.toString());
                        continue block6;
                    }
                    case PRIORITY: {
                        TiqualityConfig.ENTITY_TICK_BEHAVIOR.PRIORITY_ENTITIES = QuickConfig.expensiveArrayAsListManipulationAdd(TiqualityConfig.ENTITY_TICK_BEHAVIOR.PRIORITY_ENTITIES, location.toString());
                    }
                }
            }
        }

        public static void setBlockUpdateType(UpdateType type, ResourceLocation ... resources) {
            QuickConfig.removeBlockFromConfig(resources);
            block7: for (ResourceLocation location : resources) {
                switch (type) {
                    case DEFAULT: {
                        continue block7;
                    }
                    case NATURAL: {
                        TiqualityConfig.BLOCK_TICK_BEHAVIOR.NATURAL_BLOCKS = QuickConfig.expensiveArrayAsListManipulationAdd(TiqualityConfig.BLOCK_TICK_BEHAVIOR.NATURAL_BLOCKS, location.toString());
                        continue block7;
                    }
                    case TICK_DENIED: {
                        TiqualityConfig.BLOCK_TICK_BEHAVIOR.TICK_DENIED_BLOCKS = QuickConfig.expensiveArrayAsListManipulationAdd(TiqualityConfig.BLOCK_TICK_BEHAVIOR.TICK_DENIED_BLOCKS, location.toString());
                        continue block7;
                    }
                    case ALWAYS_TICK: {
                        TiqualityConfig.BLOCK_TICK_BEHAVIOR.ALWAYS_TICKED_BLOCKS = QuickConfig.expensiveArrayAsListManipulationAdd(TiqualityConfig.BLOCK_TICK_BEHAVIOR.ALWAYS_TICKED_BLOCKS, location.toString());
                        continue block7;
                    }
                    case PRIORITY: {
                        TiqualityConfig.BLOCK_TICK_BEHAVIOR.PRIORITY_BLOCKS = QuickConfig.expensiveArrayAsListManipulationAdd(TiqualityConfig.BLOCK_TICK_BEHAVIOR.PRIORITY_BLOCKS, location.toString());
                    }
                }
            }
        }

        private static void removeBlockFromConfig(ResourceLocation ... entries) {
            for (ResourceLocation resource : entries) {
                String location = resource.func_110624_b() + ":" + resource.func_110623_a();
                TiqualityConfig.BLOCK_TICK_BEHAVIOR.ALWAYS_TICKED_BLOCKS = QuickConfig.arrayRemoveIfExists(TiqualityConfig.BLOCK_TICK_BEHAVIOR.ALWAYS_TICKED_BLOCKS, location);
                TiqualityConfig.BLOCK_TICK_BEHAVIOR.NATURAL_BLOCKS = QuickConfig.arrayRemoveIfExists(TiqualityConfig.BLOCK_TICK_BEHAVIOR.NATURAL_BLOCKS, location);
                TiqualityConfig.BLOCK_TICK_BEHAVIOR.PRIORITY_BLOCKS = QuickConfig.arrayRemoveIfExists(TiqualityConfig.BLOCK_TICK_BEHAVIOR.PRIORITY_BLOCKS, location);
                TiqualityConfig.BLOCK_TICK_BEHAVIOR.TICK_DENIED_BLOCKS = QuickConfig.arrayRemoveIfExists(TiqualityConfig.BLOCK_TICK_BEHAVIOR.TICK_DENIED_BLOCKS, location);
            }
        }

        private static void removeEntityFromConfig(ResourceLocation ... entries) {
            for (ResourceLocation resource : entries) {
                String location = resource.func_110624_b() + ":" + resource.func_110623_a();
                TiqualityConfig.ENTITY_TICK_BEHAVIOR.ALWAYS_TICKED_ENTITIES = QuickConfig.arrayRemoveIfExists(TiqualityConfig.ENTITY_TICK_BEHAVIOR.ALWAYS_TICKED_ENTITIES, location);
                TiqualityConfig.ENTITY_TICK_BEHAVIOR.PRIORITY_ENTITIES = QuickConfig.arrayRemoveIfExists(TiqualityConfig.ENTITY_TICK_BEHAVIOR.PRIORITY_ENTITIES, location);
                TiqualityConfig.ENTITY_TICK_BEHAVIOR.TICK_DENIED_ENTITIES = QuickConfig.arrayRemoveIfExists(TiqualityConfig.ENTITY_TICK_BEHAVIOR.TICK_DENIED_ENTITIES, location);
            }
        }

        @CheckReturnValue
        private static String[] arrayRemoveIfExists(String[] array, String entry) {
            for (String s : array) {
                if (!entry.equals(s)) continue;
                ArrayList<String> listified = new ArrayList<String>(Arrays.asList(array));
                listified.remove(entry);
                return listified.toArray(new String[0]);
            }
            return array;
        }

        @CheckReturnValue
        private static String[] expensiveArrayAsListManipulationAdd(String[] array, String entry) {
            ArrayList<String> list = new ArrayList<String>(Arrays.asList(array));
            list.add(entry);
            return list.toArray(new String[0]);
        }

        public static void saveToFile() {
            ConfigManager.sync((String)"tiquality", (Config.Type)Config.Type.INSTANCE);
        }

        public static void reloadFromFile() throws CommandException {
            try {
                Field field = ConfigManager.class.getDeclaredField("CONFIGS");
                field.setAccessible(true);
                Map STOLEN_VARIABLE = (Map)field.get(null);
                Iterator iterator = STOLEN_VARIABLE.entrySet().iterator();
                boolean foundConfig = false;
                while (iterator.hasNext()) {
                    Map.Entry entry = iterator.next();
                    if (!((String)entry.getKey()).endsWith("Tiquality.cfg")) continue;
                    iterator.remove();
                    foundConfig = true;
                    ConfigManager.sync((String)"tiquality", (Config.Type)Config.Type.INSTANCE);
                    QuickConfig.update();
                    break;
                }
                if (!foundConfig) {
                    throw new CommandException("Unable to reload config, entry was not found!", new Object[0]);
                }
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                e.printStackTrace();
            }
        }

        public static void clearBlockUpdateTypes() {
            for (Block b : MODIFIED_BLOCKS) {
                Tiquality.LOGGER.info("Unlinking: " + ((ResourceLocation)Block.field_149771_c.func_177774_c((Object)b)).toString());
                ((UpdateTyped)b).setUpdateType(UpdateType.DEFAULT);
            }
            MODIFIED_BLOCKS.clear();
        }

        public static void update() {
            ResourceLocation location;
            String[] split;
            String[] split2;
            Object block;
            TickMaster.TICK_DURATION = 50000000L - (long)TIME_BETWEEN_TICKS_IN_NS;
            QuickConfig.clearBlockUpdateTypes();
            HashSet<Block> TMP_BLOCKS = new HashSet<Block>();
            Tiquality.LOGGER.info("SCANNING BLOCKS...");
            Tiquality.LOGGER.info("NATURAL blocks:");
            for (String string : TiqualityConfig.BLOCK_TICK_BEHAVIOR.NATURAL_BLOCKS) {
                if (string.startsWith("REGEX=")) {
                    TMP_BLOCKS.addAll(QuickConfig.findBlocks(string.substring(6)));
                    continue;
                }
                String[] split22 = string.split(":");
                ResourceLocation resourceLocation = new ResourceLocation(split22[0], split22[1]);
                block = (Block)Block.field_149771_c.func_82594_a((Object)resourceLocation);
                if (block == Blocks.field_150350_a) {
                    Tiquality.LOGGER.warn("!!!!#######################!!!!");
                    Tiquality.LOGGER.warn("INVALID CONFIG ENTRY");
                    Tiquality.LOGGER.warn("NATURAL_BLOCKS: " + block);
                    Tiquality.LOGGER.warn("This block has been skipped!");
                    Tiquality.LOGGER.warn("!!!!#######################!!!!");
                    continue;
                }
                TMP_BLOCKS.add((Block)block);
            }
            for (Block b : TMP_BLOCKS) {
                Tiquality.LOGGER.info("+ " + ((ResourceLocation)Block.field_149771_c.func_177774_c((Object)b)).toString());
                ((UpdateTyped)b).setUpdateType(UpdateType.NATURAL);
            }
            MODIFIED_BLOCKS.addAll(TMP_BLOCKS);
            TMP_BLOCKS.clear();
            Tiquality.LOGGER.info("ALWAYS_TICKED blocks:");
            for (String string : TiqualityConfig.BLOCK_TICK_BEHAVIOR.ALWAYS_TICKED_BLOCKS) {
                if (string.startsWith("REGEX=")) {
                    TMP_BLOCKS.addAll(QuickConfig.findBlocks(string.substring(6)));
                    continue;
                }
                split2 = string.split(":");
                ResourceLocation resourceLocation = new ResourceLocation(split2[0], split2[1]);
                block = (Block)Block.field_149771_c.func_82594_a((Object)resourceLocation);
                if (block == Blocks.field_150350_a) {
                    Tiquality.LOGGER.warn("!!!!#######################!!!!");
                    Tiquality.LOGGER.warn("INVALID CONFIG ENTRY");
                    Tiquality.LOGGER.warn("ALWAYS_TICKED_BLOCKS: " + block);
                    Tiquality.LOGGER.warn("This block has been skipped!");
                    Tiquality.LOGGER.warn("!!!!#######################!!!!");
                    continue;
                }
                TMP_BLOCKS.add((Block)block);
            }
            for (Block b : TMP_BLOCKS) {
                Tiquality.LOGGER.info("+ " + ((ResourceLocation)Block.field_149771_c.func_177774_c((Object)b)).toString());
                ((UpdateTyped)b).setUpdateType(UpdateType.ALWAYS_TICK);
            }
            MODIFIED_BLOCKS.addAll(TMP_BLOCKS);
            TMP_BLOCKS.clear();
            Tiquality.LOGGER.info("PRIORITY blocks:");
            for (String string : TiqualityConfig.BLOCK_TICK_BEHAVIOR.PRIORITY_BLOCKS) {
                if (string.startsWith("REGEX=")) {
                    TMP_BLOCKS.addAll(QuickConfig.findBlocks(string.substring(6)));
                    continue;
                }
                split2 = string.split(":");
                ResourceLocation resourceLocation = new ResourceLocation(split2[0], split2[1]);
                block = (Block)Block.field_149771_c.func_82594_a((Object)resourceLocation);
                if (block == Blocks.field_150350_a) {
                    Tiquality.LOGGER.warn("!!!!#######################!!!!");
                    Tiquality.LOGGER.warn("INVALID CONFIG ENTRY");
                    Tiquality.LOGGER.warn("PRIORITY_BLOCKS: " + block);
                    Tiquality.LOGGER.warn("This block has been skipped!");
                    Tiquality.LOGGER.warn("!!!!#######################!!!!");
                    continue;
                }
                TMP_BLOCKS.add((Block)block);
            }
            for (Block b : TMP_BLOCKS) {
                Tiquality.LOGGER.info("+ " + ((ResourceLocation)Block.field_149771_c.func_177774_c((Object)b)).toString());
                ((UpdateTyped)b).setUpdateType(UpdateType.PRIORITY);
            }
            MODIFIED_BLOCKS.addAll(TMP_BLOCKS);
            TMP_BLOCKS.clear();
            Tiquality.LOGGER.info("TICK_DENIED blocks:");
            for (String string : TiqualityConfig.BLOCK_TICK_BEHAVIOR.TICK_DENIED_BLOCKS) {
                if (string.startsWith("REGEX=")) {
                    TMP_BLOCKS.addAll(QuickConfig.findBlocks(string.substring(6)));
                    continue;
                }
                split2 = string.split(":");
                ResourceLocation resourceLocation = new ResourceLocation(split2[0], split2[1]);
                block = (Block)Block.field_149771_c.func_82594_a((Object)resourceLocation);
                if (block == Blocks.field_150350_a) {
                    Tiquality.LOGGER.warn("!!!!#######################!!!!");
                    Tiquality.LOGGER.warn("INVALID CONFIG ENTRY");
                    Tiquality.LOGGER.warn("TICK_DENIED_BLOCKS: " + block);
                    Tiquality.LOGGER.warn("This block has been skipped!");
                    Tiquality.LOGGER.warn("!!!!#######################!!!!");
                    continue;
                }
                TMP_BLOCKS.add((Block)block);
            }
            for (Block b : TMP_BLOCKS) {
                Tiquality.LOGGER.info("+ " + ((ResourceLocation)Block.field_149771_c.func_177774_c((Object)b)).toString());
                ((UpdateTyped)b).setUpdateType(UpdateType.TICK_DENIED);
            }
            MODIFIED_BLOCKS.addAll(TMP_BLOCKS);
            TMP_BLOCKS.clear();
            Set ENTITY_LIST = EntityList.func_180124_b();
            HashSet<ResourceLocation> TMP_ENTITIES = new HashSet<ResourceLocation>();
            Tiquality.LOGGER.info("SCANNING ENTITIES:");
            Tiquality.LOGGER.info("Unlinking...");
            for (WorldServer worldServer : FMLCommonHandler.instance().getMinecraftServerInstance().field_71305_c) {
                for (Entity entity : worldServer.field_72996_f) {
                    ((TiqualityEntity)entity).setUpdateType(UpdateType.DEFAULT);
                }
            }
            Tiquality.LOGGER.info("Unlinked.");
            ENTITY_UPDATE_TYPES.clear();
            Tiquality.LOGGER.info("ALWAYS_TICKED entities:");
            for (WorldServer worldServer : TiqualityConfig.ENTITY_TICK_BEHAVIOR.ALWAYS_TICKED_ENTITIES) {
                if (worldServer.startsWith("REGEX=")) {
                    TMP_ENTITIES.addAll(QuickConfig.findEntities(ENTITY_LIST, worldServer.substring(6)));
                    continue;
                }
                split = worldServer.split(":");
                location = new ResourceLocation(split[0], split[1]);
                if (!ENTITY_LIST.contains(location)) {
                    Tiquality.LOGGER.warn("!!!!#######################!!!!");
                    Tiquality.LOGGER.warn("INVALID CONFIG ENTRY");
                    Tiquality.LOGGER.warn("ALWAYS_TICKED_ENTITIES: " + location);
                    Tiquality.LOGGER.warn("This entity has been skipped!");
                    Tiquality.LOGGER.warn("!!!!#######################!!!!");
                    continue;
                }
                TMP_ENTITIES.add(location);
            }
            for (ResourceLocation resourceLocation : TMP_ENTITIES) {
                Tiquality.LOGGER.info("+ " + resourceLocation);
                ENTITY_UPDATE_TYPES.put(resourceLocation, UpdateType.ALWAYS_TICK);
            }
            TMP_ENTITIES.clear();
            Tiquality.LOGGER.info("PRIORITY entities:");
            for (String string : TiqualityConfig.ENTITY_TICK_BEHAVIOR.PRIORITY_ENTITIES) {
                if (string.startsWith("REGEX=")) {
                    TMP_ENTITIES.addAll(QuickConfig.findEntities(ENTITY_LIST, string.substring(6)));
                    continue;
                }
                split = string.split(":");
                location = new ResourceLocation(split[0], split[1]);
                if (!ENTITY_LIST.contains(location)) {
                    Tiquality.LOGGER.warn("!!!!#######################!!!!");
                    Tiquality.LOGGER.warn("INVALID CONFIG ENTRY");
                    Tiquality.LOGGER.warn("PRIORITY_ENTITIES: " + location);
                    Tiquality.LOGGER.warn("This entity has been skipped!");
                    Tiquality.LOGGER.warn("!!!!#######################!!!!");
                    continue;
                }
                TMP_ENTITIES.add(location);
            }
            for (ResourceLocation resourceLocation : TMP_ENTITIES) {
                Tiquality.LOGGER.info("+ " + resourceLocation);
                ENTITY_UPDATE_TYPES.put(resourceLocation, UpdateType.PRIORITY);
            }
            TMP_ENTITIES.clear();
            Tiquality.LOGGER.info("TICK_DENIED_ENTITIES entities:");
            for (String string : TiqualityConfig.ENTITY_TICK_BEHAVIOR.TICK_DENIED_ENTITIES) {
                if (string.startsWith("REGEX=")) {
                    TMP_ENTITIES.addAll(QuickConfig.findEntities(ENTITY_LIST, string.substring(6)));
                    continue;
                }
                split = string.split(":");
                location = new ResourceLocation(split[0], split[1]);
                if (!ENTITY_LIST.contains(location)) {
                    Tiquality.LOGGER.warn("!!!!#######################!!!!");
                    Tiquality.LOGGER.warn("INVALID CONFIG ENTRY");
                    Tiquality.LOGGER.warn("TICK_DENIED_ENTITIES: " + location);
                    Tiquality.LOGGER.warn("This entity has been skipped!");
                    Tiquality.LOGGER.warn("!!!!#######################!!!!");
                    continue;
                }
                TMP_ENTITIES.add(location);
            }
            for (ResourceLocation resourceLocation : TMP_ENTITIES) {
                Tiquality.LOGGER.info("+ " + resourceLocation);
                ENTITY_UPDATE_TYPES.put(resourceLocation, UpdateType.TICK_DENIED);
            }
            TMP_ENTITIES.clear();
            Tiquality.LOGGER.info("Scan complete.");
            Tiquality.LOGGER.info("Relinking entities...");
            for (WorldServer worldServer : FMLCommonHandler.instance().getMinecraftServerInstance().field_71305_c) {
                for (Entity entity_raw : worldServer.field_72996_f) {
                    TiqualityEntity entity;
                    ResourceLocation location6 = (entity = (TiqualityEntity)entity_raw).tiquality_getResourceLocation();
                    UpdateType type = ENTITY_UPDATE_TYPES.get(location6);
                    entity.setUpdateType(type == null ? UpdateType.DEFAULT : type);
                }
            }
            Tiquality.LOGGER.info("Linked.");
        }

        private static ArrayList<Block> findBlocks(String regex) {
            ArrayList<Block> list = new ArrayList<Block>();
            for (ResourceLocation resource : Block.field_149771_c.func_148742_b()) {
                if (!Pattern.compile(regex).matcher(resource.toString()).find()) continue;
                list.add((Block)Block.field_149771_c.func_82594_a((Object)resource));
                Tiquality.LOGGER.info("regex '" + regex + "' applied for: " + resource.toString());
            }
            if (list.size() == 0) {
                Tiquality.LOGGER.warn("regex '" + regex + "' had no matches!");
            }
            return list;
        }

        public static ArrayList<ResourceLocation> findEntities(Set<ResourceLocation> entityList, String regex) {
            ArrayList<ResourceLocation> list = new ArrayList<ResourceLocation>();
            for (ResourceLocation resource : entityList) {
                if (!Pattern.compile(regex).matcher(resource.toString()).find()) continue;
                list.add(resource);
                Tiquality.LOGGER.info("regex '" + regex + "' applied for: " + resource.toString());
            }
            if (list.size() == 0) {
                Tiquality.LOGGER.warn("regex '" + regex + "' had no matches!");
            }
            return list;
        }
    }

    public static class ENTITY_TICKING {
        @Config.Comment(value={"Some entities, you simply don't want to be throttled, ever.", "Tiquality will still attempt to tick them per player, but if the player runs out of tick time, it will still tick these entities.", "Players are hardcoded to be in this category."})
        public String[] ALWAYS_TICKED_ENTITIES = new String[0];
        @Config.Comment(value={"When people run bases, you can prioritize which entities have to be updated first. Unlike", "ALWAYS_TICKED_ENTITIES, PRIORITY_ENTITIES can be throttled.", "If you put 'minecraft:item' here, it will be easier for players to pick them up etc. Recommended."})
        public String[] PRIORITY_ENTITIES = new String[]{"minecraft:item", "minecraft:falling_block"};
        @Config.Comment(value={"Entities you never want to tick are defined here. Useful for stopping dupes or game breaking lag without banning recipes!"})
        public String[] TICK_DENIED_ENTITIES = new String[0];
    }

    public static class BLOCK_TICKING {
        @Config.Comment(value={"Some blocks are automatically generated in the world, but do require ticking in order to function properly.", "Define the blocks you wish to keep tick when the block has not been assigned an owner yet.", "Keep in mind, if there is an owner set on this block, the block can be throttled. See: ALWAYS_TICKED_BLOCKS"})
        public String[] NATURAL_BLOCKS = new String[]{"minecraft:mob_spawner", "minecraft:chest", "minecraft:ender_chest", "minecraft:trapped_chest", "REGEX=leaves", "REGEX=sapling", "REGEX=flowing", "minecraft:snow_layer", "minecraft:ice", "minecraft:water", "minecraft:lava", "minecraft:grass", "minecraft:sand", "minecraft:gravel", "minecraft:beetroots", "minecraft:wheat", "minecraft:carrots", "minecraft:potatoes", "minecraft:reeds", "minecraft:farmland", "minecraft:fire", "minecraft:cocoa", "minecraft:cactus", "minecraft:double_plant"};
        @Config.Comment(value={"Some blocks, you simply don't want to be throttled, ever. For example: piston extensions.", "Tiquality will still attempt to tick them per player, but if the player runs out of tick time, it will still tick these blocks.", "Items in this list are also appended to NATURAL_BLOCKS through code, there is no need to define blocks twice."})
        public String[] ALWAYS_TICKED_BLOCKS = new String[]{"minecraft:piston_extension", "minecraft:piston_head", "minecraft:portal"};
        @Config.Comment(value={"When people run bases, you can prioritize which blocks have to be updated first. Unlinke", "ALWAYS_TICKED_BLOCKS, PRIORITY_BLOCKS can be throttled."})
        public String[] PRIORITY_BLOCKS = new String[0];
        @Config.Comment(value={"Blocks you never want to tick are defined here. Useful for stopping dupes or game breaking lag without banning recipes!"})
        public String[] TICK_DENIED_BLOCKS = new String[0];
    }
}

