/*
 * Decompiled with CFR 0.152.
 */
package com.github.terminatornl.tiquality.api.event;

import com.github.terminatornl.tiquality.interfaces.TiqualityChunk;
import com.github.terminatornl.tiquality.interfaces.TiqualityEntity;
import com.github.terminatornl.tiquality.interfaces.TiqualityWorld;
import com.github.terminatornl.tiquality.interfaces.Tracker;
import com.github.terminatornl.tiquality.profiling.TickLogger;
import com.github.terminatornl.tiquality.tracking.TrackerHolder;
import javax.annotation.Nullable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.eventhandler.Cancelable;
import net.minecraftforge.fml.common.eventhandler.Event;

public class TiqualityEvent
extends Event {

    @Cancelable
    public static class SetEntityTrackerEvent
    extends TiqualityEvent {
        private final TiqualityEntity entity;
        private TrackerHolder holder;

        public SetEntityTrackerEvent(TiqualityEntity entity, @Nullable TrackerHolder holder) {
            this.holder = holder;
            this.entity = entity;
        }

        public TiqualityEntity getEntity() {
            return this.entity;
        }

        public TiqualityWorld getTiqualityWorld() {
            return (TiqualityWorld)this.entity.tiquality_getWorld();
        }

        public World getMinecraftWorld() {
            return this.entity.tiquality_getWorld();
        }

        @Nullable
        public TrackerHolder getHolder() {
            return this.holder;
        }

        public void setHolder(@Nullable TrackerHolder holder) {
            this.holder = holder;
        }
    }

    @Cancelable
    public static class SetChunkTrackerEvent
    extends TiqualityEvent {
        private final TiqualityChunk chunk;
        private Tracker tracker;
        private boolean perBlockMode = false;

        public SetChunkTrackerEvent(TiqualityChunk chunk, Tracker tracker) {
            this.tracker = tracker;
            this.chunk = chunk;
        }

        public TiqualityChunk getChunk() {
            return this.chunk;
        }

        public TiqualityWorld getTiqualityWorld() {
            return (TiqualityWorld)this.chunk.getMinecraftChunk().func_177412_p();
        }

        public World getMinecraftWorld() {
            return this.chunk.getMinecraftChunk().func_177412_p();
        }

        public Tracker getTracker() {
            return this.tracker;
        }

        public void setTracker(Tracker tracker) {
            this.tracker = tracker;
        }

        public void setPerBlockMode() {
            this.perBlockMode = true;
        }

        public boolean isPerBlockMode() {
            return this.perBlockMode;
        }
    }

    @Cancelable
    public static class SetBlockTrackerEvent
    extends TiqualityEvent {
        private final TiqualityChunk chunk;
        private final BlockPos pos;
        private Tracker tracker;

        public SetBlockTrackerEvent(TiqualityChunk chunk, BlockPos pos, Tracker tracker) {
            this.tracker = tracker;
            this.chunk = chunk;
            this.pos = pos;
        }

        public TiqualityChunk getChunk() {
            return this.chunk;
        }

        public TiqualityWorld getTiqualityWorld() {
            return (TiqualityWorld)this.chunk.getMinecraftChunk().func_177412_p();
        }

        public World getMinecraftWorld() {
            return this.chunk.getMinecraftChunk().func_177412_p();
        }

        public BlockPos getPos() {
            return this.pos;
        }

        public Tracker getTracker() {
            return this.tracker;
        }

        public void setTracker(Tracker tracker) {
            this.tracker = tracker;
        }
    }

    public static class ProfileCompletedEvent
    extends TiqualityEvent {
        private final TickLogger logger;
        private final Tracker tracker;

        public ProfileCompletedEvent(Tracker tracker, TickLogger logger) {
            this.logger = logger;
            this.tracker = tracker;
        }

        public Tracker getTracker() {
            return this.tracker;
        }

        public TickLogger getTickLogger() {
            return this.logger;
        }
    }
}

