/*
 * Decompiled with CFR 0.152.
 */
package com.github.terminatornl.tiquality.concurrent;

import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

public class PausableThreadPoolExecutor
extends ThreadPoolExecutor {
    private final AtomicBoolean IS_PAUSED = new AtomicBoolean(false);
    private final AtomicInteger RUNNING_THREADS = new AtomicInteger(0);

    public PausableThreadPoolExecutor(int size) {
        super(size, size, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finish() throws InterruptedException {
        AtomicInteger atomicInteger = this.RUNNING_THREADS;
        synchronized (atomicInteger) {
            while (this.RUNNING_THREADS.get() > 0) {
                this.RUNNING_THREADS.wait();
            }
        }
    }

    public void pause() throws InterruptedException {
        this.IS_PAUSED.set(true);
        this.finish();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resume() {
        AtomicBoolean atomicBoolean = this.IS_PAUSED;
        synchronized (atomicBoolean) {
            this.IS_PAUSED.set(false);
            this.IS_PAUSED.notifyAll();
        }
    }

    public void exitFully() throws InterruptedException {
        this.resume();
        this.shutdown();
        this.awaitTermination(Long.MAX_VALUE, TimeUnit.DAYS);
    }

    public int getRunningThreadCount() {
        return this.RUNNING_THREADS.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void beforeExecute(Thread thread, Runnable runnable) {
        try {
            super.beforeExecute(thread, runnable);
            AtomicBoolean atomicBoolean = this.IS_PAUSED;
            synchronized (atomicBoolean) {
                while (this.IS_PAUSED.get()) {
                    this.IS_PAUSED.wait();
                }
            }
            this.RUNNING_THREADS.incrementAndGet();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void afterExecute(Runnable r, Throwable t) {
        super.afterExecute(r, t);
        AtomicInteger atomicInteger = this.RUNNING_THREADS;
        synchronized (atomicInteger) {
            this.RUNNING_THREADS.decrementAndGet();
            this.RUNNING_THREADS.notifyAll();
        }
    }
}

