/*
 * Decompiled with CFR 0.152.
 */
package com.github.terminatornl.tiquality.integration.ftbutilities;

import com.feed_the_beast.ftblib.lib.data.ForgeTeam;
import com.feed_the_beast.ftblib.lib.math.ChunkDimPos;
import com.feed_the_beast.ftbutilities.data.ClaimedChunk;
import com.feed_the_beast.ftbutilities.data.ClaimedChunks;
import com.feed_the_beast.ftbutilities.events.chunks.ChunkModifiedEvent;
import com.github.terminatornl.tiquality.api.event.TiqualityEvent;
import com.github.terminatornl.tiquality.integration.ftbutilities.FTBUtilitiesHook;
import com.github.terminatornl.tiquality.interfaces.TiqualityWorld;
import com.github.terminatornl.tiquality.tracking.PlayerTracker;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class EventHandler {
    public static final EventHandler INSTANCE = new EventHandler();

    private EventHandler() {
    }

    @SubscribeEvent
    public void onClaim(ChunkModifiedEvent.Claimed e) {
        ClaimedChunk chunk = e.getChunk();
        ChunkDimPos dimPos = chunk.getPos();
        WorldServer world = DimensionManager.getWorld((int)dimPos.dim);
        if (world == null) {
            return;
        }
        PlayerTracker tracker = FTBUtilitiesHook.getTrackerForTeam((TiqualityWorld)world, e.getChunk().getTeam());
        if (tracker == null) {
            return;
        }
        ChunkPos pos = new ChunkPos(dimPos.posX, dimPos.posZ);
        ((TiqualityWorld)world).setTiqualityTrackerCuboidAsync(new BlockPos(pos.func_180334_c(), 0, pos.func_180333_d()), new BlockPos(pos.func_180332_e(), world.func_72800_K() - 1, pos.func_180330_f()), tracker, null);
    }

    @SubscribeEvent
    public void onSetTracker(TiqualityEvent.SetBlockTrackerEvent e) {
        if (!ClaimedChunks.isActive()) {
            return;
        }
        ChunkPos pos = e.getChunk().getMinecraftChunk().func_76632_l();
        ForgeTeam team = ClaimedChunks.instance.getChunkTeam(new ChunkDimPos(pos.field_77276_a, pos.field_77275_b, e.getChunk().getMinecraftChunk().func_177412_p().field_73011_w.getDimension()));
        if (team == null) {
            return;
        }
        PlayerTracker tracker = FTBUtilitiesHook.getTrackerForTeam(e.getTiqualityWorld(), team);
        if (tracker != null) {
            e.setTracker(tracker);
        }
    }

    @SubscribeEvent
    public void onSetTracker(TiqualityEvent.SetChunkTrackerEvent e) {
        if (!ClaimedChunks.isActive()) {
            return;
        }
        ChunkPos pos = e.getChunk().getMinecraftChunk().func_76632_l();
        ForgeTeam team = ClaimedChunks.instance.getChunkTeam(new ChunkDimPos(pos.field_77276_a, pos.field_77275_b, e.getChunk().getMinecraftChunk().func_177412_p().field_73011_w.getDimension()));
        if (team == null) {
            return;
        }
        PlayerTracker tracker = FTBUtilitiesHook.getTrackerForTeam(e.getTiqualityWorld(), team);
        if (tracker != null) {
            e.setTracker(tracker);
        }
    }
}

