/*
 * Decompiled with CFR 0.152.
 */
package com.github.terminatornl.tiquality.mixin;

import com.github.terminatornl.tiquality.Tiquality;
import com.github.terminatornl.tiquality.api.event.TiqualityEvent;
import com.github.terminatornl.tiquality.interfaces.TiqualityEntity;
import com.github.terminatornl.tiquality.interfaces.TiqualityWorld;
import com.github.terminatornl.tiquality.interfaces.Tracker;
import com.github.terminatornl.tiquality.profiling.ReferencedTickable;
import com.github.terminatornl.tiquality.tracking.TrackerHolder;
import com.github.terminatornl.tiquality.tracking.TrackerManager;
import com.github.terminatornl.tiquality.tracking.UpdateType;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Entity.class})
public abstract class MixinEntity
implements TiqualityEntity {
    @Shadow
    public double field_70165_t;
    @Shadow
    public double field_70163_u;
    @Shadow
    public double field_70161_v;
    @Shadow
    public World field_70170_p;
    private TrackerHolder trackerHolder = null;
    private boolean isMarkedByTiquality = false;
    private UpdateType updateType = UpdateType.DEFAULT;
    private ResourceLocation locationCache = null;

    @Shadow
    public abstract UUID func_110124_au();

    @Override
    public void tiquality_doUpdateTick() {
        Tiquality.TICK_EXECUTOR.onEntityTick((Entity)this);
    }

    @Override
    public BlockPos tiquality_getPos() {
        return new BlockPos(this.field_70165_t, this.field_70163_u, this.field_70161_v);
    }

    @Override
    public World tiquality_getWorld() {
        return this.field_70170_p;
    }

    @Override
    @Nullable
    public ReferencedTickable.Reference getId() {
        return new ReferencedTickable.EntityReference(this.field_70170_p.field_73011_w.getDimension(), this.func_110124_au());
    }

    @Override
    @Nullable
    public TrackerHolder getTrackerHolder() {
        return this.trackerHolder;
    }

    @Override
    public void setTrackerHolder(@Nullable TrackerHolder trackerHolder) {
        TiqualityEvent.SetEntityTrackerEvent event = new TiqualityEvent.SetEntityTrackerEvent(this, trackerHolder);
        if (MinecraftForge.EVENT_BUS.post((Event)event)) {
            return;
        }
        this.trackerHolder = event.getHolder();
    }

    @Override
    @Nullable
    public Tracker getTracker() {
        return this.trackerHolder == null ? null : (Tracker)this.trackerHolder.getTracker();
    }

    @Override
    public void setTracker(@Nullable Tracker tracker) {
        this.setTrackerHolder(tracker == null ? null : tracker.getHolder());
    }

    @Inject(method={"writeToNBT"}, at={@At(value="HEAD")}, require=1)
    private void TiqualityOnWrite(NBTTagCompound compound, CallbackInfoReturnable<NBTTagCompound> cir) {
        if (this.trackerHolder != null && this.trackerHolder.getTracker().shouldSaveToDisk()) {
            compound.func_74782_a("Tiquality", (NBTBase)this.trackerHolder.getHolderTag());
        }
    }

    @Inject(method={"readFromNBT"}, at={@At(value="HEAD")}, require=1)
    private void TiqualityOnRead(NBTTagCompound compound, CallbackInfo ci) {
        if (compound.func_74764_b("Tiquality")) {
            this.trackerHolder = TrackerManager.readHolder((TiqualityWorld)this.field_70170_p, compound.func_74775_l("Tiquality"));
        }
    }

    @Override
    public boolean tiquality_isLoaded() {
        return this.field_70170_p.func_175667_e(this.tiquality_getPos());
    }

    @Override
    public void tiquality_mark() {
        this.isMarkedByTiquality = true;
    }

    @Override
    public void tiquality_unMark() {
        this.isMarkedByTiquality = false;
    }

    @Override
    public boolean tiquality_isMarked() {
        return this.isMarkedByTiquality;
    }

    @Override
    @Nonnull
    public UpdateType getUpdateType() {
        return this.updateType;
    }

    @Override
    public void setUpdateType(@Nonnull UpdateType type) {
        this.updateType = type;
    }

    @Override
    public ResourceLocation tiquality_getResourceLocation() {
        if (this.locationCache != null) {
            return this.locationCache;
        }
        this.locationCache = EntityList.func_191301_a((Entity)((Entity)this));
        if (this.locationCache == null) {
            this.locationCache = new ResourceLocation("*unknown*", this.getClass().toString());
        }
        return this.locationCache;
    }
}

