/*
 * Decompiled with CFR 0.152.
 */
package com.github.terminatornl.tiquality.monitor;

import com.github.terminatornl.tiquality.TiqualityConfig;
import com.github.terminatornl.tiquality.interfaces.TiqualityChunk;
import com.github.terminatornl.tiquality.util.PersistentData;
import java.io.IOException;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.event.world.ChunkDataEvent;
import net.minecraftforge.event.world.ChunkEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class ChunkLoadMonitor {
    public static final ChunkLoadMonitor INSTANCE = new ChunkLoadMonitor();
    public static final String TIQUALITY_VERSION_TAG = "Tiquality2" + (TiqualityConfig.SAVE_VERSION == 0 ? "" : Integer.valueOf(TiqualityConfig.SAVE_VERSION));

    private ChunkLoadMonitor() {
    }

    @SubscribeEvent
    public void onChunkLoad(ChunkEvent.Load event) {
        if (event.getWorld().field_72995_K) {
            return;
        }
        ((TiqualityChunk)event.getChunk()).associateTrackers();
    }

    @SubscribeEvent
    public void onNBTLoad(ChunkDataEvent.Load event) {
        Chunk chunk = event.getChunk();
        World world = chunk.func_177412_p();
        if (world.field_72995_K) {
            return;
        }
        PersistentData.ensureDataAvailability(world);
        NBTTagCompound tag = PersistentData.getChunkNBTData(chunk);
        if (tag != null && tag.func_74764_b(TIQUALITY_VERSION_TAG)) {
            NBTTagCompound tiqualityData = tag.func_74775_l(TIQUALITY_VERSION_TAG);
            ((TiqualityChunk)event.getChunk()).tiquality_loadNBT(event.getWorld(), tiqualityData);
        }
    }

    @SubscribeEvent
    public void onNBTSave(ChunkDataEvent.Save event) {
        Chunk chunk = event.getChunk();
        World world = chunk.func_177412_p();
        if (world.field_72995_K) {
            return;
        }
        NBTTagCompound tiqualityData = ((TiqualityChunk)event.getChunk()).tiquality_getNBT();
        if (tiqualityData != null) {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74782_a(TIQUALITY_VERSION_TAG, (NBTBase)tiqualityData);
            PersistentData.ensureDataAvailability(world);
            try {
                PersistentData.saveChunkNBTData(chunk, tag);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        try {
            PersistentData.saveChunkNBTData(chunk, null);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

