/*
 * Decompiled with CFR 0.152.
 */
package com.github.terminatornl.tiquality.monitor;

import com.github.terminatornl.tiquality.TiqualityConfig;
import com.github.terminatornl.tiquality.interfaces.TiqualityChunk;
import com.github.terminatornl.tiquality.interfaces.TiqualityEntity;
import com.github.terminatornl.tiquality.interfaces.Tracker;
import com.github.terminatornl.tiquality.tracking.UpdateType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class EntityMonitor {
    public static final EntityMonitor INSTANCE = new EntityMonitor();

    private EntityMonitor() {
    }

    @SubscribeEvent
    public void onSpawn(EntityJoinWorldEvent e) {
        if (e.getWorld().field_72995_K) {
            ((TiqualityEntity)e.getEntity()).setUpdateType(UpdateType.ALWAYS_TICK);
        } else {
            ResourceLocation location = ((TiqualityEntity)e.getEntity()).tiquality_getResourceLocation();
            ((TiqualityEntity)e.getEntity()).setUpdateType(TiqualityConfig.QuickConfig.getEntityUpdateType(location));
            if (e.getEntity() instanceof EntityPlayer) {
                ((TiqualityEntity)e.getEntity()).setUpdateType(UpdateType.ALWAYS_TICK);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onChangeChunk(EntityEvent.EnteringChunk event) {
        TiqualityEntity entity = (TiqualityEntity)event.getEntity();
        Tracker tracker = entity.getTracker();
        if (tracker == null) {
            TiqualityChunk chunk;
            Tracker dominantTracker;
            BlockPos pos = entity.tiquality_getPos();
            if (entity.tiquality_getWorld().func_175667_e(pos) && (dominantTracker = (chunk = (TiqualityChunk)entity.tiquality_getWorld().func_175726_f(pos)).getCachedMostDominantTracker()) != null) {
                entity.setTracker(dominantTracker);
            }
        }
    }
}

