/*
 * Decompiled with CFR 0.152.
 */
package com.github.terminatornl.tiquality.monitor;

import java.math.BigInteger;
import java.util.Arrays;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class TPSMonitor {
    public static final TPSMonitor INSTANCE = new TPSMonitor();
    private int measure_ticks = 40;
    private long LAST_TICK = System.nanoTime();
    private long[] buffer = new long[this.measure_ticks];
    private int currentIndex = 0;

    private TPSMonitor() {
        Arrays.fill(this.buffer, 50000000L);
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public synchronized void onServerTick(TickEvent.ServerTickEvent e) {
        if (e.phase != TickEvent.Phase.START) {
            return;
        }
        long now = System.nanoTime();
        this.buffer[this.currentIndex] = now - this.LAST_TICK;
        this.LAST_TICK = now;
        ++this.currentIndex;
        if (this.currentIndex >= this.measure_ticks) {
            this.currentIndex = 0;
        }
    }

    public synchronized long getAverageTime() {
        BigInteger total = BigInteger.ZERO;
        for (long duration : this.buffer) {
            total = total.add(BigInteger.valueOf(duration));
        }
        return Math.max(1L, total.divide(BigInteger.valueOf(this.measure_ticks)).longValue());
    }

    public synchronized double getAverageTPS() {
        return 1.0E9 / (double)this.getAverageTime();
    }

    public synchronized long[] getTickHistory() {
        return (long[])this.buffer.clone();
    }

    public synchronized long getLastTickTime() {
        return this.buffer[this.currentIndex - 1];
    }
}

