/*
 * Decompiled with CFR 0.152.
 */
package com.github.terminatornl.tiquality.profiling;

import com.github.terminatornl.tiquality.api.Location;
import com.github.terminatornl.tiquality.profiling.ReferencedTickable;
import com.github.terminatornl.tiquality.profiling.TickTime;
import io.netty.buffer.ByteBuf;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.event.HoverEvent;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class AnalyzedComponent
implements Comparable<AnalyzedComponent>,
IMessage {
    private String clazz;
    private TickTime times;
    private ReferencedTickable.ReferenceId reference;
    private Location<Integer, BlockPos> lastKnownLocation;
    @Nullable
    private ResourceLocation resourceLocation;
    private String friendlyName;

    public AnalyzedComponent(ByteBuf byteBuf) {
        this.fromBytes(byteBuf);
    }

    private AnalyzedComponent(@Nonnull String clazz, @Nonnull TickTime times, @Nonnull ReferencedTickable.ReferenceId reference, @Nullable Location<Integer, BlockPos> lastKnownLocation, @Nonnull String friendlyName, @Nullable ResourceLocation resourceLocation) {
        this.clazz = clazz;
        this.times = times;
        this.reference = reference;
        this.lastKnownLocation = lastKnownLocation;
        this.friendlyName = friendlyName;
        this.resourceLocation = resourceLocation;
    }

    public String toString() {
        return this.times.toString() + " " + this.friendlyName;
    }

    @Override
    public int compareTo(@Nonnull AnalyzedComponent o) {
        return this.times.compareTo(o.times);
    }

    public String getFriendlyName() {
        return this.friendlyName;
    }

    public TickTime getTimes() {
        return this.times;
    }

    public String getReferencedClass() {
        return this.clazz;
    }

    @Nullable
    public ResourceLocation getResourceLocation() {
        return this.resourceLocation;
    }

    public Location<Integer, BlockPos> getLastKnownLocation() {
        return this.lastKnownLocation;
    }

    public String getLocationString() {
        if (this.lastKnownLocation != null) {
            return TextFormatting.GRAY + "D" + TextFormatting.WHITE + this.lastKnownLocation.getWorld() + TextFormatting.GRAY + "X" + TextFormatting.WHITE + this.lastKnownLocation.getPos().func_177958_n() + TextFormatting.GRAY + "Y" + TextFormatting.WHITE + this.lastKnownLocation.getPos().func_177956_o() + TextFormatting.GRAY + "Z" + TextFormatting.WHITE + this.lastKnownLocation.getPos().func_177952_p();
        }
        return TextFormatting.RED + "Unknown";
    }

    public ReferencedTickable.ReferenceId getReferenceId() {
        return this.reference;
    }

    public void toBytes(ByteBuf buf) {
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.clazz);
        this.times.toBytes(buf);
        this.reference.toBytes(buf);
        buf.writeInt(this.lastKnownLocation.getWorld().intValue());
        buf.writeInt(this.lastKnownLocation.getPos().func_177958_n());
        buf.writeInt(this.lastKnownLocation.getPos().func_177956_o());
        buf.writeInt(this.lastKnownLocation.getPos().func_177952_p());
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.friendlyName);
        if (this.resourceLocation != null) {
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.resourceLocation.func_110624_b());
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.resourceLocation.func_110623_a());
            buf.writeBoolean(true);
        } else {
            buf.writeBoolean(false);
        }
    }

    public void fromBytes(ByteBuf buf) {
        this.clazz = ByteBufUtils.readUTF8String((ByteBuf)buf);
        this.times = new TickTime(buf);
        this.reference = new ReferencedTickable.ReferenceId(buf);
        int dimension = buf.readInt();
        int posX = buf.readInt();
        int posY = buf.readInt();
        int posZ = buf.readInt();
        this.lastKnownLocation = new Location<Integer, BlockPos>(dimension, new BlockPos(posX, posY, posZ));
        this.friendlyName = ByteBufUtils.readUTF8String((ByteBuf)buf);
        this.resourceLocation = buf.readBoolean() ? new ResourceLocation(ByteBufUtils.readUTF8String((ByteBuf)buf), ByteBufUtils.readUTF8String((ByteBuf)buf)) : null;
    }

    public static class Analyzer
    implements Runnable {
        private final ReferencedTickable.Reference reference;
        private final TickTime times;
        private final Set<AnalyzedComponent> set;

        public Analyzer(ReferencedTickable.Reference reference, TickTime times, Set<AnalyzedComponent> set) {
            this.reference = reference;
            this.times = times;
            this.set = set;
        }

        public AnalyzedComponent analyze() {
            try {
                ITextComponent friendlyName = this.reference.getName();
                Location<Integer, BlockPos> lastKnownLocation = this.reference.currentPos();
                Class clazz = this.reference.getReferencedClass();
                return new AnalyzedComponent(clazz.toString().substring(6), this.times, this.reference.getId(), lastKnownLocation, friendlyName.func_150260_c(), this.reference.getResourceLocation());
            }
            catch (Throwable t) {
                ITextComponent friendlyName = new TextComponentString("Error").func_150255_a(new Style().func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (ITextComponent)new TextComponentString(t.toString()))));
                return new AnalyzedComponent("Error", this.times, this.reference.getId(), null, friendlyName.func_150254_d(), null);
            }
        }

        @Override
        public void run() {
            this.set.add(this.analyze());
        }
    }
}

