/*
 * Decompiled with CFR 0.152.
 */
package com.github.terminatornl.tiquality.profiling;

import com.github.terminatornl.tiquality.profiling.AnalyzedComponent;
import com.github.terminatornl.tiquality.profiling.TickLogger;
import com.github.terminatornl.tiquality.profiling.TickTime;
import com.github.terminatornl.tiquality.util.Utils;
import io.netty.buffer.ByteBuf;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.TreeMap;
import java.util.TreeSet;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class ProfileReport
implements IMessage {
    private final long startTimeNanos;
    private final long endTimeNanos;
    private final TreeSet<AnalyzedComponent> analyzedComponents = new TreeSet();
    private final TreeMap<String, TickTime> classTimes = new TreeMap();
    private final ITextComponent identifier;
    private double serverTPS;
    private double trackerTPS;
    private int serverTicks;
    private int trackerTicks;
    private long grantedNanos;
    private long totalNanosUsed = 0L;
    private NavigableSet<Map.Entry<String, TickTime>> classTimesSorted = null;

    public ProfileReport(long startTimeNanos, long endTimeNanos, TickLogger logger, ITextComponent identifier, Collection<AnalyzedComponent> analyzedComponents) {
        long totalTimeNanos = endTimeNanos - startTimeNanos;
        this.startTimeNanos = startTimeNanos;
        this.endTimeNanos = endTimeNanos;
        this.serverTicks = logger.getServerTicks();
        this.trackerTicks = logger.getTrackerTicks();
        double idealTicks = (double)totalTimeNanos / 5.0E7;
        this.serverTPS = (double)this.serverTicks / idealTicks * 20.0;
        this.trackerTPS = (double)this.trackerTicks / idealTicks * 20.0;
        this.grantedNanos = logger.getGrantedNanos();
        this.analyzedComponents.addAll(analyzedComponents);
        this.identifier = identifier;
        for (AnalyzedComponent component : this.analyzedComponents) {
            this.totalNanosUsed += component.getTimes().getNanosConsumed();
            TickTime time = this.classTimes.get(component.getReferencedClass());
            if (time == null) {
                this.classTimes.put(component.getReferencedClass(), new TickTime(component.getTimes()));
                continue;
            }
            time.add(component.getTimes());
        }
    }

    public ITextComponent getIdentifier() {
        return this.identifier;
    }

    public double getServerTPS() {
        return this.serverTPS;
    }

    public double getTrackerTPS() {
        return this.trackerTPS;
    }

    public int getServerTicks() {
        return this.serverTicks;
    }

    public int getTrackerTicks() {
        return this.trackerTicks;
    }

    public String getTrackerImpactPercentage(TickTime time) {
        double factor = (double)time.getNanosConsumed() / (double)this.grantedNanos;
        return Utils.TWO_DECIMAL_FORMATTER.format((double)Math.round(factor * 10000.0) / 100.0);
    }

    public String getServerImpactPercentage(TickTime time) {
        double nanosPassedOnServer = 5.0E7 * (double)this.serverTicks * this.serverTPS / 20.0;
        double factor = (double)time.getNanosConsumed() / nanosPassedOnServer;
        return Utils.TWO_DECIMAL_FORMATTER.format((double)Math.round(factor * 10000.0) / 100.0);
    }

    public double getMuPerTick(TickTime time) {
        return (double)time.getNanosConsumed() / 1000.0 / (double)this.trackerTicks;
    }

    public double getCallsPerTick(TickTime time) {
        return (double)time.getCalls() / (double)this.trackerTicks;
    }

    public NavigableSet<AnalyzedComponent> getAnalyzedComponents() {
        return Collections.unmodifiableNavigableSet(this.analyzedComponents);
    }

    public NavigableMap<String, TickTime> getClassTimes() {
        return Collections.unmodifiableNavigableMap(this.classTimes);
    }

    public NavigableSet<Map.Entry<String, TickTime>> getClassTimesSorted() {
        if (this.classTimesSorted != null) {
            return this.classTimesSorted;
        }
        TreeSet<Map.Entry> set = new TreeSet<Map.Entry>(Comparator.comparing(Map.Entry::getValue));
        set.addAll(this.classTimes.entrySet());
        this.classTimesSorted = Collections.unmodifiableNavigableSet(set);
        return this.classTimesSorted;
    }

    public void fromBytes(ByteBuf buf) {
        this.serverTPS = buf.readDouble();
        this.trackerTPS = buf.readDouble();
        this.serverTicks = buf.readInt();
        this.trackerTicks = buf.readInt();
        this.grantedNanos = buf.readLong();
        int size = buf.readInt();
        for (int i = 0; i < size; ++i) {
            this.analyzedComponents.add(new AnalyzedComponent(buf));
        }
        int size2 = buf.readInt();
        for (int i = 0; i < size2; ++i) {
            this.classTimes.put(ByteBufUtils.readUTF8String((ByteBuf)buf), new TickTime(buf));
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeDouble(this.serverTPS);
        buf.writeDouble(this.trackerTPS);
        buf.writeInt(this.serverTicks);
        buf.writeInt(this.trackerTicks);
        buf.writeLong(this.grantedNanos);
        buf.writeInt(this.analyzedComponents.size());
        for (AnalyzedComponent analyzedComponent : this.analyzedComponents) {
            analyzedComponent.toBytes(buf);
        }
        buf.writeInt(this.classTimes.size());
        for (Map.Entry entry : this.classTimes.entrySet()) {
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)((String)entry.getKey()));
            ((TickTime)entry.getValue()).toBytes(buf);
        }
    }

    public long getTotalNanosUsed() {
        return this.totalNanosUsed;
    }

    public long getStartTimeNanos() {
        return this.startTimeNanos;
    }

    public long getEndTimeNanos() {
        return this.endTimeNanos;
    }
}

