/*
 * Decompiled with CFR 0.152.
 */
package com.github.terminatornl.tiquality.profiling;

import com.github.terminatornl.tiquality.Tiquality;
import com.github.terminatornl.tiquality.api.TiqualityException;
import com.github.terminatornl.tiquality.interfaces.Tracker;
import com.github.terminatornl.tiquality.profiling.AnalyzedComponent;
import com.github.terminatornl.tiquality.profiling.ProfileReport;
import com.github.terminatornl.tiquality.profiling.ProfilingKey;
import com.github.terminatornl.tiquality.profiling.ReferencedTickable;
import com.github.terminatornl.tiquality.profiling.TickLogger;
import com.github.terminatornl.tiquality.profiling.TickTime;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;

public class SimpleProfiler
implements Runnable {
    private final Tracker tracker;
    private final long durationInMs;
    private final ProfilePrinter printer;
    private long startTimeNanos;
    private ProfilingKey key;

    public SimpleProfiler(Tracker tracker, long durationInMs, ProfilePrinter printer) {
        this.tracker = tracker;
        this.durationInMs = durationInMs;
        this.printer = printer;
    }

    public static SortedSet<AnalyzedComponent> analyzeComponents(final ProfileMonitor monitor, TickLogger logger) throws InterruptedException {
        TreeMap<ReferencedTickable.ReferenceId, TickTime> times = logger.getTimes();
        final Iterator<Map.Entry<ReferencedTickable.ReferenceId, TickTime>> referenceIterator = times.entrySet().iterator();
        final SortedSet<AnalyzedComponent> finishedAnalyzers = Collections.synchronizedSortedSet(new TreeSet());
        final ThreadPoolExecutor threadPool = new ThreadPoolExecutor(16, 32, 10L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>());
        Tiquality.SCHEDULER.scheduleWait(new Runnable(){

            @Override
            public void run() {
                monitor.progressUpdate((ITextComponent)new TextComponentString("Retrieving results in main thread..."));
                while (referenceIterator.hasNext()) {
                    Map.Entry entry = (Map.Entry)referenceIterator.next();
                    referenceIterator.remove();
                    threadPool.submit(new AnalyzedComponent.Analyzer(((ReferencedTickable.ReferenceId)entry.getKey()).convert(), (TickTime)entry.getValue(), finishedAnalyzers));
                }
            }
        });
        threadPool.shutdown();
        while (!threadPool.awaitTermination(5L, TimeUnit.SECONDS)) {
            long completed = threadPool.getCompletedTaskCount();
            long total = threadPool.getTaskCount();
            String percentage = Math.round((double)completed / (double)total * 100.0) + "%";
            monitor.progressUpdate((ITextComponent)new TextComponentString("Working: " + TextFormatting.WHITE + completed + TextFormatting.GRAY + "/" + TextFormatting.WHITE + total + TextFormatting.GRAY + " (" + TextFormatting.WHITE + percentage + TextFormatting.GRAY + ")"));
        }
        return finishedAnalyzers;
    }

    public void start() throws TiqualityException {
        this.key = this.tracker.startProfiler(System.currentTimeMillis() + this.durationInMs);
        this.startTimeNanos = System.nanoTime();
        new Thread((Runnable)this, "Tiquality profiler").start();
    }

    @Override
    public void run() {
        SortedSet<AnalyzedComponent> components;
        TickLogger logger;
        try {
            if (this.durationInMs <= 7000L) {
                Thread.sleep(this.durationInMs);
            } else {
                long remainder = this.durationInMs % 5000L;
                Thread.sleep(remainder);
                this.printer.progressUpdate((ITextComponent)new TextComponentString("Profiler finishes in " + TextFormatting.WHITE + (this.durationInMs - remainder) / 1000L + TextFormatting.GRAY + " seconds..."));
                long fiveSecondSteps = (this.durationInMs - remainder) / 5000L;
                int i = 0;
                while ((long)i < fiveSecondSteps) {
                    Thread.sleep(5000L);
                    long timeElapsed = (i + 1) * 5000;
                    long secondsLeft = (this.durationInMs - remainder - timeElapsed) / 1000L;
                    if (secondsLeft > 0L) {
                        this.printer.progressUpdate((ITextComponent)new TextComponentString("Profiler finishes in " + TextFormatting.WHITE + secondsLeft + TextFormatting.GRAY + " seconds..."));
                    }
                    ++i;
                }
            }
        }
        catch (InterruptedException e) {
            Tiquality.LOGGER.warn("Failed to sleep for " + this.durationInMs + " ms. Profiling aborted.");
            e.printStackTrace();
            return;
        }
        long endTimeNanos = System.nanoTime();
        try {
            logger = this.tracker.stopProfiler(this.key);
        }
        catch (TiqualityException.InvalidKeyException | TiqualityException.TrackerWasNotProfilingException e) {
            Tiquality.LOGGER.warn("Tried to stop profiler, but an exception occurred. This probably indicates a collision. Nothing fatal, but this should be looked in to. This means we do not have any results, however.");
            e.printStackTrace();
            return;
        }
        this.printer.progressUpdate((ITextComponent)new TextComponentString("Profiling complete. Analyzing results synchronously..."));
        try {
            components = SimpleProfiler.analyzeComponents(this.printer, logger);
        }
        catch (InterruptedException e) {
            this.printer.progressUpdate((ITextComponent)new TextComponentString(TextFormatting.RED + "Interrupted!"));
            return;
        }
        this.printer.progressUpdate((ITextComponent)new TextComponentString("Generating report asynchronously..."));
        ProfileReport report = new ProfileReport(this.startTimeNanos, endTimeNanos, logger, (ITextComponent)this.tracker.getInfo(), components);
        this.printer.progressUpdate((ITextComponent)new TextComponentString("Done!"));
        this.printer.report(report);
    }

    public static interface ProfilePrinter
    extends ProfileMonitor {
        public void report(ProfileReport var1);
    }

    public static interface ProfileMonitor {
        public void progressUpdate(ITextComponent var1);
    }
}

