/*
 * Decompiled with CFR 0.152.
 */
package com.github.terminatornl.tiquality.profiling;

import io.netty.buffer.ByteBuf;
import javax.annotation.Nonnull;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class TickTime
implements IMessage,
Comparable<TickTime> {
    private long nanosConsumed = 0L;
    private int calls = 0;

    public TickTime() {
    }

    public TickTime(TickTime other) {
        this.nanosConsumed = other.nanosConsumed;
        this.calls = other.calls;
    }

    public TickTime(ByteBuf byteBuf) {
        this.fromBytes(byteBuf);
    }

    public void consumeNanosIncrementCalls(long nanos) {
        this.nanosConsumed += nanos;
        ++this.calls;
    }

    public void add(TickTime times) {
        this.nanosConsumed += times.nanosConsumed;
        this.calls += times.calls;
    }

    public void addNanos(long nanosConsumed) {
        this.nanosConsumed = nanosConsumed;
    }

    public void addCalls(int calls) {
        this.calls = calls;
    }

    public void fromBytes(ByteBuf buf) {
        this.nanosConsumed = buf.readLong();
        this.calls = buf.readInt();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeLong(this.nanosConsumed);
        buf.writeInt(this.calls);
    }

    public long getNanosConsumed() {
        return this.nanosConsumed;
    }

    public int getCalls() {
        return this.calls;
    }

    public String toString() {
        return this.nanosConsumed + " ns, " + this.calls + " call" + (this.calls == 1 ? "" : "s");
    }

    @Override
    public int compareTo(@Nonnull TickTime o) {
        return Long.compare(this.nanosConsumed, o.nanosConsumed);
    }
}

