/*
 * Decompiled with CFR 0.152.
 */
package com.github.terminatornl.tiquality.tracking;

import com.github.terminatornl.tiquality.Tiquality;
import com.github.terminatornl.tiquality.api.TiqualityException;
import com.github.terminatornl.tiquality.api.event.TiqualityEvent;
import com.github.terminatornl.tiquality.interfaces.TiqualityChunk;
import com.github.terminatornl.tiquality.interfaces.TiqualityEntity;
import com.github.terminatornl.tiquality.interfaces.TiqualitySimpleTickable;
import com.github.terminatornl.tiquality.interfaces.TiqualityWorld;
import com.github.terminatornl.tiquality.interfaces.Tracker;
import com.github.terminatornl.tiquality.profiling.ProfilingKey;
import com.github.terminatornl.tiquality.profiling.TickLogger;
import com.github.terminatornl.tiquality.tracking.TrackerHolder;
import com.github.terminatornl.tiquality.tracking.update.BlockRandomUpdateHolder;
import com.github.terminatornl.tiquality.tracking.update.BlockUpdateHolder;
import com.github.terminatornl.tiquality.util.SynchronizedAction;
import com.mojang.authlib.GameProfile;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;

public class ForcedTracker
implements Tracker {
    public static final ForcedTracker INSTANCE = new ForcedTracker();
    private boolean isProfiling = false;
    private TickLogger tickLogger = new TickLogger();
    private ProfilingKey key;
    private TrackerHolder holder = null;

    protected ForcedTracker() {
    }

    @Override
    @Nonnull
    public NBTTagCompound getNBT() {
        return new NBTTagCompound();
    }

    @Override
    @Nonnull
    public ProfilingKey startProfiler(long profileEndTime) throws TiqualityException.TrackerAlreadyProfilingException {
        if (this.isProfiling) {
            throw new TiqualityException.TrackerAlreadyProfilingException(this);
        }
        this.key = new ProfilingKey(profileEndTime);
        Tiquality.SCHEDULER.schedule(new Runnable(){

            @Override
            public void run() {
                ForcedTracker.this.isProfiling = true;
            }
        });
        return this.key;
    }

    @Override
    @Nonnull
    public TickLogger stopProfiler(ProfilingKey key) throws TiqualityException.InvalidKeyException {
        if (this.key != key) {
            throw new TiqualityException.InvalidKeyException(this, this.key);
        }
        return SynchronizedAction.run(new SynchronizedAction.Action<TickLogger>(){

            @Override
            public void run(SynchronizedAction.DynamicVar<TickLogger> variable) {
                if (ForcedTracker.this.isProfiling) {
                    ForcedTracker.this.isProfiling = false;
                    MinecraftForge.EVENT_BUS.post((Event)new TiqualityEvent.ProfileCompletedEvent(ForcedTracker.this, ForcedTracker.this.tickLogger));
                    variable.set(ForcedTracker.this.tickLogger);
                    ForcedTracker.this.tickLogger = new TickLogger();
                }
            }
        });
    }

    @Override
    public boolean canProfile() {
        return true;
    }

    @Override
    public boolean isProfiling() {
        return this.isProfiling;
    }

    @Override
    public long getProfileEndTime() {
        return this.key == null ? 0L : this.key.getProfileEndTime();
    }

    @Override
    public void setNextTickTime(long granted_ns) {
        if (this.isProfiling) {
            this.tickLogger.addServerTick(granted_ns);
        }
    }

    @Override
    public Tracker load(TiqualityWorld world, NBTTagCompound trackerTag) {
        throw new UnsupportedOperationException("How can ForcedTracker be loaded, when it is never saved?");
    }

    @Override
    public boolean shouldSaveToDisk() {
        return false;
    }

    @Override
    public void tickSimpleTickable(TiqualitySimpleTickable tileEntity) {
        if (this.isProfiling) {
            long start = System.nanoTime();
            Tiquality.TICK_EXECUTOR.onTileEntityTick((ITickable)tileEntity);
            long elapsed = System.nanoTime() - start;
            this.tickLogger.addNanosAndIncrementCalls(tileEntity.getId(), elapsed);
        } else {
            Tiquality.TICK_EXECUTOR.onTileEntityTick((ITickable)tileEntity);
        }
    }

    @Override
    public void doBlockTick(Block block, World world, BlockPos pos, IBlockState state, Random rand) {
        if (this.isProfiling) {
            long start = System.nanoTime();
            Tiquality.TICK_EXECUTOR.onBlockTick(block, world, pos, state, rand);
            long elapsed = System.nanoTime() - start;
            this.tickLogger.addNanosAndIncrementCalls(BlockUpdateHolder.getId(world.field_73011_w.getDimension(), pos), elapsed);
        } else {
            Tiquality.TICK_EXECUTOR.onBlockTick(block, world, pos, state, rand);
        }
    }

    @Override
    public void doRandomBlockTick(Block block, World world, BlockPos pos, IBlockState state, Random rand) {
        if (this.isProfiling) {
            long start = System.nanoTime();
            Tiquality.TICK_EXECUTOR.onRandomBlockTick(block, world, pos, state, rand);
            long elapsed = System.nanoTime() - start;
            this.tickLogger.addNanosAndIncrementCalls(BlockRandomUpdateHolder.getId(world.field_73011_w.getDimension(), pos), elapsed);
        } else {
            Tiquality.TICK_EXECUTOR.onRandomBlockTick(block, world, pos, state, rand);
        }
    }

    @Override
    public void grantTick() {
        throw new UnsupportedOperationException("ForcedTracker does not need ticks");
    }

    @Override
    public void addTickableToQueue(TiqualitySimpleTickable tickable) {
        tickable.tiquality_doUpdateTick();
    }

    @Override
    public void associateChunk(TiqualityChunk chunk) {
    }

    @Override
    public void associateDelegatingTracker(Tracker tracker) {
        throw new UnsupportedOperationException("ForcedTracker should not be delegated");
    }

    @Override
    public void removeDelegatingTracker(Tracker tracker) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Nonnull
    public List<GameProfile> getAssociatedPlayers() {
        return Collections.emptyList();
    }

    @Override
    public void tickEntity(TiqualityEntity entity) {
        if (this.isProfiling) {
            long start = System.nanoTime();
            Tiquality.TICK_EXECUTOR.onEntityTick((Entity)entity);
            long elapsed = System.nanoTime() - start;
            this.tickLogger.addNanosAndIncrementCalls(entity.getId(), elapsed);
        } else {
            Tiquality.TICK_EXECUTOR.onEntityTick((Entity)entity);
        }
    }

    @Override
    public double getMultiplier(GameProfile[] cache) {
        return 0.0;
    }

    @Override
    public long getRemainingTime() {
        return 0L;
    }

    @Override
    public boolean needsTick() {
        return false;
    }

    @Override
    public String toString() {
        return "ForcedTracker:{hashCode: " + System.identityHashCode(this) + "}";
    }

    @Override
    @Nonnull
    public TextComponentString getInfo() {
        return new TextComponentString(TextFormatting.LIGHT_PURPLE + "Forced");
    }

    @Override
    @Nonnull
    public String getIdentifier() {
        throw new UnsupportedOperationException("Attempt to get the identifier for ForcedTracker.");
    }

    @Override
    public int getHashCode() {
        return 0;
    }

    @Override
    public boolean shouldUnload() {
        return false;
    }

    @Override
    public void onUnload() {
        throw new UnsupportedOperationException("Unloading ForcedTracker is never allowed.");
    }

    @Override
    public boolean isLoaded() {
        return true;
    }

    @Override
    public boolean equalsSaved(NBTTagCompound tag) {
        return true;
    }

    @Override
    public TrackerHolder getHolder() {
        return this.holder;
    }

    @Override
    public void setHolder(TrackerHolder holder) {
        this.holder = holder;
    }

    @Override
    @Nonnull
    public TickLogger getTickLogger() throws TiqualityException.TrackerWasNotProfilingException {
        if (!this.isProfiling) {
            throw new TiqualityException.TrackerWasNotProfilingException(this);
        }
        return this.tickLogger;
    }

    public boolean equals(Object o) {
        if (!(o instanceof ForcedTracker)) {
            return false;
        }
        if (o == this) {
            return true;
        }
        throw new IllegalStateException("Detected two ForcedTracker objects, this is impossible. HALT");
    }

    public int hashCode() {
        return 0;
    }
}

