/*
 * Decompiled with CFR 0.152.
 */
package com.github.terminatornl.tiquality.tracking;

import com.github.terminatornl.tiquality.interfaces.Tracker;
import com.github.terminatornl.tiquality.util.ForgetFulProgrammerException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import javax.annotation.Nullable;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.event.HoverEvent;

public enum UpdateType {
    DEFAULT,
    NATURAL,
    PRIORITY,
    TICK_DENIED,
    ALWAYS_TICK;

    public static boolean WORLD_IS_REMOTE;

    public static ITextComponent getArguments(Type type, TextFormatting textColour) {
        LinkedList<Object> list = new LinkedList<Object>();
        Iterator<UpdateType> iterator = Arrays.asList(UpdateType.values()).iterator();
        while (iterator.hasNext()) {
            list.add(iterator.next().getText(type));
            if (!iterator.hasNext()) break;
            list.add(new TextComponentString(textColour + " | "));
        }
        list.add(new TextComponentString(textColour + ">"));
        TextComponentString builder = new TextComponentString(textColour + "<");
        for (ITextComponent iTextComponent : list) {
            builder.func_150257_a(iTextComponent);
        }
        return builder;
    }

    public boolean mustTick(@Nullable Tracker tracker) {
        if (WORLD_IS_REMOTE) {
            return true;
        }
        switch (this) {
            case DEFAULT: 
            case PRIORITY: 
            case TICK_DENIED: {
                return false;
            }
            case NATURAL: {
                return tracker == null;
            }
            case ALWAYS_TICK: {
                return true;
            }
        }
        throw new ForgetFulProgrammerException();
    }

    public ITextComponent getText(Type type) {
        Style style;
        block23: {
            block22: {
                style = new Style();
                if (type != Type.BLOCK) break block22;
                switch (this) {
                    case DEFAULT: {
                        style.func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (ITextComponent)new TextComponentString("Only ticks when a tracker is assigned AND has time to tick.\nCan be throttled")));
                        break block23;
                    }
                    case PRIORITY: {
                        style.func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (ITextComponent)new TextComponentString("Like " + TextFormatting.GRAY + "DEFAULT" + TextFormatting.RESET + ", but ticks before everything else.\nCan be throttled")));
                        break block23;
                    }
                    case TICK_DENIED: {
                        style.func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (ITextComponent)new TextComponentString("Never ticks.")));
                        break block23;
                    }
                    case NATURAL: {
                        style.func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (ITextComponent)new TextComponentString("Ticks when no tracker is assigned.\nWhen a tracker has been assigned, it can be throttled if no time is left.")));
                        break block23;
                    }
                    case ALWAYS_TICK: {
                        style.func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (ITextComponent)new TextComponentString("Always ticks.\nNever throttled")));
                        break block23;
                    }
                    default: {
                        throw new ForgetFulProgrammerException();
                    }
                }
            }
            if (type == Type.ENTITY) {
                switch (this) {
                    case DEFAULT: {
                        style.func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (ITextComponent)new TextComponentString("Ticks when no tracker is assigned.\nWhen a tracker has been assigned, it can be throttled if no time is left.")));
                        break;
                    }
                    case PRIORITY: {
                        style.func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (ITextComponent)new TextComponentString("Like " + TextFormatting.GRAY + "DEFAULT" + TextFormatting.RESET + ", but ticks before everything else.\nCan be throttled")));
                        break;
                    }
                    case TICK_DENIED: {
                        style.func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (ITextComponent)new TextComponentString("Never ticks.")));
                        break;
                    }
                    case NATURAL: {
                        style.func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (ITextComponent)new TextComponentString("Like DEFAULT")));
                        break;
                    }
                    case ALWAYS_TICK: {
                        style.func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (ITextComponent)new TextComponentString("Always ticks.\nNever throttled")));
                        break;
                    }
                    default: {
                        throw new ForgetFulProgrammerException();
                    }
                }
            }
        }
        switch (this) {
            case DEFAULT: {
                return new TextComponentString(TextFormatting.GRAY + "DEFAULT").func_150255_a(style);
            }
            case PRIORITY: {
                return new TextComponentString(TextFormatting.AQUA + "PRIORITY").func_150255_a(style);
            }
            case TICK_DENIED: {
                return new TextComponentString(TextFormatting.DARK_RED + "TICK_DENIED").func_150255_a(style);
            }
            case NATURAL: {
                return new TextComponentString(TextFormatting.GOLD + "NATURAL").func_150255_a(style);
            }
            case ALWAYS_TICK: {
                return new TextComponentString(TextFormatting.GREEN + "ALWAYS_TICK").func_150255_a(style);
            }
        }
        throw new ForgetFulProgrammerException();
    }

    static {
        WORLD_IS_REMOTE = false;
    }

    public static enum Type {
        ENTITY,
        BLOCK;

    }
}

