/*
 * Decompiled with CFR 0.152.
 */
package com.github.terminatornl.tiquality.tracking.tickqueue;

import com.github.terminatornl.tiquality.TiqualityConfig;
import com.github.terminatornl.tiquality.api.TiqualityException;
import com.github.terminatornl.tiquality.interfaces.TiqualitySimpleTickable;
import com.github.terminatornl.tiquality.interfaces.Tracker;
import com.github.terminatornl.tiquality.profiling.ReferencedTickable;
import com.github.terminatornl.tiquality.tracking.UpdateType;
import com.github.terminatornl.tiquality.tracking.tickqueue.TickQueue;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class RelativeTPSTracker
implements TiqualitySimpleTickable {
    private final TickQueue queue;
    private int worldTicks = 0;
    private int actualTrackerTicks = 0;
    private double tps = 20.0;
    private int mark_count = 0;
    private boolean tickedThisTick = false;
    private long startTime = System.currentTimeMillis();

    RelativeTPSTracker(TickQueue queue) {
        this.queue = queue;
        this.queue.addToQueue(this);
    }

    public void reset() {
        this.worldTicks = 0;
        this.actualTrackerTicks = 0;
        this.startTime = System.currentTimeMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getTps() {
        RelativeTPSTracker relativeTPSTracker = this;
        synchronized (relativeTPSTracker) {
            return this.tps;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTPS(double trackerTPS, double worldTPS) {
        Tracker tracker;
        RelativeTPSTracker relativeTPSTracker = this;
        synchronized (relativeTPSTracker) {
            this.tps = trackerTPS;
        }
        double ratio = trackerTPS / worldTPS;
        if (ratio <= TiqualityConfig.DEFAULT_THROTTLE_WARNING_LEVEL && (tracker = (Tracker)this.queue.tracker.get()) != null) {
            tracker.notifyFallingBehind(ratio);
        }
    }

    public void notifyNextTick() {
        ++this.worldTicks;
        this.tickedThisTick = false;
        if (this.mark_count == 0) {
            this.queue.addToQueue(this);
        }
        if (this.worldTicks % 100 == 0) {
            long endTime = System.currentTimeMillis();
            double durationInSeconds = (double)(endTime - this.startTime) / 1000.0;
            double worldTPS = (double)this.worldTicks / durationInSeconds;
            this.setTPS((double)this.actualTrackerTicks / durationInSeconds, worldTPS);
            this.reset();
        }
    }

    @Override
    public boolean tiquality_isLoaded() {
        return true;
    }

    @Override
    public void tiquality_doUpdateTick() {
        if (!this.tickedThisTick) {
            ++this.actualTrackerTicks;
            this.queue.addToQueue(this);
            Tracker tracker = (Tracker)this.queue.tracker.get();
            if (tracker != null && tracker.isProfiling()) {
                try {
                    tracker.getTickLogger().addTrackerTick();
                }
                catch (TiqualityException.TrackerWasNotProfilingException e) {
                    e.printStackTrace();
                }
            }
        }
        this.tickedThisTick = true;
    }

    @Override
    public BlockPos tiquality_getPos() {
        return null;
    }

    @Override
    public World tiquality_getWorld() {
        return null;
    }

    @Override
    @Nullable
    public ReferencedTickable.Reference getId() {
        return null;
    }

    @Override
    public void tiquality_mark() {
        ++this.mark_count;
    }

    @Override
    public void tiquality_unMark() {
        --this.mark_count;
    }

    @Override
    public boolean tiquality_isMarked() {
        return this.mark_count > 0;
    }

    @Override
    @Nonnull
    public UpdateType getUpdateType() {
        return UpdateType.DEFAULT;
    }

    @Override
    public void setUpdateType(@Nonnull UpdateType type) {
    }
}

