/*
 * Decompiled with CFR 0.152.
 */
package com.github.terminatornl.tiquality.util;

import com.github.terminatornl.tiquality.Tiquality;
import com.github.terminatornl.tiquality.mixinhelper.MixinConfigPlugin;
import com.github.terminatornl.tiquality.util.SpongeData;
import com.mojang.authlib.GameProfile;
import java.lang.reflect.Field;
import java.util.Map;
import java.util.TreeSet;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.common.util.FakePlayerFactory;
import net.minecraftforge.fml.common.FMLCommonHandler;

public class ForgeData {
    public static final GameProfile GAME_PROFILE_NOBODY = new GameProfile(new UUID(0x7FFFFFFFFFFFFFF8L, Long.MAX_VALUE), "[Unknown]");
    public static final TreeSet<UUID> WEIRD_GAME_PROFILES = new TreeSet();
    public static final MinecraftServer SERVER = FMLCommonHandler.instance().getMinecraftServerInstance();

    @Nonnull
    public static GameProfile getGameProfileByUUID(@Nonnull UUID uuid) {
        GameProfile profile = SERVER.func_152358_ax().func_152652_a(uuid);
        if (profile != null) {
            return profile;
        }
        if (WEIRD_GAME_PROFILES.contains(uuid)) {
            return GAME_PROFILE_NOBODY;
        }
        Tiquality.LOGGER.warn("Player profile was not found in cache!");
        Tiquality.LOGGER.warn("I will add it, but it can cause some lag, as I may or may not contact the Mojang servers to get go and get it.");
        Tiquality.LOGGER.warn("UUID: " + uuid.toString());
        Tiquality.LOGGER.warn("Most significant bits:  " + uuid.getMostSignificantBits());
        Tiquality.LOGGER.warn("Least significant bits: " + uuid.getLeastSignificantBits());
        if (MixinConfigPlugin.spongePresent) {
            profile = SpongeData.getProfileByUUID(uuid);
        }
        try {
            Field fakePlayers = FakePlayerFactory.class.getDeclaredField("fakePlayers");
            fakePlayers.setAccessible(true);
            Map map = (Map)fakePlayers.get(null);
            for (GameProfile fakePlayerProfile : map.keySet()) {
                if (fakePlayerProfile.getId() != uuid) continue;
                SERVER.func_152358_ax().func_152649_a(fakePlayerProfile);
                return fakePlayerProfile;
            }
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            e.printStackTrace();
        }
        if (profile == null) {
            profile = new GameProfile(uuid, null);
            try {
                SERVER.func_147130_as().fillProfileProperties(profile, false);
            }
            catch (Exception e) {
                Tiquality.LOGGER.warn("Failed attempt to fill profile (Stage 1)");
                e.printStackTrace();
            }
        }
        if (profile.getName() == null) {
            try {
                SERVER.func_147130_as().fillProfileProperties(profile, true);
            }
            catch (Exception e) {
                Tiquality.LOGGER.warn("Failed attempt to fill profile (Stage 2)");
                e.printStackTrace();
            }
        }
        if (profile.getName() == null) {
            Tiquality.LOGGER.warn("This UUID cannot be resolved no matter what I do. (Fake player?)");
            Tiquality.LOGGER.warn("Temporarily storing this UUID for quick lookup. During this run, we're returning the following profile: " + GAME_PROFILE_NOBODY.toString());
            WEIRD_GAME_PROFILES.add(uuid);
            return GAME_PROFILE_NOBODY;
        }
        SERVER.func_152358_ax().func_152649_a(profile);
        return profile;
    }

    @Nullable
    public static GameProfile getGameProfileByName(String name) {
        return SERVER.func_152358_ax().func_152655_a(name);
    }
}

