/*
 * Decompiled with CFR 0.152.
 */
package com.github.terminatornl.tiquality.util;

import com.github.terminatornl.tiquality.Tiquality;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;

public enum PersistentData {
    NEXT_FREE_TRACKER_ID,
    ID_TO_TRACKER,
    TRACKER_LOOKUP;

    private ReentrantLock LOCK = new ReentrantLock();
    private static File persistentFile;
    private static NBTTagCompound storage;
    private static File worldFolder;
    private static File tiqualityFolder;
    private static File tiqualityWorldData;

    public static void updatePersistentFileAndStorage(World world) {
        try {
            File worldFolderTmp = world.func_72860_G().func_75765_b();
            if (worldFolderTmp.equals(worldFolder)) {
                return;
            }
            worldFolder = worldFolderTmp;
            tiqualityFolder = new File(worldFolder, "TiqualityStorage");
            persistentFile = new File(tiqualityFolder, "Storage");
            tiqualityWorldData = new File(tiqualityFolder, "WorldData");
            if (!tiqualityFolder.exists() && !tiqualityFolder.mkdirs()) {
                throw new RuntimeException(new IOException("Unable to create directory at: " + tiqualityFolder));
            }
            Tiquality.LOGGER.info("Persistent data is inside: " + tiqualityFolder.getCanonicalPath());
            NBTTagCompound read_tag = CompressedStreamTools.func_74797_a((File)persistentFile);
            storage = read_tag == null ? new NBTTagCompound() : read_tag;
            PersistentData.save();
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to read persistent data file.", e);
        }
    }

    @Nonnull
    public static File getChunkFile(Chunk chunk) {
        int dim = chunk.func_177412_p().field_73011_w.getDimension();
        String pos = chunk.field_76635_g + "_" + chunk.field_76647_h + ".nbt";
        File worldFile = new File(tiqualityWorldData, String.valueOf(dim));
        return new File(worldFile, pos);
    }

    @Nonnull
    public static File getTempChunkFile(Chunk chunk) {
        int dim = chunk.func_177412_p().field_73011_w.getDimension();
        String pos = chunk.field_76635_g + "_" + chunk.field_76647_h + ".tmp.nbt";
        File worldFile = new File(tiqualityWorldData, String.valueOf(dim));
        return new File(worldFile, pos);
    }

    @Nullable
    public static NBTTagCompound getChunkNBTData(Chunk chunk) {
        File chunkFile = PersistentData.getChunkFile(chunk);
        if (!chunkFile.exists()) {
            return null;
        }
        try {
            return CompressedStreamTools.func_74796_a((InputStream)new FileInputStream(chunkFile));
        }
        catch (IOException e) {
            Tiquality.LOGGER.fatal("FAILED TO LOAD DATA FOR CHUNK AT " + chunk.func_76632_l());
            e.printStackTrace();
            return null;
        }
    }

    public static void saveChunkNBTData(Chunk chunk, @Nullable NBTTagCompound tag) throws IOException {
        File tempFile = PersistentData.getTempChunkFile(chunk);
        File chunkFile = PersistentData.getChunkFile(chunk);
        if (tag == null) {
            if (chunkFile.exists() && !chunkFile.delete()) {
                throw new IOException("Unable to remove file: " + chunkFile);
            }
            return;
        }
        if (!tempFile.exists()) {
            if (!tempFile.getParentFile().exists() && !tempFile.getParentFile().mkdirs()) {
                throw new IOException("Unable to create directories at: " + tempFile.getParentFile());
            }
            try {
                if (!tempFile.createNewFile()) {
                    throw new IOException("Unable to create file at: " + tempFile);
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        CompressedStreamTools.func_74799_a((NBTTagCompound)tag, (OutputStream)new FileOutputStream(tempFile));
        if (chunkFile.exists() && !chunkFile.delete()) {
            throw new IOException("Failed to remove old file: " + chunkFile);
        }
        if (!tempFile.renameTo(chunkFile)) {
            throw new IOException("Failed to rename file " + tempFile + " to " + chunkFile);
        }
    }

    public static synchronized void ensureDataAvailability(World world) {
        if (!PersistentData.isAvailable()) {
            PersistentData.updatePersistentFileAndStorage(world);
        }
    }

    public static boolean isAvailable() {
        return storage != null;
    }

    public static void deactivate() {
        storage = null;
        persistentFile = null;
        worldFolder = null;
        tiqualityFolder = null;
    }

    public static void save() {
        try {
            if (!persistentFile.exists()) {
                if (!persistentFile.getParentFile().exists() && !persistentFile.getParentFile().mkdirs()) {
                    throw new IOException("Failed to create directories for: " + persistentFile);
                }
                if (!persistentFile.createNewFile()) {
                    throw new IOException("Failed to create file at: " + persistentFile);
                }
            }
            CompressedStreamTools.func_74795_b((NBTTagCompound)storage, (File)persistentFile);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to write persistent data file.", e);
        }
    }

    public void lock() {
        this.LOCK.lock();
    }

    public void unlock() {
        this.LOCK.unlock();
    }

    public boolean isSet() {
        return storage.func_74764_b(this.name());
    }

    public long getLong() {
        return storage.func_74763_f(this.name());
    }

    public void setLong(long l) {
        storage.func_74772_a(this.name(), l);
        PersistentData.save();
    }

    public NBTTagCompound getCompoundTag() {
        return storage.func_74775_l(this.name());
    }

    public void setCompoundTag(NBTTagCompound tag) {
        storage.func_74782_a(this.name(), (NBTBase)tag);
        PersistentData.save();
    }
}

