/*
 * Decompiled with CFR 0.152.
 */
package com.github.terminatornl.tiquality.util;

import com.github.terminatornl.tiquality.util.Copyable;
import io.netty.buffer.ByteBuf;
import java.util.Map;
import java.util.TreeMap;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class SendableTreeMap<K extends IMessage & Copyable<K>, V extends IMessage & Copyable<V>>
extends TreeMap<K, V>
implements IMessage,
Copyable {
    private ClassTypeHolder checkClassTypes() {
        Class<?> keyClass = null;
        Class<?> valueClass = null;
        for (Map.Entry e : super.entrySet()) {
            if (keyClass == null) {
                keyClass = ((IMessage)e.getKey()).getClass();
                valueClass = ((IMessage)e.getValue()).getClass();
                continue;
            }
            if (keyClass != ((IMessage)e.getKey()).getClass()) {
                throw new IllegalStateException("Different instance types (classes) found in the keys of the map! This is not allowed!");
            }
            if (valueClass == ((IMessage)e.getValue()).getClass()) continue;
            throw new IllegalStateException("Different instance types (classes) found in the values of the map! This is not allowed!");
        }
        return new ClassTypeHolder(keyClass, valueClass);
    }

    public SendableTreeMap<K, V> copy() {
        SendableTreeMap clone = new SendableTreeMap();
        for (Map.Entry s : super.entrySet()) {
            clone.put(((Copyable)((IMessage)s.getKey())).copy(), ((Copyable)((IMessage)s.getValue())).copy());
        }
        return clone;
    }

    public void toBytes(ByteBuf buf) {
        ClassTypeHolder types = this.checkClassTypes();
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)types.key.getName());
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)types.value.getName());
        buf.writeInt(super.size());
        for (Map.Entry e : super.entrySet()) {
            ((IMessage)e.getKey()).toBytes(buf);
            ((IMessage)e.getValue()).toBytes(buf);
        }
    }

    public void fromBytes(ByteBuf buf) {
        try {
            Class<?> keyClass = Class.forName(ByteBufUtils.readUTF8String((ByteBuf)buf));
            Class<?> valueClass = Class.forName(ByteBufUtils.readUTF8String((ByteBuf)buf));
            int size = buf.readInt();
            for (int i = 0; i < size; ++i) {
                IMessage key = (IMessage)keyClass.newInstance();
                key.fromBytes(buf);
                IMessage value = (IMessage)valueClass.newInstance();
                value.fromBytes(buf);
                super.put(key, value);
            }
        }
        catch (ClassCastException | ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw new RuntimeException(e);
        }
    }

    private static class ClassTypeHolder {
        final Class key;
        final Class value;

        private ClassTypeHolder(Class key, Class value) {
            this.key = key;
            this.value = value;
        }
    }
}

