/*
 * Decompiled with CFR 0.152.
 */
package com.github.terminatornl.tiquality.world;

import com.github.terminatornl.tiquality.interfaces.TiqualityChunk;
import com.github.terminatornl.tiquality.interfaces.TiqualityEntity;
import com.github.terminatornl.tiquality.util.CountingMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.chunk.Chunk;

public class ChunkStorage {
    private Element[] data;
    private byte dominatingTracker = 0;
    private int domination = 0;
    private TiqualityChunk chunk;

    public ChunkStorage(TiqualityChunk chunk) {
        this.chunk = chunk;
        this.clearAll();
    }

    public void clearAll() {
        this.data = new Element[this.chunk.getMinecraftChunk().func_177412_p().func_72800_K() / 16];
        this.dominatingTracker = 0;
        this.domination = 0;
    }

    public byte getDominatingTracker() {
        return this.dominatingTracker;
    }

    public byte get(BlockPos pos) {
        int y_layer = pos.func_177956_o() >> 4;
        return this.data[y_layer] == null ? (byte)1 : this.data[y_layer].get(pos);
    }

    public void set(BlockPos pos, byte owner_id) {
        int y_layer = pos.func_177956_o() >> 4;
        if (this.data[y_layer] == null) {
            this.data[y_layer] = new Element();
        }
        if (owner_id == this.dominatingTracker) {
            this.domination = this.data[y_layer].set(pos, owner_id) == 0 ? ++this.domination : ++this.domination;
        } else {
            if (this.data[y_layer].set(pos, owner_id) == this.dominatingTracker) {
                --this.domination;
            }
            if (owner_id != 0) {
                --this.domination;
            }
            if (this.domination <= 0) {
                this.recalculateDominatingTracker();
            }
        }
    }

    public void mark(BlockPos pos) {
        int y_layer = pos.func_177956_o() >> 4;
        if (this.data[y_layer] == null) {
            this.data[y_layer] = new Element();
        }
        this.data[y_layer].mark(pos);
    }

    public void unMark(BlockPos pos) {
        int y_layer = pos.func_177956_o() >> 4;
        if (this.data[y_layer] == null) {
            this.data[y_layer] = new Element();
        }
        this.data[y_layer].unmark(pos);
    }

    public boolean isMarked(BlockPos pos) {
        int y_layer = pos.func_177956_o() >> 4;
        return this.data[y_layer] != null && this.data[y_layer].isMarked(pos);
    }

    public ArrayList<byte[]> getAll() {
        ArrayList<byte[]> list = new ArrayList<byte[]>();
        for (Element e : this.data) {
            if (e == null || !e.hasData()) continue;
            list.add(e.getUnmarkedCopy());
        }
        return list;
    }

    public void setAll(byte owner_id) {
        this.data = new Element[16];
        byte[] storage = new byte[4096];
        Arrays.fill(storage, owner_id);
        for (int i = 0; i < this.data.length; ++i) {
            this.data[i] = new Element(Arrays.copyOf(storage, 4096));
        }
        this.dominatingTracker = owner_id;
        this.domination = 4096 * this.data.length;
    }

    public void replaceAll(byte old, byte new_) {
        int count = 0;
        for (Element e : this.data) {
            if (e == null) continue;
            count += e.replaceAll(old, new_);
        }
        if (old == this.dominatingTracker) {
            this.domination -= count;
        }
        if (new_ == this.dominatingTracker) {
            this.domination += count;
        }
    }

    public void loadFromNBT(@Nonnull NBTTagCompound list, @Nonnull Chunk chunk) {
        for (String key : list.func_150296_c()) {
            int y = Integer.parseInt(key);
            byte[] storage = list.func_74770_j(key);
            this.data[y] = new Element(storage);
            this.data[y].queueMarkedForUpdate(chunk, y);
        }
    }

    public void recalculateDominatingTracker() {
        CountingMap<Byte> map = new CountingMap<Byte>();
        for (Element element : this.data) {
            if (element == null) continue;
            for (byte b : element.getUnmarkedCopy()) {
                if (b == 0) continue;
                map.addCount(b, 1);
            }
        }
        if (map.size() > 0) {
            Map.Entry dominator = Collections.max(map.entrySet(), Map.Entry.comparingByValue());
            this.dominatingTracker = (Byte)dominator.getKey();
            this.domination = (Integer)dominator.getValue();
            for (Map.Entry e : map.entrySet()) {
                if ((Byte)e.getKey() == this.dominatingTracker) continue;
                this.domination -= ((Integer)e.getValue()).intValue();
            }
        } else {
            this.dominatingTracker = 0;
            this.domination = 0;
        }
        for (Element element : this.chunk.getMinecraftChunk().func_177429_s()) {
            if (element == null) continue;
            Object object = element.iterator();
            while (object.hasNext()) {
                Entity entity = (Entity)object.next();
                ((TiqualityEntity)entity).setTracker(this.chunk.getCachedMostDominantTracker());
            }
        }
    }

    @Nullable
    public NBTTagCompound getNBT() {
        NBTTagCompound list = new NBTTagCompound();
        for (int i = 0; i < this.data.length; ++i) {
            Element e = this.data[i];
            if (e == null || !e.hasData()) continue;
            list.func_74773_a(Integer.toString(i), e.getData());
        }
        return list.func_186856_d() == 0 ? null : list;
    }

    public static class Element {
        private final byte[] storage;

        Element() {
            this.storage = new byte[4096];
        }

        Element(byte[] storage) {
            this.storage = storage;
        }

        boolean hasData() {
            for (byte b : this.storage) {
                if (b == 0 || b == 1) continue;
                return true;
            }
            return false;
        }

        int getIndex(BlockPos pos) {
            return (pos.func_177956_o() & 0xF) << 8 | (pos.func_177952_p() & 0xF) << 4 | pos.func_177958_n() & 0xF;
        }

        int getIndex(int x, int y, int z) {
            return (y & 0xF) << 8 | (z & 0xF) << 4 | x & 0xF;
        }

        byte get(BlockPos pos) {
            return (byte)(this.storage[this.getIndex(pos)] & 0x7F);
        }

        byte set(BlockPos pos, byte owner_id) {
            int index = this.getIndex(pos);
            byte oldvar = this.storage[index];
            this.storage[index] = owner_id;
            return oldvar;
        }

        int replaceAll(byte old, byte new_) {
            int count = 0;
            for (int i = 0; i < this.storage.length; ++i) {
                if (this.storage[i] != old && (this.storage[i] ^ 0xFFFFFF80) != old) continue;
                this.storage[i] = new_;
                ++count;
            }
            return count;
        }

        byte[] getUnmarkedCopy() {
            byte[] copy = new byte[this.storage.length];
            for (int i_ = 0; i_ < this.storage.length; ++i_) {
                copy[i_] = (byte)(this.storage[i_] & 0x7F);
            }
            return copy;
        }

        byte[] getData() {
            return this.storage;
        }

        void mark(BlockPos pos) {
            int n = this.getIndex(pos);
            this.storage[n] = (byte)(this.storage[n] | 0xFFFFFF80);
        }

        void unmark(BlockPos pos) {
            int n = this.getIndex(pos);
            this.storage[n] = (byte)(this.storage[n] & 0x7F);
        }

        boolean isMarked(BlockPos pos) {
            return this.storage[this.getIndex(pos)] < 0;
        }

        public void queueMarkedForUpdate(Chunk chunk, int y_level) {
            BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
            ChunkPos chunkPos = chunk.func_76632_l();
            for (int x = chunkPos.func_180334_c(); x < chunkPos.func_180332_e(); ++x) {
                for (int y = y_level * 16; y < y_level * 16 + 16; ++y) {
                    for (int z = chunkPos.func_180333_d(); z < chunkPos.func_180330_f(); ++z) {
                        pos.func_181079_c(x, y, z);
                        if (!this.isMarked((BlockPos)pos)) continue;
                        BlockPos realPos = pos.func_185334_h();
                        IBlockState state = chunk.func_177435_g(realPos);
                        this.unmark(realPos);
                        chunk.func_177412_p().func_180497_b(realPos, state.func_177230_c(), 1, 0);
                    }
                }
            }
        }
    }
}

