/*
 * Decompiled with CFR 0.152.
 */
package openblocks.common.item;

import net.minecraft.client.model.ModelBiped;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import openblocks.Config;
import openblocks.OpenBlocks;
import openblocks.client.model.ModelCraneBackpack;
import openblocks.common.CraneRegistry;
import openmods.infobook.BookDocumentation;

@BookDocumentation(customName="crane_backpack", hasVideo=true)
public class ItemCraneBackpack
extends ItemArmor {
    public static final String TEXTURE_CRANE = OpenBlocks.location("textures/models/crane.png").toString();

    public ItemCraneBackpack() {
        super(ItemArmor.ArmorMaterial.IRON, 2, EntityEquipmentSlot.CHEST);
    }

    public boolean isValidArmor(ItemStack stack, EntityEquipmentSlot armorType, Entity entity) {
        return armorType == EntityEquipmentSlot.CHEST;
    }

    @SideOnly(value=Side.CLIENT)
    public ModelBiped getArmorModel(EntityLivingBase entityLiving, ItemStack itemStack, EntityEquipmentSlot armorSlot, ModelBiped _default) {
        return armorSlot == EntityEquipmentSlot.CHEST ? ModelCraneBackpack.instance : null;
    }

    public String getArmorTexture(ItemStack stack, Entity entity, EntityEquipmentSlot armorSlot, String type) {
        return TEXTURE_CRANE;
    }

    private static boolean isPointInBlock(World world, EntityPlayer player, double radius) {
        double posZ;
        double posY;
        double posX = player.field_70165_t + radius * (double)MathHelper.func_76134_b((float)((player.field_70177_z + 90.0f) * (float)Math.PI / 180.0f));
        AxisAlignedBB aabb = new AxisAlignedBB(posX - 0.1, (posY = player.field_70163_u + (double)player.func_70047_e() + 0.2) - 0.1, (posZ = player.field_70161_v + radius * (double)MathHelper.func_76126_a((float)((player.field_70177_z + 90.0f) * (float)Math.PI / 180.0f))) - 0.1, posX + 0.1, posY + 0.1, posZ + 0.1);
        return !world.func_184144_a((Entity)player, aabb).isEmpty();
    }

    public void onArmorTick(World world, EntityPlayer player, ItemStack itemStack) {
        CraneRegistry.Data data = CraneRegistry.instance.getData((EntityLivingBase)player, true);
        if (!world.field_72995_K) {
            CraneRegistry.instance.ensureMagnetExists((EntityLivingBase)player);
        }
        if (Config.doCraneCollisionCheck) {
            boolean isColliding;
            boolean bl = isColliding = ItemCraneBackpack.isPointInBlock(world, player, 2.0) || ItemCraneBackpack.isPointInBlock(world, player, 1.3333333333333333) || ItemCraneBackpack.isPointInBlock(world, player, 0.6666666666666666);
            if (isColliding) {
                player.field_70177_z = data.prevYaw;
                player.field_70165_t = data.prevPosX;
                player.field_70163_u = data.prevPosY;
                player.field_70161_v = data.prevPosZ;
                player.field_70179_y = 0.0;
                player.field_70181_x = 0.0;
                player.field_70159_w = 0.0;
            } else {
                data.prevYaw = player.field_70177_z;
                data.prevPosX = player.field_70165_t;
                data.prevPosY = player.field_70163_u;
                data.prevPosZ = player.field_70161_v;
            }
        }
    }

    public static boolean isWearingCrane(EntityLivingBase player) {
        ItemStack armor = player.func_184582_a(EntityEquipmentSlot.CHEST);
        return !armor.func_190926_b() && armor.func_77973_b() instanceof ItemCraneBackpack;
    }
}

