/*
 * Decompiled with CFR 0.152.
 */
package omtteam.omlib.handler;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.client.event.DrawBlockHighlightEvent;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistry;
import omtteam.omlib.OMLib;
import omtteam.omlib.api.gui.ISupportsBackSystem;
import omtteam.omlib.api.network.OMLibNetwork;
import omtteam.omlib.api.permission.OwnerShareRegister;
import omtteam.omlib.api.render.RenderManager;
import omtteam.omlib.handler.GUIBackSystem;
import omtteam.omlib.init.OMLibBlocks;
import omtteam.omlib.init.OMLibItems;
import omtteam.omlib.items.IDrawOutline;
import omtteam.omlib.items.IDrawOutlineBase;
import omtteam.omlib.network.OMLibNetworkingHandler;
import omtteam.omlib.network.messages.MessageSetSharePlayerList;
import omtteam.omlib.util.RenderUtil;

public class OMLibEventHandler {
    private static OMLibEventHandler instance;
    private List<OMLibNetwork> networks = new ArrayList<OMLibNetwork>();

    private OMLibEventHandler() {
    }

    public static OMLibEventHandler getInstance() {
        if (instance == null) {
            instance = new OMLibEventHandler();
        }
        return instance;
    }

    @SubscribeEvent
    public void playerJoinEvent(EntityJoinWorldEvent event) {
        if (!event.getWorld().field_72995_K && event.getEntity() instanceof EntityPlayerMP) {
            OMLibNetworkingHandler.sendMessageToPlayer(new MessageSetSharePlayerList(OwnerShareRegister.instance), (EntityPlayerMP)event.getEntity());
        }
    }

    @SubscribeEvent
    public void itemRegisterEvent(RegistryEvent.Register<Item> event) {
        OMLibItems.init((IForgeRegistry<Item>)event.getRegistry());
    }

    @SubscribeEvent
    public void blockRegisterEvent(RegistryEvent.Register<Block> event) {
        OMLibBlocks.initBlocks((IForgeRegistry<Block>)event.getRegistry());
    }

    @SubscribeEvent
    public void renderRegisterEvent(ModelRegistryEvent event) {
        OMLib.proxy.initRenderers();
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void drawBlockOutline(DrawBlockHighlightEvent event) {
        if (event.getTarget() != null && event.getTarget().field_178784_b != null && event.getPlayer().func_184614_ca() != ItemStack.field_190927_a && event.getPlayer().func_184614_ca().func_77973_b() instanceof IDrawOutline) {
            EnumFacing facing;
            BlockPos blockpos = event.getTarget().func_178782_a().func_177972_a(event.getTarget().field_178784_b);
            IDrawOutline item = (IDrawOutline)event.getPlayer().func_184614_ca().func_77973_b();
            if (item instanceof IDrawOutlineBase && ((IDrawOutlineBase)item).getBaseFacing(event.getPlayer().func_130014_f_(), blockpos) != null) {
                facing = ((IDrawOutlineBase)item).getBaseFacing(event.getPlayer().func_130014_f_(), blockpos);
            } else {
                if (item instanceof IDrawOutlineBase) {
                    return;
                }
                facing = event.getTarget().field_178784_b.func_176734_d();
            }
            AxisAlignedBB alignedBB = item.getRenderOutline(facing, event.getPlayer().func_130014_f_(), blockpos);
            EntityPlayer player = event.getPlayer();
            double partialTicks = event.getPartialTicks();
            double d0 = player.field_70142_S + (player.field_70165_t - player.field_70142_S) * partialTicks;
            double d1 = player.field_70137_T + (player.field_70163_u - player.field_70137_T) * partialTicks;
            double d2 = player.field_70136_U + (player.field_70161_v - player.field_70136_U) * partialTicks;
            float[] color = new float[3];
            if (event.getPlayer().func_130014_f_().func_175623_d(blockpos)) {
                color[0] = 0.0f;
                color[1] = 1.0f;
                color[2] = 1.0f;
            } else {
                color[0] = 1.0f;
                color[1] = 0.0f;
                color[2] = 0.0f;
            }
            alignedBB = alignedBB.func_72317_d(-d0, -d1, -d2);
            GlStateManager.func_179147_l();
            GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
            GlStateManager.func_187441_d((float)2.0f);
            GlStateManager.func_179090_x();
            GlStateManager.func_179132_a((boolean)false);
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder vertexbuffer = tessellator.func_178180_c();
            vertexbuffer.func_181668_a(3, DefaultVertexFormats.field_181706_f);
            RenderUtil.drawHighlightBox(vertexbuffer, alignedBB.field_72340_a, alignedBB.field_72338_b, alignedBB.field_72339_c, alignedBB.field_72336_d, alignedBB.field_72337_e, alignedBB.field_72334_f, color[0], color[1], color[2], 0.5f);
            tessellator.func_78381_a();
            GlStateManager.func_179132_a((boolean)true);
            GlStateManager.func_179098_w();
            GlStateManager.func_179084_k();
        }
    }

    @SubscribeEvent
    public void tickEvent(TickEvent.WorldTickEvent event) {
        for (OMLibNetwork network : this.networks) {
            if (network.getWorld().field_73011_w.getDimension() != event.world.field_73011_w.getDimension()) continue;
            network.tick();
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void renderWorldLastEvent(RenderWorldLastEvent event) {
        RenderManager.getInstance().renderWorldLastEvent(event.getContext(), event.getPartialTicks());
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void playerGUIEvent(GuiOpenEvent event) {
        if (event.getGui() instanceof ISupportsBackSystem && ((ISupportsBackSystem)event.getGui()).getGuiParameters() != null) {
            GUIBackSystem.getInstance().addGuiToStack((ISupportsBackSystem)event.getGui());
        } else if (event.getGui() == null) {
            GUIBackSystem.getInstance().clearStack();
        }
    }

    private List<OMLibNetwork> getNetworkList() {
        return this.networks;
    }

    public void registerNetwork(OMLibNetwork network) {
        this.networks.add(network);
    }

    public void removeNetwork(OMLibNetwork network) {
        this.networks.remove(network);
    }

    @Nullable
    public OMLibNetwork getNetwork(UUID uuid) {
        OMLibNetwork network = null;
        for (OMLibNetwork net : this.networks) {
            if (!net.getUuid().equals(uuid)) continue;
            network = net;
            break;
        }
        return network;
    }
}

