/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.tile;

import de.ellpeck.actuallyadditions.mod.tile.CustomEnergyStorage;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityBase;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityInventoryBase;
import de.ellpeck.actuallyadditions.mod.util.ItemStackHandlerAA;
import de.ellpeck.actuallyadditions.mod.util.StackUtil;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;

public class TileEntityEnergizer
extends TileEntityInventoryBase {
    public final CustomEnergyStorage storage = new CustomEnergyStorage(50000, 1000, 0);
    private int lastEnergy;

    public TileEntityEnergizer() {
        super(2, "energizer");
    }

    @Override
    public void writeSyncableNBT(NBTTagCompound compound, TileEntityBase.NBTType type) {
        this.storage.writeToNBT(compound);
        super.writeSyncableNBT(compound, type);
    }

    @Override
    public void readSyncableNBT(NBTTagCompound compound, TileEntityBase.NBTType type) {
        this.storage.readFromNBT(compound);
        super.readSyncableNBT(compound, type);
    }

    @Override
    public void updateEntity() {
        super.updateEntity();
        if (!this.field_145850_b.field_72995_K) {
            if (StackUtil.isValid(this.inv.getStackInSlot(0)) && !StackUtil.isValid(this.inv.getStackInSlot(1)) && this.storage.getEnergyStored() > 0) {
                IEnergyStorage cap;
                int received = 0;
                boolean canTakeUp = false;
                if (this.inv.getStackInSlot(0).hasCapability(CapabilityEnergy.ENERGY, null) && (cap = (IEnergyStorage)this.inv.getStackInSlot(0).getCapability(CapabilityEnergy.ENERGY, null)) != null) {
                    received = cap.receiveEnergy(this.storage.getEnergyStored(), false);
                    boolean bl = canTakeUp = cap.getEnergyStored() >= cap.getMaxEnergyStored();
                }
                if (received > 0) {
                    this.storage.extractEnergyInternal(received, false);
                }
                if (canTakeUp) {
                    this.inv.setStackInSlot(1, this.inv.getStackInSlot(0).func_77946_l());
                    this.inv.setStackInSlot(0, StackUtil.shrink(this.inv.getStackInSlot(0), 1));
                }
            }
            if (this.lastEnergy != this.storage.getEnergyStored() && this.sendUpdateWithInterval()) {
                this.lastEnergy = this.storage.getEnergyStored();
            }
        }
    }

    @Override
    public ItemStackHandlerAA.IAcceptor getAcceptor() {
        return (slot, stack, automation) -> !automation || slot == 0 && stack.hasCapability(CapabilityEnergy.ENERGY, null);
    }

    @Override
    public ItemStackHandlerAA.IRemover getRemover() {
        return (slot, automation) -> !EnchantmentHelper.func_190938_b((ItemStack)this.inv.getStackInSlot(slot)) && !automation || slot == 1;
    }

    public int getEnergyScaled(int i) {
        return this.storage.getEnergyStored() * i / this.storage.getMaxEnergyStored();
    }

    @Override
    public IEnergyStorage getEnergyStorage(EnumFacing facing) {
        return this.storage;
    }
}

