/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.tile;

import de.ellpeck.actuallyadditions.api.laser.IConnectionPair;
import de.ellpeck.actuallyadditions.api.laser.LaserType;
import de.ellpeck.actuallyadditions.api.laser.Network;
import de.ellpeck.actuallyadditions.mod.ActuallyAdditions;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityBase;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityItemViewer;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityLaserRelay;
import de.ellpeck.actuallyadditions.mod.util.StringUtil;
import de.ellpeck.actuallyadditions.mod.util.WorldUtil;
import de.ellpeck.actuallyadditions.mod.util.compat.SlotlessableItemHandlerWrapper;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import org.cyclops.commoncapabilities.capability.itemhandler.SlotlessItemHandlerConfig;

public class TileEntityLaserRelayItem
extends TileEntityLaserRelay {
    public final Map<BlockPos, SlotlessableItemHandlerWrapper> handlersAround = new ConcurrentHashMap<BlockPos, SlotlessableItemHandlerWrapper>();
    public int priority;

    public TileEntityLaserRelayItem(String name) {
        super(name, LaserType.ITEM);
    }

    public TileEntityLaserRelayItem() {
        this("laserRelayItem");
    }

    public int getPriority() {
        return this.priority;
    }

    public boolean isWhitelisted(ItemStack stack, boolean output) {
        return true;
    }

    @Override
    public boolean shouldSaveDataOnChangeOrWorldStart() {
        return true;
    }

    @Override
    public void saveDataOnChangeOrWorldStart() {
        Network network;
        HashMap<BlockPos, SlotlessableItemHandlerWrapper> old = new HashMap<BlockPos, SlotlessableItemHandlerWrapper>(this.handlersAround);
        boolean change = false;
        this.handlersAround.clear();
        for (int i = 0; i <= 5; ++i) {
            TileEntity tile;
            EnumFacing side = WorldUtil.getDirectionBySidesInOrder(i);
            BlockPos pos = this.func_174877_v().func_177972_a(side);
            if (!this.field_145850_b.func_175667_e(pos) || (tile = this.field_145850_b.func_175625_s(pos)) == null || tile instanceof TileEntityItemViewer || tile instanceof TileEntityLaserRelay) continue;
            IItemHandler itemHandler = null;
            if (tile.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, side.func_176734_d())) {
                itemHandler = (IItemHandler)tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, side.func_176734_d());
            }
            Object slotlessHandler = null;
            if (ActuallyAdditions.commonCapsLoaded && tile.hasCapability(SlotlessItemHandlerConfig.CAPABILITY, side.func_176734_d())) {
                slotlessHandler = tile.getCapability(SlotlessItemHandlerConfig.CAPABILITY, side.func_176734_d());
            }
            if (itemHandler == null && slotlessHandler == null) continue;
            SlotlessableItemHandlerWrapper handler = new SlotlessableItemHandlerWrapper(itemHandler, slotlessHandler);
            this.handlersAround.put(pos, handler);
            SlotlessableItemHandlerWrapper oldHandler = (SlotlessableItemHandlerWrapper)old.get(pos);
            if (oldHandler != null && handler.equals(oldHandler)) continue;
            change = true;
        }
        if ((change || old.size() != this.handlersAround.size()) && (network = this.getNetwork()) != null) {
            ++network.changeAmount;
        }
    }

    public void getItemHandlersInNetwork(Network network, List<TileEntityItemViewer.GenericItemHandlerInfo> storeList) {
        HashSet<BlockPos> alreadyChecked = new HashSet<BlockPos>();
        for (IConnectionPair pair : network.connections) {
            for (BlockPos relay : pair.getPositions()) {
                if (relay == null || !this.field_145850_b.func_175667_e(relay) || alreadyChecked.contains(relay)) continue;
                alreadyChecked.add(relay);
                TileEntity aRelayTile = this.field_145850_b.func_175625_s(relay);
                if (!(aRelayTile instanceof TileEntityLaserRelayItem)) continue;
                TileEntityLaserRelayItem relayTile = (TileEntityLaserRelayItem)aRelayTile;
                TileEntityItemViewer.GenericItemHandlerInfo info = new TileEntityItemViewer.GenericItemHandlerInfo(relayTile);
                for (Map.Entry<BlockPos, SlotlessableItemHandlerWrapper> handler : relayTile.handlersAround.entrySet()) {
                    if (alreadyChecked.contains(handler.getKey())) continue;
                    alreadyChecked.add(handler.getKey());
                    info.handlers.add(handler.getValue());
                }
                storeList.add(info);
            }
        }
    }

    @Override
    public void writeSyncableNBT(NBTTagCompound compound, TileEntityBase.NBTType type) {
        super.writeSyncableNBT(compound, type);
        if (type != TileEntityBase.NBTType.SAVE_BLOCK) {
            compound.func_74768_a("Priority", this.priority);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public String getExtraDisplayString() {
        return StringUtil.localize("info.actuallyadditions.laserRelay.item.extra") + ": " + TextFormatting.DARK_RED + this.getPriority() + TextFormatting.RESET;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public String getCompassDisplayString() {
        return TextFormatting.GREEN + StringUtil.localize("info.actuallyadditions.laserRelay.item.display.1") + "\n" + StringUtil.localize("info.actuallyadditions.laserRelay.item.display.2");
    }

    @Override
    public void onCompassAction(EntityPlayer player) {
        this.priority = player.func_70093_af() ? --this.priority : ++this.priority;
    }

    @Override
    public void readSyncableNBT(NBTTagCompound compound, TileEntityBase.NBTType type) {
        super.readSyncableNBT(compound, type);
        if (type != TileEntityBase.NBTType.SAVE_BLOCK) {
            this.priority = compound.func_74762_e("Priority");
        }
    }
}

