/*
 * Decompiled with CFR 0.152.
 */
package cubex2.cs4.plugins.vanilla;

import com.google.common.primitives.Floats;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import cubex2.cs4.api.Length;
import java.lang.reflect.Type;

class LengthDeserializer
implements JsonDeserializer<Length> {
    LengthDeserializer() {
    }

    public Length deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        if (json.isJsonArray()) {
            JsonArray array = json.getAsJsonArray();
            Length left = this.deserializeSingleElement(array.get(0));
            Length right = this.deserializeSingleElement(array.get(1));
            return LengthDeserializer.sum(left, right);
        }
        return this.deserializeSingleElement(json);
    }

    private Length deserializeSingleElement(JsonElement json) {
        if (json.isJsonPrimitive()) {
            JsonPrimitive primitive = json.getAsJsonPrimitive();
            if (primitive.isString()) {
                Float percentValue;
                String value = primitive.getAsString();
                if (value.endsWith("%") && (percentValue = Floats.tryParse((String)(value = value.substring(0, value.length() - 1)))) != null) {
                    return LengthDeserializer.relative(percentValue.floatValue() / 100.0f);
                }
            } else {
                return LengthDeserializer.absolute(json.getAsInt());
            }
        }
        return Length.ZERO;
    }

    private static Length sum(Length left, Length right) {
        return parent -> left.getLength(parent) + right.getLength(parent);
    }

    private static Length relative(float relValue) {
        return parent -> (int)(relValue * (float)parent);
    }

    private static Length absolute(int value) {
        return parent -> value;
    }
}

