/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.content.blast;

import icbm.classic.content.blast.Blast;
import icbm.classic.lib.transform.region.Cube;
import icbm.classic.lib.transform.vector.Pos;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.Explosion;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.ExplosionEvent;
import net.minecraftforge.fml.common.eventhandler.Event;

public class BlastTNT
extends Blast {
    private PushType pushType = PushType.NO_PUSH;
    private boolean destroyItem = false;
    public float damageToEntities = 10.0f;
    public int raysPerAxis = 16;

    public BlastTNT setPushType(PushType type) {
        this.pushType = type;
        return this;
    }

    public BlastTNT setDestroyItems() {
        this.destroyItem = true;
        return this;
    }

    @Override
    public boolean doExplode(int callCount) {
        this.calculateDamage();
        this.world().func_184148_a(null, this.location.x(), this.location.y(), this.location.z(), SoundEvents.field_187539_bB, SoundCategory.BLOCKS, 4.0f, (1.0f + (this.world().field_73012_v.nextFloat() - this.world().field_73012_v.nextFloat()) * 0.2f) * 0.7f);
        switch (this.pushType) {
            case NO_PUSH: {
                this.doDamageEntities(this.getBlastRadius(), this.damageToEntities, this.destroyItem);
                break;
            }
            default: {
                this.pushEntities(12.0f, this.getBlastRadius() * 4.0f, this.pushType);
            }
        }
        MinecraftForge.EVENT_BUS.post((Event)new ExplosionEvent.Detonate(this.field_77287_j, (Explosion)this, new ArrayList()));
        this.doDestroyBlocks();
        return true;
    }

    protected void calculateDamage() {
        if (!this.world().field_72995_K) {
            for (int xs = 0; xs < this.raysPerAxis; ++xs) {
                for (int ys = 0; ys < this.raysPerAxis; ++ys) {
                    for (int zs = 0; zs < this.raysPerAxis; ++zs) {
                        if (xs != 0 && xs != this.raysPerAxis - 1 && ys != 0 && ys != this.raysPerAxis - 1 && zs != 0 && zs != this.raysPerAxis - 1) continue;
                        double xStep = (float)xs / ((float)this.raysPerAxis - 1.0f) * 2.0f - 1.0f;
                        double yStep = (float)ys / ((float)this.raysPerAxis - 1.0f) * 2.0f - 1.0f;
                        double zStep = (float)zs / ((float)this.raysPerAxis - 1.0f) * 2.0f - 1.0f;
                        double diagonalDistance = Math.sqrt(xStep * xStep + yStep * yStep + zStep * zStep);
                        xStep /= diagonalDistance;
                        yStep /= diagonalDistance;
                        zStep /= diagonalDistance;
                        double x = this.location.x();
                        double y = this.location.y();
                        double z = this.location.z();
                        float step = 0.3f;
                        for (float radialEnergy = this.getBlastRadius() * (0.7f + this.world().field_73012_v.nextFloat() * 0.6f); radialEnergy > 0.0f; radialEnergy -= step * 0.75f) {
                            int xi = MathHelper.func_76128_c((double)x);
                            int yi = MathHelper.func_76128_c((double)y);
                            int zi = MathHelper.func_76128_c((double)z);
                            BlockPos blockPos = new BlockPos(xi, yi, zi);
                            IBlockState blockState = this.field_77287_j.func_180495_p(blockPos);
                            Block block = blockState.func_177230_c();
                            if (blockState.func_185904_a() != Material.field_151579_a && (radialEnergy -= (block.getExplosionResistance(this.world(), blockPos, this.field_77283_e, (Explosion)this) + 0.3f) * step) > 0.0f && !this.func_180343_e().contains(blockPos)) {
                                this.func_180343_e().add(blockPos);
                            }
                            x += xStep * (double)step;
                            y += yStep * (double)step;
                            z += zStep * (double)step;
                        }
                    }
                }
            }
        }
    }

    protected void doDestroyBlocks() {
        if (!this.world().field_72995_K) {
            for (BlockPos blownPosition : this.func_180343_e()) {
                int xi = blownPosition.func_177958_n();
                int yi = blownPosition.func_177956_o();
                int zi = blownPosition.func_177952_p();
                IBlockState blockState = this.field_77287_j.func_180495_p(blownPosition);
                Block block = blockState.func_177230_c();
                double var9 = (float)xi + this.world().field_73012_v.nextFloat();
                double var11 = (float)yi + this.world().field_73012_v.nextFloat();
                double var13 = (float)zi + this.world().field_73012_v.nextFloat();
                double var151 = var9 - this.location.y();
                double var171 = var11 - this.location.y();
                double var191 = var13 - this.location.z();
                double var211 = MathHelper.func_76133_a((double)(var151 * var151 + var171 * var171 + var191 * var191));
                var151 /= var211;
                var171 /= var211;
                var191 /= var211;
                double var23 = 0.5 / (var211 / (double)this.getBlastRadius() + 0.1);
                this.world().func_175688_a(EnumParticleTypes.EXPLOSION_NORMAL, (var9 + this.location.x() * 1.0) / 2.0, (var11 + this.location.y() * 1.0) / 2.0, (var13 + this.location.z() * 1.0) / 2.0, var151 *= (var23 *= (double)(this.world().field_73012_v.nextFloat() * this.world().field_73012_v.nextFloat() + 0.3f)), var171 *= var23, var191 *= var23, new int[0]);
                this.world().func_175688_a(EnumParticleTypes.SMOKE_NORMAL, var9, var11, var13, var151, var171, var191, new int[0]);
                if (blockState.func_185904_a() == Material.field_151579_a) continue;
                try {
                    if (block.func_149659_a((Explosion)this)) {
                        block.func_180653_a(this.world(), blownPosition, blockState, 1.0f, 0);
                    }
                    block.onBlockExploded(this.world(), blownPosition, (Explosion)this);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public void pushEntities(float radius, float force, PushType type) {
        Pos minCoord = this.location.toPos();
        minCoord = (Pos)minCoord.add(-radius - 1.0f);
        Pos maxCoord = this.location.toPos();
        maxCoord = (Pos)maxCoord.add(radius + 1.0f);
        Cube region = new Cube(minCoord, maxCoord);
        List entities = this.field_77287_j.func_72872_a(Entity.class, region.getAABB());
        for (Entity entity : entities) {
            double modifier;
            double var13 = entity.func_70011_f(this.location.x(), this.location.y(), this.location.z()) / (double)radius;
            if (!(var13 <= 1.0)) continue;
            double xDifference = entity.field_70165_t - this.location.x();
            double yDifference = entity.field_70163_u - this.location.y();
            double zDifference = entity.field_70161_v - this.location.z();
            double mag = MathHelper.func_76133_a((double)(xDifference * xDifference + yDifference * yDifference + zDifference * zDifference));
            xDifference /= mag;
            yDifference /= mag;
            zDifference /= mag;
            if (type == PushType.ATTRACT) {
                modifier = var13 * (double)force * (entity instanceof EntityPlayer ? 0.5 : 1.0);
                entity.func_70024_g(-xDifference * modifier, -yDifference * modifier, -zDifference * modifier);
                continue;
            }
            if (type != PushType.REPEL) continue;
            modifier = (1.0 - var13) * (double)force * (entity instanceof EntityPlayer ? 0.5 : 1.0);
            entity.func_70024_g(xDifference * modifier, yDifference * modifier, zDifference * modifier);
        }
    }

    @Override
    public void load(NBTTagCompound nbt) {
        super.load(nbt);
        this.pushType = PushType.values()[nbt.func_74762_e("pushType")];
        this.destroyItem = nbt.func_74767_n("destroyItem");
    }

    @Override
    public void save(NBTTagCompound nbt) {
        super.save(nbt);
        nbt.func_74768_a("pushType", this.pushType.ordinal());
        nbt.func_74757_a("destroyItem", this.destroyItem);
    }

    public static enum PushType {
        NO_PUSH,
        ATTRACT,
        REPEL;

    }
}

