/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.lib.adventure.nbt;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.Consumer;
import me.lucko.luckperms.lib.adventure.nbt.BinaryTag;
import me.lucko.luckperms.lib.adventure.nbt.BinaryTagType;
import me.lucko.luckperms.lib.adventure.nbt.BinaryTagTypes;
import me.lucko.luckperms.lib.adventure.nbt.ListBinaryTag;
import org.checkerframework.checker.index.qual.NonNegative;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

final class ListBinaryTagImpl
implements ListBinaryTag {
    static final ListBinaryTag EMPTY = new ListBinaryTagImpl(BinaryTagTypes.END, Collections.emptyList());
    private final List<? extends BinaryTag> tags;
    private final BinaryTagType<? extends BinaryTag> type;
    private final int hashCode;

    ListBinaryTagImpl(BinaryTagType<? extends BinaryTag> type, List<? extends BinaryTag> tags) {
        this.tags = tags;
        this.type = type;
        this.hashCode = tags.hashCode();
    }

    @Override
    public @NonNull BinaryTagType<? extends BinaryTag> listType() {
        return this.type;
    }

    @Override
    public int size() {
        return this.tags.size();
    }

    @Override
    public @NonNull BinaryTag get(@NonNegative int index) {
        return this.tags.get(index);
    }

    @Override
    public @NonNull ListBinaryTag set(int index, @NonNull BinaryTag newTag, @Nullable Consumer<BinaryTag> removedConsumer) {
        return this.edit(tags -> {
            BinaryTag oldTag = tags.set(index, newTag);
            if (removedConsumer != null) {
                removedConsumer.accept(oldTag);
            }
        }, newTag.type());
    }

    @Override
    public @NonNull ListBinaryTag remove(int index, @Nullable Consumer<BinaryTag> removedConsumer) {
        return this.edit(tags -> {
            BinaryTag tag = (BinaryTag)tags.remove(index);
            if (removedConsumer != null) {
                removedConsumer.accept(tag);
            }
        }, null);
    }

    @Override
    public @NonNull ListBinaryTag add(BinaryTag tag) {
        return this.edit(tags -> {
            ListBinaryTagImpl.noAddEnd(tag);
            if (this.type != BinaryTagTypes.END) {
                ListBinaryTagImpl.mustBeSameType(tag, this.type);
            }
            tags.add(tag);
        }, tag.type());
    }

    static void noAddEnd(BinaryTag tag) {
        if (tag.type() == BinaryTagTypes.END) {
            throw new IllegalArgumentException(String.format("Cannot add a %s to a %s", BinaryTagTypes.END, BinaryTagTypes.LIST));
        }
    }

    static void mustBeSameType(BinaryTag tag, BinaryTagType<? extends BinaryTag> type) {
        if (tag.type() != type) {
            throw new IllegalArgumentException(String.format("Trying to add tag of type %s to list of %s", tag.type(), type));
        }
    }

    private ListBinaryTag edit(Consumer<List<BinaryTag>> consumer, @Nullable BinaryTagType<? extends BinaryTag> maybeType) {
        ArrayList<? extends BinaryTag> tags = new ArrayList<BinaryTag>(this.tags);
        consumer.accept(tags);
        BinaryTagType<? extends BinaryTag> type = this.type;
        if (maybeType != null && type == BinaryTagTypes.END) {
            type = maybeType;
        }
        return new ListBinaryTagImpl(type, tags);
    }

    @Override
    public Iterator<BinaryTag> iterator() {
        final Iterator<? extends BinaryTag> iterator = this.tags.iterator();
        return new Iterator<BinaryTag>(){

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public BinaryTag next() {
                return (BinaryTag)iterator.next();
            }

            @Override
            public void forEachRemaining(Consumer<? super BinaryTag> action) {
                iterator.forEachRemaining(action);
            }
        };
    }

    @Override
    public void forEach(Consumer<? super BinaryTag> action) {
        this.tags.forEach(action);
    }

    @Override
    public Spliterator<BinaryTag> spliterator() {
        return Spliterators.spliterator(this.tags, 1040);
    }

    public boolean equals(Object that) {
        return this == that || that instanceof ListBinaryTagImpl && this.tags.equals(((ListBinaryTagImpl)that).tags);
    }

    public int hashCode() {
        return this.hashCode;
    }

    public @NonNull String toString() {
        return "ListBinaryTagImpl{tags=" + this.tags + ", type=" + this.type + '}';
    }
}

