/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.commands.generic.meta;

import com.google.common.collect.Maps;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.TreeSet;
import me.lucko.luckperms.common.command.CommandResult;
import me.lucko.luckperms.common.command.abstraction.GenericChildCommand;
import me.lucko.luckperms.common.command.access.ArgumentPermissions;
import me.lucko.luckperms.common.command.access.CommandPermission;
import me.lucko.luckperms.common.command.spec.CommandSpec;
import me.lucko.luckperms.common.command.utils.ArgumentList;
import me.lucko.luckperms.common.locale.Message;
import me.lucko.luckperms.common.model.PermissionHolder;
import me.lucko.luckperms.common.node.comparator.NodeWithContextComparator;
import me.lucko.luckperms.common.plugin.LuckPermsPlugin;
import me.lucko.luckperms.common.query.QueryOptionsImpl;
import me.lucko.luckperms.common.sender.Sender;
import me.lucko.luckperms.common.util.Predicates;
import net.luckperms.api.node.Node;
import net.luckperms.api.node.NodeType;
import net.luckperms.api.node.types.ChatMetaNode;
import net.luckperms.api.node.types.MetaNode;
import net.luckperms.api.node.types.PrefixNode;
import net.luckperms.api.node.types.SuffixNode;

public class MetaInfo
extends GenericChildCommand {
    public MetaInfo() {
        super(CommandSpec.META_INFO, "info", CommandPermission.USER_META_INFO, CommandPermission.GROUP_META_INFO, Predicates.alwaysFalse());
    }

    @Override
    public CommandResult execute(LuckPermsPlugin plugin, Sender sender, PermissionHolder target, ArgumentList args, String label, CommandPermission permission) {
        if (ArgumentPermissions.checkViewPerms(plugin, sender, permission, target)) {
            Message.COMMAND_NO_PERMISSION.send(sender);
            return CommandResult.NO_PERMISSION;
        }
        TreeSet prefixes = new TreeSet(MetaComparator.INSTANCE.reversed());
        TreeSet suffixes = new TreeSet(MetaComparator.INSTANCE.reversed());
        LinkedHashSet<MetaNode> meta = new LinkedHashSet<MetaNode>();
        for (Node node : target.resolveInheritedNodes(NodeType.META_OR_CHAT_META, QueryOptionsImpl.DEFAULT_NON_CONTEXTUAL)) {
            if (node instanceof PrefixNode) {
                PrefixNode pn = (PrefixNode)node;
                prefixes.add(Maps.immutableEntry((Object)pn.getPriority(), (Object)pn));
                continue;
            }
            if (node instanceof SuffixNode) {
                SuffixNode sn = (SuffixNode)node;
                suffixes.add(Maps.immutableEntry((Object)sn.getPriority(), (Object)sn));
                continue;
            }
            if (!(node instanceof MetaNode)) continue;
            meta.add((MetaNode)node);
        }
        if (prefixes.isEmpty()) {
            Message.CHAT_META_PREFIX_NONE.send(sender, target);
        } else {
            Message.CHAT_META_PREFIX_HEADER.send(sender, target);
            for (Map.Entry entry : prefixes) {
                Message.CHAT_META_ENTRY.send(sender, (ChatMetaNode)entry.getValue(), target, label);
            }
        }
        if (suffixes.isEmpty()) {
            Message.CHAT_META_SUFFIX_NONE.send(sender, target);
        } else {
            Message.CHAT_META_SUFFIX_HEADER.send(sender, target);
            for (Map.Entry entry : suffixes) {
                Message.CHAT_META_ENTRY.send(sender, (ChatMetaNode)entry.getValue(), target, label);
            }
        }
        if (meta.isEmpty()) {
            Message.META_NONE.send(sender, target);
        } else {
            Message.META_HEADER.send(sender, target);
            for (MetaNode metaNode : meta) {
                Message.META_ENTRY.send(sender, metaNode, target, label);
            }
        }
        return CommandResult.SUCCESS;
    }

    private static final class MetaComparator
    implements Comparator<Map.Entry<Integer, ? extends ChatMetaNode<?, ?>>> {
        public static final MetaComparator INSTANCE = new MetaComparator();

        private MetaComparator() {
        }

        @Override
        public int compare(Map.Entry<Integer, ? extends ChatMetaNode<?, ?>> o1, Map.Entry<Integer, ? extends ChatMetaNode<?, ?>> o2) {
            int result = Integer.compare(o1.getKey(), o2.getKey());
            if (result != 0) {
                return result;
            }
            return NodeWithContextComparator.normal().compare(o1.getValue(), o2.getValue());
        }
    }
}

