/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.messaging;

import me.lucko.luckperms.common.config.ConfigKeys;
import me.lucko.luckperms.common.config.LuckPermsConfiguration;
import me.lucko.luckperms.common.messaging.InternalMessagingService;
import me.lucko.luckperms.common.messaging.LuckPermsMessagingService;
import me.lucko.luckperms.common.messaging.rabbitmq.RabbitMQMessenger;
import me.lucko.luckperms.common.messaging.redis.RedisMessenger;
import me.lucko.luckperms.common.messaging.sql.SqlMessenger;
import me.lucko.luckperms.common.plugin.LuckPermsPlugin;
import me.lucko.luckperms.common.storage.implementation.StorageImplementation;
import me.lucko.luckperms.common.storage.implementation.sql.SqlStorage;
import me.lucko.luckperms.common.storage.implementation.sql.connection.hikari.MariaDbConnectionFactory;
import me.lucko.luckperms.common.storage.implementation.sql.connection.hikari.MySqlConnectionFactory;
import net.luckperms.api.messenger.IncomingMessageConsumer;
import net.luckperms.api.messenger.Messenger;
import net.luckperms.api.messenger.MessengerProvider;
import org.checkerframework.checker.nullness.qual.NonNull;

public class MessagingFactory<P extends LuckPermsPlugin> {
    private final P plugin;

    public MessagingFactory(P plugin) {
        this.plugin = plugin;
    }

    protected P getPlugin() {
        return this.plugin;
    }

    public final InternalMessagingService getInstance() {
        String messagingType = this.plugin.getConfiguration().get(ConfigKeys.MESSAGING_SERVICE);
        if (messagingType.equals("none")) {
            messagingType = "auto";
        }
        if (messagingType.equals("auto")) {
            if (this.plugin.getConfiguration().get(ConfigKeys.REDIS_ENABLED).booleanValue()) {
                messagingType = "redis";
            } else if (this.plugin.getConfiguration().get(ConfigKeys.RABBITMQ_ENABLED).booleanValue()) {
                messagingType = "rabbitmq";
            } else {
                for (StorageImplementation implementation : this.plugin.getStorage().getImplementations()) {
                    SqlStorage sql;
                    if (!(implementation instanceof SqlStorage) || !((sql = (SqlStorage)implementation).getConnectionFactory() instanceof MySqlConnectionFactory) && !(sql.getConnectionFactory() instanceof MariaDbConnectionFactory)) continue;
                    messagingType = "sql";
                    break;
                }
            }
        }
        if (messagingType.equals("auto") || messagingType.equals("notsql")) {
            return null;
        }
        this.plugin.getLogger().info("Loading messaging service... [" + messagingType.toUpperCase() + "]");
        InternalMessagingService service = this.getServiceFor(messagingType);
        if (service != null) {
            return service;
        }
        this.plugin.getLogger().warn("Messaging service '" + messagingType + "' not recognised.");
        return null;
    }

    protected InternalMessagingService getServiceFor(String messagingType) {
        if (messagingType.equals("redis")) {
            if (this.plugin.getConfiguration().get(ConfigKeys.REDIS_ENABLED).booleanValue()) {
                try {
                    return new LuckPermsMessagingService((LuckPermsPlugin)this.plugin, new RedisMessengerProvider());
                }
                catch (Exception e) {
                    this.getPlugin().getLogger().severe("Exception occurred whilst enabling Redis messaging service", e);
                }
            } else {
                this.plugin.getLogger().warn("Messaging Service was set to redis, but redis is not enabled!");
            }
        } else if (messagingType.equals("rabbitmq")) {
            if (this.plugin.getConfiguration().get(ConfigKeys.RABBITMQ_ENABLED).booleanValue()) {
                try {
                    return new LuckPermsMessagingService((LuckPermsPlugin)this.plugin, new RabbitMQMessengerProvider());
                }
                catch (Exception e) {
                    this.getPlugin().getLogger().severe("Exception occurred whilst enabling RabbitMQ messaging service", e);
                }
            } else {
                this.plugin.getLogger().warn("Messaging Service was set to rabbitmq, but rabbitmq is not enabled!");
            }
        } else if (messagingType.equals("sql")) {
            try {
                return new LuckPermsMessagingService((LuckPermsPlugin)this.plugin, new SqlMessengerProvider());
            }
            catch (Exception e) {
                this.getPlugin().getLogger().severe("Exception occurred whilst enabling SQL messaging service", e);
            }
        }
        return null;
    }

    private class SqlMessengerProvider
    implements MessengerProvider {
        private SqlMessengerProvider() {
        }

        @Override
        public @NonNull String getName() {
            return "Sql";
        }

        @Override
        public @NonNull Messenger obtain(@NonNull IncomingMessageConsumer incomingMessageConsumer) {
            for (StorageImplementation implementation : MessagingFactory.this.getPlugin().getStorage().getImplementations()) {
                SqlStorage storage;
                if (!(implementation instanceof SqlStorage) || !((storage = (SqlStorage)implementation).getConnectionFactory() instanceof MySqlConnectionFactory) && !(storage.getConnectionFactory() instanceof MariaDbConnectionFactory)) continue;
                SqlMessenger sql = new SqlMessenger((LuckPermsPlugin)MessagingFactory.this.getPlugin(), storage, incomingMessageConsumer);
                sql.init();
                return sql;
            }
            throw new IllegalStateException("Can't find a supported sql storage implementation");
        }
    }

    private class RabbitMQMessengerProvider
    implements MessengerProvider {
        private RabbitMQMessengerProvider() {
        }

        @Override
        public @NonNull String getName() {
            return "RabbitMQ";
        }

        @Override
        public @NonNull Messenger obtain(@NonNull IncomingMessageConsumer incomingMessageConsumer) {
            RabbitMQMessenger rabbitmq = new RabbitMQMessenger((LuckPermsPlugin)MessagingFactory.this.getPlugin(), incomingMessageConsumer);
            LuckPermsConfiguration config = MessagingFactory.this.getPlugin().getConfiguration();
            String address = config.get(ConfigKeys.RABBITMQ_ADDRESS);
            String virtualHost = config.get(ConfigKeys.RABBITMQ_VIRTUAL_HOST);
            String username = config.get(ConfigKeys.RABBITMQ_USERNAME);
            String password = config.get(ConfigKeys.RABBITMQ_PASSWORD);
            rabbitmq.init(address, virtualHost, username, password);
            return rabbitmq;
        }
    }

    private class RedisMessengerProvider
    implements MessengerProvider {
        private RedisMessengerProvider() {
        }

        @Override
        public @NonNull String getName() {
            return "Redis";
        }

        @Override
        public @NonNull Messenger obtain(@NonNull IncomingMessageConsumer incomingMessageConsumer) {
            RedisMessenger redis = new RedisMessenger((LuckPermsPlugin)MessagingFactory.this.getPlugin(), incomingMessageConsumer);
            LuckPermsConfiguration config = MessagingFactory.this.getPlugin().getConfiguration();
            String address = config.get(ConfigKeys.REDIS_ADDRESS);
            String password = config.get(ConfigKeys.REDIS_PASSWORD);
            if (password.isEmpty()) {
                password = null;
            }
            boolean ssl = config.get(ConfigKeys.REDIS_SSL);
            redis.init(address, password, ssl);
            return redis;
        }
    }
}

