/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.messaging.message;

import com.google.gson.JsonElement;
import java.util.UUID;
import me.lucko.luckperms.common.actionlog.ActionJsonSerializer;
import me.lucko.luckperms.common.messaging.LuckPermsMessagingService;
import me.lucko.luckperms.common.messaging.message.AbstractMessage;
import net.luckperms.api.actionlog.Action;
import net.luckperms.api.messenger.message.type.ActionLogMessage;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class ActionLogMessageImpl
extends AbstractMessage
implements ActionLogMessage {
    public static final String TYPE = "log";
    private final Action logEntry;

    public static ActionLogMessageImpl decode(@Nullable JsonElement content, UUID id) {
        if (content == null) {
            throw new IllegalStateException("Missing content");
        }
        return new ActionLogMessageImpl(id, ActionJsonSerializer.deserialize(content));
    }

    public ActionLogMessageImpl(UUID id, Action logEntry) {
        super(id);
        this.logEntry = logEntry;
    }

    @Override
    public @NonNull Action getAction() {
        return this.logEntry;
    }

    @Override
    public @NonNull String asEncodedString() {
        return LuckPermsMessagingService.encodeMessageAsString(TYPE, this.getId(), (JsonElement)ActionJsonSerializer.serialize(this.logEntry));
    }
}

