/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.node.factory;

import me.lucko.luckperms.common.node.types.DisplayName;
import me.lucko.luckperms.common.node.types.Inheritance;
import me.lucko.luckperms.common.node.types.Meta;
import me.lucko.luckperms.common.node.types.Permission;
import me.lucko.luckperms.common.node.types.Prefix;
import me.lucko.luckperms.common.node.types.RegexPermission;
import me.lucko.luckperms.common.node.types.Suffix;
import me.lucko.luckperms.common.node.types.Weight;
import net.luckperms.api.node.NodeBuilder;
import net.luckperms.api.node.types.DisplayNameNode;
import net.luckperms.api.node.types.InheritanceNode;
import net.luckperms.api.node.types.MetaNode;
import net.luckperms.api.node.types.PrefixNode;
import net.luckperms.api.node.types.RegexPermissionNode;
import net.luckperms.api.node.types.SuffixNode;
import net.luckperms.api.node.types.WeightNode;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class NodeBuilders {
    private static final Parser<InheritanceNode.Builder> INHERITANCE = Inheritance::parse;
    private static final Parser<PrefixNode.Builder> PREFIX = Prefix::parse;
    private static final Parser<SuffixNode.Builder> SUFFIX = Suffix::parse;
    private static final Parser<MetaNode.Builder> META = Meta::parse;
    private static final Parser<WeightNode.Builder> WEIGHT = Weight::parse;
    private static final Parser<DisplayNameNode.Builder> DISPLAY_NAME = DisplayName::parse;
    private static final Parser<RegexPermissionNode.Builder> REGEX_PERMISSION = RegexPermission::parse;
    private static final Parser<?>[] PARSERS = new Parser[]{INHERITANCE, PREFIX, SUFFIX, META, WEIGHT, DISPLAY_NAME, REGEX_PERMISSION};

    private NodeBuilders() {
    }

    public static @NonNull NodeBuilder<?, ?> determineMostApplicable(String key) {
        for (Parser<?> parser : PARSERS) {
            Object builder = parser.parse(key);
            if (builder == null) continue;
            return builder;
        }
        return Permission.builder().permission(key);
    }

    private static interface Parser<B extends NodeBuilder<?, B>> {
        public @Nullable B parse(String var1);
    }
}

