/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.sponge.service.model.calculated;

import com.google.common.collect.ImmutableList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import me.lucko.luckperms.common.cacheddata.type.MetaAccumulator;
import me.lucko.luckperms.common.graph.TraversalAlgorithm;
import me.lucko.luckperms.common.query.QueryOptionsImpl;
import me.lucko.luckperms.common.verbose.event.MetaCheckEvent;
import me.lucko.luckperms.common.verbose.event.PermissionCheckEvent;
import me.lucko.luckperms.sponge.LPSpongePlugin;
import me.lucko.luckperms.sponge.service.inheritance.SubjectInheritanceGraph;
import me.lucko.luckperms.sponge.service.model.LPSubject;
import me.lucko.luckperms.sponge.service.model.LPSubjectReference;
import me.lucko.luckperms.sponge.service.model.calculated.CalculatedSubjectCachedDataManager;
import me.lucko.luckperms.sponge.service.model.calculated.CalculatedSubjectData;
import net.luckperms.api.context.ImmutableContextSet;
import net.luckperms.api.query.QueryOptions;
import net.luckperms.api.util.Tristate;

public abstract class CalculatedSubject
implements LPSubject {
    private final LPSpongePlugin plugin;
    private final CalculatedSubjectCachedDataManager cachedData;

    protected CalculatedSubject(LPSpongePlugin plugin) {
        this.plugin = plugin;
        this.cachedData = new CalculatedSubjectCachedDataManager(this, plugin);
    }

    @Override
    public LPSubject getDefaults() {
        return this.plugin.getService().getDefaultSubjects().getTypeDefaults(this.getParentCollection().getIdentifier());
    }

    @Override
    public abstract CalculatedSubjectData getSubjectData();

    @Override
    public abstract CalculatedSubjectData getTransientSubjectData();

    public Map<String, Boolean> getCombinedPermissions(QueryOptions filter) {
        Map<String, Boolean> merging;
        Map<String, Boolean> permissions;
        switch (this.getParentCollection().getResolutionOrder()) {
            case TRANSIENT_FIRST: {
                permissions = this.getTransientSubjectData().resolvePermissions(filter);
                merging = this.getSubjectData().resolvePermissions(filter);
                break;
            }
            case TRANSIENT_LAST: {
                permissions = this.getSubjectData().resolvePermissions(filter);
                merging = this.getTransientSubjectData().resolvePermissions(filter);
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        for (Map.Entry<String, Boolean> entry : merging.entrySet()) {
            permissions.putIfAbsent(entry.getKey(), entry.getValue());
        }
        return permissions;
    }

    public void resolveAllPermissions(Map<String, Boolean> accumulator, QueryOptions filter) {
        SubjectInheritanceGraph graph = new SubjectInheritanceGraph(filter);
        Iterable<CalculatedSubject> traversal = graph.traverse(TraversalAlgorithm.DEPTH_FIRST_PRE_ORDER, this);
        for (CalculatedSubject subject : traversal) {
            for (Map.Entry<String, Boolean> entry : subject.getCombinedPermissions(filter).entrySet()) {
                accumulator.putIfAbsent(entry.getKey(), entry.getValue());
            }
        }
    }

    public Set<LPSubjectReference> getCombinedParents(QueryOptions filter) {
        Set<LPSubjectReference> merging;
        Set<LPSubjectReference> parents;
        switch (this.getParentCollection().getResolutionOrder()) {
            case TRANSIENT_FIRST: {
                parents = this.getTransientSubjectData().resolveParents(filter);
                merging = this.getSubjectData().resolveParents(filter);
                break;
            }
            case TRANSIENT_LAST: {
                parents = this.getSubjectData().resolveParents(filter);
                merging = this.getTransientSubjectData().resolveParents(filter);
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        parents.addAll(merging);
        return parents;
    }

    public Set<LPSubjectReference> resolveAllParents(QueryOptions filter) {
        SubjectInheritanceGraph graph = new SubjectInheritanceGraph(filter);
        LinkedHashSet<LPSubjectReference> result = new LinkedHashSet<LPSubjectReference>();
        Iterable<CalculatedSubject> traversal = graph.traverse(TraversalAlgorithm.DEPTH_FIRST_PRE_ORDER, this);
        for (CalculatedSubject subject : traversal) {
            result.addAll(subject.getCombinedParents(filter));
        }
        return result;
    }

    public Map<String, String> getCombinedOptions(QueryOptions filter) {
        Map<String, String> merging;
        Map<String, String> options;
        switch (this.getParentCollection().getResolutionOrder()) {
            case TRANSIENT_FIRST: {
                options = this.getTransientSubjectData().resolveOptions(filter);
                merging = this.getSubjectData().resolveOptions(filter);
                break;
            }
            case TRANSIENT_LAST: {
                options = this.getSubjectData().resolveOptions(filter);
                merging = this.getTransientSubjectData().resolveOptions(filter);
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        for (Map.Entry<String, String> entry : merging.entrySet()) {
            options.putIfAbsent(entry.getKey(), entry.getValue());
        }
        return options;
    }

    public Map<String, String> resolveAllOptions(QueryOptions filter) {
        SubjectInheritanceGraph graph = new SubjectInheritanceGraph(filter);
        HashMap<String, String> result = new HashMap<String, String>();
        Iterable<CalculatedSubject> traversal = graph.traverse(TraversalAlgorithm.DEPTH_FIRST_PRE_ORDER, this);
        for (CalculatedSubject subject : traversal) {
            for (Map.Entry<String, String> entry : subject.getCombinedOptions(filter).entrySet()) {
                result.putIfAbsent(entry.getKey(), entry.getValue());
            }
        }
        return result;
    }

    public void resolveAllOptions(MetaAccumulator accumulator, QueryOptions filter) {
        SubjectInheritanceGraph graph = new SubjectInheritanceGraph(filter);
        Iterable<CalculatedSubject> traversal = graph.traverse(TraversalAlgorithm.DEPTH_FIRST_PRE_ORDER, this);
        for (CalculatedSubject subject : traversal) {
            for (Map.Entry<String, String> entry : subject.getCombinedOptions(filter).entrySet()) {
                accumulator.accumulateMeta(entry.getKey(), entry.getValue());
            }
        }
        accumulator.complete();
    }

    @Override
    public Tristate getPermissionValue(QueryOptions options, String permission) {
        return this.cachedData.getPermissionData(options).checkPermission(permission, PermissionCheckEvent.Origin.INTERNAL).result();
    }

    @Override
    public Tristate getPermissionValue(ImmutableContextSet contexts, String permission) {
        return this.getPermissionValue(QueryOptionsImpl.DEFAULT_CONTEXTUAL.toBuilder().context(contexts).build(), permission);
    }

    @Override
    public boolean isChildOf(ImmutableContextSet contexts, LPSubjectReference parent) {
        return this.resolveAllParents(QueryOptionsImpl.DEFAULT_CONTEXTUAL.toBuilder().context(contexts).build()).contains(parent);
    }

    @Override
    public ImmutableList<LPSubjectReference> getParents(ImmutableContextSet contexts) {
        return ImmutableList.copyOf(this.resolveAllParents(QueryOptionsImpl.DEFAULT_CONTEXTUAL.toBuilder().context(contexts).build()));
    }

    @Override
    public Optional<String> getOption(ImmutableContextSet contexts, String key) {
        return Optional.ofNullable(this.cachedData.getMetaData(QueryOptionsImpl.DEFAULT_CONTEXTUAL.toBuilder().context(contexts).build()).getMetaValue(key, MetaCheckEvent.Origin.PLATFORM_API));
    }

    @Override
    public void performCacheCleanup() {
        this.cachedData.performCacheCleanup();
    }

    @Override
    public void invalidateCaches() {
        this.cachedData.invalidate();
    }
}

