/*
 * Decompiled with CFR 0.152.
 */
package asmodeuscore.core.utils.worldengine.standardcustomgen;

import asmodeuscore.core.utils.worldengine.WE_Biome;
import asmodeuscore.core.utils.worldengine.additions.WE_CreateChunkGen;
import asmodeuscore.core.utils.worldengine.additions.WE_GeneratorData;
import asmodeuscore.core.utils.worldengine.perlinnoise.PerlinNoise;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.MathHelper;

public class WE_TerrainGenerator
extends WE_CreateChunkGen {
    public IBlockState worldStoneBlock = Blocks.field_150348_b.func_176223_P();
    public IBlockState worldSeaGenBlock = Blocks.field_150355_j.func_176223_P();
    public boolean worldSeaGen = true;
    public int worldSeaGenMaxY = 63;

    @Override
    public void gen(WE_GeneratorData data) {
        int q = WE_Biome.getBiggestInterpolationQuality(data.chunkProvider);
        WE_Biome[][] bl = new WE_Biome[16 + q * 2][16 + q * 2];
        WE_Biome sb = null;
        boolean ni = false;
        for (int xm = 0; xm < 16 + q * 2; ++xm) {
            for (int zm = 0; zm < 16 + q * 2; ++zm) {
                bl[xm][zm] = xm > q - 1 && zm > q - 1 && xm < 16 + q && zm < 16 + q ? this.getBiome(data, xm - q, zm - q) : WE_Biome.getBiomeAt(data.chunkProvider, data.chunk_X - (long)q + (long)xm, data.chunk_Z - (long)q + (long)zm);
                if (ni) continue;
                if (sb == null) {
                    sb = bl[xm][zm];
                    continue;
                }
                if (sb.id == bl[xm][zm].id) continue;
                ni = true;
            }
        }
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                int n = MathHelper.func_76128_c((double)this.interpolatedBlock(data.chunkProvider.worldObj.func_72905_C(), data.chunk_X, data.chunk_Z, x, z, bl, ni, q));
                for (int y = 0; y < 256; ++y) {
                    if (y == 0 || y <= 5 && data.chunkProvider.rand.nextInt(y) == 0) {
                        this.setBlock(data, Blocks.field_150357_h.func_176223_P(), x, y, z);
                        continue;
                    }
                    if (y <= n) {
                        this.setBlock(data, this.worldStoneBlock, x, y, z);
                        continue;
                    }
                    if (!this.worldSeaGen || y > this.worldSeaGenMaxY) continue;
                    this.setBlock(data, this.worldSeaGenBlock, x, y, z);
                }
            }
        }
    }

    public double interpolatedBlock(long seed, long chunk_X, long chunk_Z, int bcx, int bcz, WE_Biome[][] biomeListOfChunk, boolean doInterpolate, int iQuality) {
        int bx = iQuality + bcx;
        int bz = iQuality + bcz;
        if (doInterpolate) {
            double genPersistence = 0.0;
            double genScaleX = 0.0;
            double genScaleY = 0.0;
            int genNumberOfOctaves = 0;
            int genSurfaceHeight = 0;
            int c = 0;
            for (int i = 0; i <= 360; ++i) {
                for (int i2 = 0; i2 <= biomeListOfChunk[bx][bz].biomeInterpolateQuality; ++i2) {
                    int cbx = MathHelper.func_76141_d((float)((float)bx + MathHelper.func_76134_b((float)((float)i * (float)Math.PI / 180.0f)) * (float)i2));
                    int cbz = MathHelper.func_76141_d((float)((float)bz + MathHelper.func_76126_a((float)((float)i * (float)Math.PI / 180.0f)) * (float)i2));
                    ++c;
                    genPersistence += biomeListOfChunk[cbx][cbz].biomePersistence;
                    genNumberOfOctaves += biomeListOfChunk[cbx][cbz].biomeNumberOfOctaves;
                    genScaleX += biomeListOfChunk[cbx][cbz].biomeScaleX;
                    genScaleY += biomeListOfChunk[cbx][cbz].biomeScaleY;
                    genSurfaceHeight += biomeListOfChunk[cbx][cbz].biomeSurfaceHeight;
                }
            }
            genNumberOfOctaves = MathHelper.func_76141_d((float)(genNumberOfOctaves / c));
            genSurfaceHeight = MathHelper.func_76141_d((float)(genSurfaceHeight / c));
            PerlinNoise noise = new PerlinNoise(seed, genPersistence /= (double)c, genNumberOfOctaves, genScaleX /= (double)c, genScaleY /= (double)c, genSurfaceHeight);
            return noise.genNoise2d(chunk_X + (long)bcx, chunk_Z + (long)bcz);
        }
        PerlinNoise noise = new PerlinNoise(seed, biomeListOfChunk[bx][bz].biomePersistence, biomeListOfChunk[bx][bz].biomeNumberOfOctaves, biomeListOfChunk[bx][bz].biomeScaleX, biomeListOfChunk[bx][bz].biomeScaleY, biomeListOfChunk[bx][bz].biomeSurfaceHeight);
        return noise.genNoise2d(chunk_X + (long)bcx, chunk_Z + (long)bcz);
    }
}

