/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.configurate.settingprocessor;

import com.google.common.collect.Lists;
import com.google.common.reflect.TypeToken;
import io.github.nucleuspowered.relocate.nucleus.neutrino.settingprocessor.SettingProcessor;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import ninja.leaping.configurate.ConfigurationNode;
import ninja.leaping.configurate.objectmapping.ObjectMappingException;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.entity.EntityType;
import org.spongepowered.api.entity.living.Living;

public class MobTypeSettingProcessor
implements SettingProcessor {
    private static final TypeToken<String> stringTypeToken = TypeToken.of(String.class);
    private static final TypeToken<List<EntityType>> entityTypeToken = new TypeToken<List<EntityType>>(){};

    @Override
    public void process(ConfigurationNode cn) throws ObjectMappingException {
        List types = Sponge.getRegistry().getAllOf(EntityType.class).stream().filter(x -> Living.class.isAssignableFrom(x.getEntityClass())).collect(Collectors.toList());
        ArrayList whitelist = Lists.newArrayList();
        cn.getList(stringTypeToken).forEach(x -> {
            if (x.contains(":")) {
                types.stream().filter(y -> y.getId().equalsIgnoreCase((String)x)).findFirst().ifPresent(whitelist::add);
            } else {
                String potentialId = "minecraft:" + x.toLowerCase();
                Optional<EntityType> typeOptional = types.stream().filter(y -> y.getId().equalsIgnoreCase(potentialId)).findFirst();
                if (typeOptional.isPresent()) {
                    whitelist.add(typeOptional.get());
                } else {
                    types.stream().filter(y -> y.getName().equalsIgnoreCase((String)x)).findFirst().ifPresent(whitelist::add);
                }
            }
        });
        cn.setValue(entityTypeToken, (Object)whitelist);
    }
}

