/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.kit.services;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import io.github.nucleuspowered.nucleus.Util;
import io.github.nucleuspowered.nucleus.api.module.kit.KitRedeemResult;
import io.github.nucleuspowered.nucleus.api.module.kit.NucleusKitService;
import io.github.nucleuspowered.nucleus.api.module.kit.data.Kit;
import io.github.nucleuspowered.nucleus.modules.kit.KitKeys;
import io.github.nucleuspowered.nucleus.modules.kit.config.KitConfig;
import io.github.nucleuspowered.nucleus.modules.kit.events.KitEvent;
import io.github.nucleuspowered.nucleus.modules.kit.misc.KitRedeemResultImpl;
import io.github.nucleuspowered.nucleus.modules.kit.misc.SingleKit;
import io.github.nucleuspowered.nucleus.modules.kit.parameters.KitParameter;
import io.github.nucleuspowered.nucleus.scaffold.service.ServiceBase;
import io.github.nucleuspowered.nucleus.scaffold.service.annotations.APIService;
import io.github.nucleuspowered.nucleus.services.INucleusServiceCollection;
import io.github.nucleuspowered.nucleus.services.impl.storage.dataobjects.standard.IKitDataObject;
import io.github.nucleuspowered.nucleus.services.interfaces.IMessageProviderService;
import io.github.nucleuspowered.nucleus.services.interfaces.INucleusTextTemplateFactory;
import io.github.nucleuspowered.nucleus.services.interfaces.IPermissionService;
import io.github.nucleuspowered.nucleus.services.interfaces.IReloadableService;
import io.github.nucleuspowered.nucleus.services.interfaces.IStorageManager;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.command.source.ConsoleSource;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.Event;
import org.spongepowered.api.item.ItemTypes;
import org.spongepowered.api.item.inventory.Carrier;
import org.spongepowered.api.item.inventory.Container;
import org.spongepowered.api.item.inventory.Inventory;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.api.item.inventory.transaction.InventoryTransactionResult;
import org.spongepowered.api.plugin.PluginContainer;
import org.spongepowered.api.scheduler.Task;
import org.spongepowered.api.service.permission.Subject;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.serializer.TextSerializers;
import org.spongepowered.api.util.Tuple;

@APIService(value=NucleusKitService.class)
public class KitService
implements NucleusKitService,
IReloadableService.Reloadable,
ServiceBase {
    private static final InventoryTransactionResult EMPTY_ITR = InventoryTransactionResult.builder().type(InventoryTransactionResult.Type.SUCCESS).build();
    private static final Pattern inventory = Pattern.compile("\\{\\{.+?}}");
    private final IStorageManager storageManager;
    private final IPermissionService permissionService;
    private final IMessageProviderService messageProviderService;
    private final INucleusTextTemplateFactory textTemplateFactory;
    private final Logger logger;
    private final List<Container> viewers = Lists.newArrayList();
    private final Map<Container, Tuple<Kit, Inventory>> inventoryKitMap = Maps.newHashMap();
    private final KitParameter noPerm;
    private final KitParameter perm;
    private final PluginContainer pluginContainer;
    private boolean isProcessTokens = false;
    private boolean isMustGetAll = false;
    @Nullable
    private Boolean hasViewersWorks = null;

    @Inject
    public KitService(INucleusServiceCollection serviceCollection) {
        this.permissionService = serviceCollection.permissionService();
        this.storageManager = serviceCollection.storageManager();
        this.messageProviderService = serviceCollection.messageProvider();
        this.textTemplateFactory = serviceCollection.textTemplateFactory();
        this.logger = serviceCollection.logger();
        this.noPerm = new KitParameter(this, serviceCollection.messageProvider(), serviceCollection.permissionService(), false);
        this.perm = new KitParameter(this, serviceCollection.messageProvider(), serviceCollection.permissionService(), true);
        this.pluginContainer = serviceCollection.pluginContainer();
    }

    public CommandElement createKitElement(boolean permissionCheck) {
        return permissionCheck ? this.perm : this.noPerm;
    }

    public boolean exists(String name, boolean includeHidden) {
        return this.getKitNames(includeHidden).stream().anyMatch(x -> x.equalsIgnoreCase(name));
    }

    @Override
    public Set<String> getKitNames() {
        return this.getKitNames(true);
    }

    @Override
    public Optional<Kit> getKit(String name) {
        return Optional.ofNullable(this.storageManager.getKits().getKitMap().get(name.toLowerCase()));
    }

    @Override
    public Collection<ItemStack> getItemsForPlayer(Kit kit, Player player) {
        Collection cis = kit.getStacks().stream().map(ItemStackSnapshot::createStack).collect(Collectors.toList());
        if (this.isProcessTokens) {
            this.processTokensInItemStacks(player, cis);
        }
        return cis;
    }

    @Override
    public CompletableFuture<Boolean> hasPreviouslyRedeemed(Kit kit, User user) {
        return this.redeemTime(kit.getName(), user).thenApply(Optional::isPresent);
    }

    @Override
    public CompletableFuture<Boolean> isRedeemable(Kit kit, User user) {
        return this.redeemTime(kit.getName(), user).thenApply(x -> {
            if (x.isPresent()) {
                if (kit.isOneTime()) {
                    return false;
                }
                return !this.getNextUseTime(kit, user, (Instant)x.get()).isPresent();
            }
            return true;
        });
    }

    @Override
    public CompletableFuture<Optional<Instant>> getCooldownExpiry(Kit kit, User user) {
        return this.redeemTime(kit.getName(), user).thenApply(x -> {
            Instant cooldownExpiry;
            if (x.isPresent() && kit.getCooldown().isPresent() && (cooldownExpiry = ((Instant)x.get()).plus(kit.getCooldown().get())).isAfter(Instant.now())) {
                return Optional.of(cooldownExpiry);
            }
            return Optional.empty();
        });
    }

    private CompletableFuture<Optional<Instant>> redeemTime(String name, User user) {
        return this.getUserRedemptionData(user).thenApply(x -> Optional.ofNullable(x.get(name)));
    }

    @Override
    public KitRedeemResult redeemKit(Kit kit, Player player, boolean performChecks) {
        return this.redeemKit(kit, player, performChecks, performChecks, this.isMustGetAll, false);
    }

    @Override
    public KitRedeemResult redeemKit(Kit kit, Player player, boolean performChecks, boolean mustRedeemAll) {
        return this.redeemKit(kit, player, performChecks, performChecks, mustRedeemAll, false);
    }

    public KitRedeemResult redeemKit(Kit kit, Player player, boolean checkOneTime, boolean checkCooldown, boolean isMustGetAll, boolean isFirstJoin) {
        KitRedeemResultImpl result = null;
        Map<String, Instant> redeemed = this.getUserRedemptionData((User)player).join();
        Instant timeOfLastUse = redeemed.get(kit.getName().toLowerCase());
        Instant now = Instant.now();
        try (CauseStackManager.StackFrame frame = Sponge.getCauseStackManager().pushCauseFrame();){
            frame.pushCause((Object)player);
            ImmutableList<ItemStackSnapshot> original = this.getItems(kit, this.isProcessTokens, player);
            List<String> commands = kit.getCommands();
            Optional<Instant> instant = this.getNextUseTime(kit, (User)player, timeOfLastUse);
            if ((checkOneTime || checkCooldown) && timeOfLastUse != null) {
                if (checkOneTime && !this.checkOneTime(kit, (User)player)) {
                    Sponge.getEventManager().post((Event)new KitEvent.FailedRedeem(frame.getCurrentCause(), timeOfLastUse, kit, player, (Collection<ItemStackSnapshot>)original, null, (Collection<String>)commands, null, KitRedeemResult.Status.ALREADY_REDEEMED_ONE_TIME, isFirstJoin));
                    result = new KitRedeemResultImpl(KitRedeemResult.Status.ALREADY_REDEEMED_ONE_TIME, (Collection<ItemStackSnapshot>)ImmutableList.of(), null, null);
                } else if (checkCooldown && instant.isPresent()) {
                    Sponge.getEventManager().post((Event)new KitEvent.FailedRedeem(frame.getCurrentCause(), timeOfLastUse, kit, player, (Collection<ItemStackSnapshot>)original, null, (Collection<String>)commands, null, KitRedeemResult.Status.COOLDOWN_NOT_EXPIRED, isFirstJoin));
                    result = new KitRedeemResultImpl(KitRedeemResult.Status.COOLDOWN_NOT_EXPIRED, (Collection<ItemStackSnapshot>)ImmutableList.of(), instant.get(), null);
                }
            }
            if (result == null) {
                KitEvent.PreRedeem preEvent = new KitEvent.PreRedeem(frame.getCurrentCause(), timeOfLastUse, kit, player, (Collection<ItemStackSnapshot>)original, (Collection<String>)commands, isFirstJoin);
                if (Sponge.getEventManager().post((Event)preEvent)) {
                    Sponge.getEventManager().post((Event)new KitEvent.FailedRedeem(frame.getCurrentCause(), timeOfLastUse, kit, player, (Collection<ItemStackSnapshot>)original, preEvent.getStacksToRedeem().orElse(null), (Collection<String>)commands, preEvent.getCommandsToExecute().orElse(null), KitRedeemResult.Status.PRE_EVENT_CANCELLED, isFirstJoin));
                    result = new KitRedeemResultImpl(KitRedeemResult.Status.PRE_EVENT_CANCELLED, Collections.emptyList(), instant.orElse(null), preEvent.getCancelMessage().orElse(null));
                } else {
                    ArrayList slotList = Lists.newArrayList();
                    Util.getStandardInventory((Carrier)player).slots().forEach(x -> slotList.add(x.peek().map(ItemStack::createSnapshot)));
                    InventoryTransactionResult inventoryTransactionResult = EMPTY_ITR;
                    KitRedeemResultImpl ex = null;
                    if (!kit.getStacks().isEmpty()) {
                        inventoryTransactionResult = this.addToStandardInventory(player, preEvent.getStacksToRedeem().orElseGet(preEvent::getOriginalStacksToRedeem));
                        if (!isFirstJoin && !inventoryTransactionResult.getRejectedItems().isEmpty() && isMustGetAll) {
                            Inventory inventory = Util.getStandardInventory((Carrier)player);
                            Iterator slot = inventory.slots().iterator();
                            slotList.forEach(x -> {
                                Inventory i = (Inventory)slot.next();
                                i.clear();
                                x.ifPresent(y -> i.offer(y.createStack()));
                            });
                            ex = new KitRedeemResultImpl(KitRedeemResult.Status.NO_SPACE, inventoryTransactionResult.getRejectedItems(), instant.orElse(null), preEvent.getCancelMessage().orElse(null));
                        }
                    }
                    if (ex == null && inventoryTransactionResult.getType() == InventoryTransactionResult.Type.SUCCESS) {
                        Collection commandsToExecute = preEvent.getCommandsToExecute().orElse(commands);
                        if (isFirstJoin) {
                            Task.builder().delayTicks(1L).execute(() -> this.redeemKitCommands(commandsToExecute, player)).submit((Object)this.pluginContainer);
                        } else {
                            this.redeemKitCommands(commandsToExecute, player);
                        }
                        if (checkCooldown) {
                            redeemed.put(kit.getName().toLowerCase(), now);
                            this.setUserRedemptionData((User)player, redeemed);
                        }
                        Sponge.getEventManager().post((Event)new KitEvent.PostRedeem(frame.getCurrentCause(), timeOfLastUse, kit, player, (Collection<ItemStackSnapshot>)original, preEvent.getStacksToRedeem().orElse(null), (Collection<String>)commands, commandsToExecute, isFirstJoin));
                        Optional<Instant> nextCooldown = this.getNextUseTime(kit, (User)player, Instant.now());
                        result = new KitRedeemResultImpl(inventoryTransactionResult.getRejectedItems().isEmpty() ? KitRedeemResult.Status.SUCCESS : KitRedeemResult.Status.PARTIAL_SUCCESS, inventoryTransactionResult.getRejectedItems(), nextCooldown.orElse(null), null);
                    } else {
                        ex = ex == null ? new KitRedeemResultImpl(KitRedeemResult.Status.UNKNOWN, inventoryTransactionResult.getRejectedItems(), instant.orElse(null), null) : ex;
                        Sponge.getEventManager().post((Event)new KitEvent.FailedRedeem(frame.getCurrentCause(), timeOfLastUse, kit, player, (Collection<ItemStackSnapshot>)original, preEvent.getStacksToRedeem().orElse(null), (Collection<String>)commands, preEvent.getCommandsToExecute().orElse(null), ex.getStatus(), isFirstJoin));
                        result = ex;
                    }
                }
            }
        }
        return result;
    }

    private void redeemKitCommands(Collection<String> commands, Player player) {
        ConsoleSource source = Sponge.getServer().getConsole();
        String playerName = player.getName();
        commands.forEach(x -> Sponge.getCommandManager().process((CommandSource)source, x.replace("{{player}}", playerName)));
    }

    public boolean checkOneTime(Kit kit, User player) {
        return !kit.isOneTime() || this.permissionService.hasPermission((Subject)player, "nucleus.kit.exempt.onetime");
    }

    public Optional<Instant> getNextUseTime(Kit kit, User player, Instant timeOfLastUse) {
        Instant timeForNextUse;
        if (timeOfLastUse != null && !this.permissionService.hasPermission((Subject)player, "nucleus.kit.exempt.cooldown") && kit.getCooldown().map(Duration::getSeconds).orElse(0L) > 0L && (timeForNextUse = timeOfLastUse.plus(kit.getCooldown().get())).isAfter(Instant.now())) {
            return Optional.of(timeForNextUse);
        }
        return Optional.empty();
    }

    private CompletableFuture<Map<String, Instant>> getUserRedemptionData(User user) {
        return this.storageManager.getUserService().getOrNew(user.getUniqueId()).thenApply(dataObject -> dataObject.get(KitKeys.REDEEMED_KITS).orElseGet(HashMap::new));
    }

    private void setUserRedemptionData(User user, Map<String, Instant> set) {
        this.storageManager.getUserService().setAndSave(user.getUniqueId(), KitKeys.REDEEMED_KITS, set);
    }

    @Override
    public void saveKit(Kit kit) {
        this.saveKit(kit, true);
    }

    public void saveKit(Kit kit, boolean save) {
        IKitDataObject kitDataObject = this.storageManager.getKits();
        HashMap<String, Kit> kits = new HashMap<String, Kit>(kitDataObject.getKitMap());
        Util.getKeyIgnoreCase(this.getKitNames(true), kit.getName()).ifPresent(kits::remove);
        kits.put(kit.getName().toLowerCase(), kit);
        try {
            kitDataObject.setKitMap(kits);
            if (save) {
                this.storageManager.getKitsService().save(kitDataObject);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public Kit createKit(String name) throws IllegalArgumentException {
        IKitDataObject kitDataObject = this.storageManager.getKits();
        HashMap<String, Kit> kits = new HashMap<String, Kit>(kitDataObject.getKitMap());
        Util.getKeyIgnoreCase(kits, name).ifPresent(s -> {
            throw new IllegalArgumentException("Kit " + name + " already exists!");
        });
        SingleKit kit = new SingleKit(name);
        this.saveKit(kit, true);
        return kit;
    }

    @Override
    public void renameKit(String kitName, String newKitName) throws IllegalArgumentException {
        String from = kitName.toLowerCase();
        String to = newKitName.toLowerCase();
        Kit targetKit = this.getKit(from).orElseThrow(() -> new IllegalArgumentException(this.messageProviderService.getMessageString("kit.noexists", kitName)));
        if (this.getKit(to).isPresent()) {
            throw new IllegalArgumentException(this.messageProviderService.getMessageString("kit.cannotrename", from, to));
        }
        this.saveKit(new SingleKit(kitName.toLowerCase(), targetKit), true);
        this.removeKit(from);
    }

    public Optional<Tuple<Kit, Inventory>> getCurrentlyOpenInventoryKit(Container inventory) {
        return Optional.ofNullable(this.inventoryKitMap.get(inventory));
    }

    public boolean isOpen(String kitName) {
        return this.inventoryKitMap.values().stream().anyMatch(x -> ((Kit)x.getFirst()).getName().equalsIgnoreCase(kitName));
    }

    public void addKitInventoryToListener(Tuple<Kit, Inventory> kit, Container inventory) {
        Preconditions.checkState((!this.inventoryKitMap.containsKey(inventory) ? 1 : 0) != 0);
        this.inventoryKitMap.put(inventory, kit);
    }

    public void removeKitInventoryFromListener(Container inventory) {
        this.inventoryKitMap.remove(inventory);
    }

    public void addViewer(Container inventory) {
        this.viewers.add(inventory);
    }

    public void removeViewer(Container inventory) {
        this.viewers.remove(inventory);
        if (this.hasViewersWorks == null) {
            try {
                inventory.hasViewers();
                this.hasViewersWorks = true;
            }
            catch (Throwable throwable) {
                this.hasViewersWorks = false;
                return;
            }
        }
        if (this.hasViewersWorks.booleanValue()) {
            this.viewers.removeIf(x -> !x.hasViewers());
        }
    }

    public boolean isViewer(Container inventory) {
        return this.viewers.contains(inventory);
    }

    public void processTokensInItemStacks(Player player, Collection<ItemStack> stacks) {
        Matcher m = inventory.matcher("");
        for (ItemStack x : stacks) {
            x.get(Keys.DISPLAY_NAME).ifPresent(text -> {
                if (m.reset(text.toPlain()).find()) {
                    x.offer(Keys.DISPLAY_NAME, (Object)this.textTemplateFactory.createFromAmpersandString(TextSerializers.FORMATTING_CODE.serialize(text)).getForCommandSource((CommandSource)player));
                }
            });
            x.get(Keys.ITEM_LORE).ifPresent(text -> {
                if (text.stream().map(Text::toPlain).anyMatch(y -> m.reset((CharSequence)y).find())) {
                    x.offer(Keys.ITEM_LORE, text.stream().map(y -> this.textTemplateFactory.createFromAmpersandString(TextSerializers.FORMATTING_CODE.serialize(y)).getForCommandSource((CommandSource)player)).collect(Collectors.toList()));
                }
            });
        }
    }

    private ImmutableList<ItemStackSnapshot> getItems(Kit kit, boolean replaceTokensInLore, Player targetPlayer) {
        Collection toOffer = kit.getStacks().stream().filter(x -> x.getType() != ItemTypes.NONE).map(ItemStackSnapshot::createStack).collect(Collectors.toList());
        if (replaceTokensInLore) {
            this.processTokensInItemStacks(targetPlayer, toOffer);
        }
        return (ImmutableList)toOffer.stream().map(ItemStack::createSnapshot).collect(ImmutableList.toImmutableList());
    }

    private InventoryTransactionResult addToStandardInventory(Player player, Collection<ItemStackSnapshot> itemStacks) {
        Inventory target = Util.getStandardInventory((Carrier)player);
        InventoryTransactionResult.Builder resultBuilder = InventoryTransactionResult.builder();
        Collection toOffer = itemStacks.stream().filter(x -> x.getType() != ItemTypes.NONE).map(ItemStackSnapshot::createStack).collect(Collectors.toList());
        boolean success = false;
        for (ItemStack stack : toOffer) {
            InventoryTransactionResult itr = target.offer(stack);
            success = success || itr.getType() == InventoryTransactionResult.Type.SUCCESS;
            for (ItemStackSnapshot iss : itr.getRejectedItems()) {
                resultBuilder.reject(new ItemStack[]{iss.createStack()});
            }
        }
        return resultBuilder.type(success ? InventoryTransactionResult.Type.SUCCESS : InventoryTransactionResult.Type.FAILURE).build();
    }

    public Set<String> getKitNames(boolean showHidden) {
        return (Set)this.storageManager.getKits().getKitMap().entrySet().stream().filter(x -> showHidden || !((Kit)x.getValue()).isHiddenFromList() && !((Kit)x.getValue()).isFirstJoinKit()).map(Map.Entry::getKey).collect(ImmutableSet.toImmutableSet());
    }

    public List<Kit> getFirstJoinKits() {
        return this.storageManager.getKits().getKitMap().values().stream().filter(Kit::isFirstJoinKit).collect(Collectors.toList());
    }

    public List<Kit> getAutoRedeemable() {
        return this.storageManager.getKits().getKitMap().values().stream().filter(x -> x.isAutoRedeem() && x.getCost() <= 0.0).collect(Collectors.toList());
    }

    @Override
    public boolean removeKit(String name) {
        boolean r = false;
        try {
            r = this.storageManager.getKits().removeKit(name.toLowerCase());
        }
        catch (Exception e) {
            this.logger.error("Could not update kits", (Throwable)e);
        }
        return r;
    }

    @Override
    public void onReload(INucleusServiceCollection serviceCollection) {
        KitConfig kitConfig = serviceCollection.moduleDataProvider().getModuleConfig(KitConfig.class);
        this.isMustGetAll = kitConfig.isMustGetAll();
        this.isProcessTokens = kitConfig.isProcessTokens();
    }
}

