/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.spawn.commands;

import io.github.nucleuspowered.nucleus.api.EventContexts;
import io.github.nucleuspowered.nucleus.api.module.spawn.event.NucleusSendToSpawnEvent;
import io.github.nucleuspowered.nucleus.api.teleport.data.TeleportResult;
import io.github.nucleuspowered.nucleus.api.teleport.data.TeleportScanners;
import io.github.nucleuspowered.nucleus.modules.spawn.commands.SpawnCommand;
import io.github.nucleuspowered.nucleus.modules.spawn.config.GlobalSpawnConfig;
import io.github.nucleuspowered.nucleus.modules.spawn.config.SpawnConfig;
import io.github.nucleuspowered.nucleus.modules.spawn.events.SendToSpawnEvent;
import io.github.nucleuspowered.nucleus.modules.spawn.helpers.SpawnHelper;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandContext;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandExecutor;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandResult;
import io.github.nucleuspowered.nucleus.scaffold.command.NucleusParameters;
import io.github.nucleuspowered.nucleus.scaffold.command.annotation.Command;
import io.github.nucleuspowered.nucleus.services.INucleusServiceCollection;
import io.github.nucleuspowered.nucleus.services.interfaces.IReloadableService;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.entity.Transform;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.Event;
import org.spongepowered.api.text.channel.MessageReceiver;
import org.spongepowered.api.util.annotation.NonnullByDefault;
import org.spongepowered.api.world.World;
import org.spongepowered.api.world.storage.WorldProperties;

@NonnullByDefault
@Command(aliases={"other"}, basePermission={"nucleus.spawn.other.base"}, commandDescriptionKey="spawn.other", parentCommand=SpawnCommand.class, associatedPermissions={"nucleus.spawn.other.offline"})
public class SpawnOtherCommand
implements ICommandExecutor<CommandSource>,
IReloadableService.Reloadable {
    private GlobalSpawnConfig gsc = new GlobalSpawnConfig();
    private boolean safeTeleport = true;

    @Override
    public CommandElement[] parameters(INucleusServiceCollection serviceCollection) {
        return new CommandElement[]{NucleusParameters.ONE_USER.get(serviceCollection), NucleusParameters.OPTIONAL_WORLD_PROPERTIES_ENABLED_ONLY.get(serviceCollection)};
    }

    @Override
    public void onReload(INucleusServiceCollection serviceCollection) {
        SpawnConfig sc = serviceCollection.moduleDataProvider().getModuleConfig(SpawnConfig.class);
        this.gsc = sc.getGlobalSpawn();
        this.safeTeleport = sc.isSafeTeleport();
    }

    @Override
    public ICommandResult execute(ICommandContext<? extends CommandSource> context) throws CommandException {
        User target = context.requireOne("user", User.class);
        WorldProperties world = context.getWorldPropertiesOrFromSelf("world").orElseGet(() -> this.gsc.isOnSpawnCommand() ? this.gsc.getWorld().get() : (WorldProperties)Sponge.getServer().getDefaultWorld().get());
        Transform<World> worldTransform = SpawnHelper.getSpawn(world, target.getPlayer().orElse(null), context);
        try (CauseStackManager.StackFrame frame = Sponge.getCauseStackManager().pushCauseFrame();){
            frame.addContext(EventContexts.SPAWN_EVENT_TYPE, (Object)NucleusSendToSpawnEvent.Type.COMMAND);
            frame.pushCause((Object)context.getCommandSource());
            SendToSpawnEvent event = new SendToSpawnEvent(worldTransform, target, frame.getCurrentCause());
            if (Sponge.getEventManager().post((Event)event)) {
                if (event.getCancelReason().isPresent()) {
                    ICommandResult iCommandResult = context.errorResult("command.spawnother.other.failed.reason", target.getName(), event.getCancelReason().get());
                    return iCommandResult;
                }
                ICommandResult iCommandResult = context.errorResult("command.spawnother.other.failed.noreason", target.getName());
                return iCommandResult;
            }
            if (!target.isOnline()) {
                ICommandResult iCommandResult = this.isOffline(context, target, event.getTransformTo());
                return iCommandResult;
            }
            Player player = (Player)target.getPlayer().get();
            TeleportResult result = context.getServiceCollection().teleportService().teleportPlayerSmart(player, event.getTransformTo(), true, this.safeTeleport, TeleportScanners.NO_SCAN.get());
            if (result.isSuccessful()) {
                context.sendMessage("command.spawnother.success.source", target.getName(), world.getWorldName());
                context.sendMessageTo((MessageReceiver)player, "command.spawnother.success.target", world.getWorldName());
                ICommandResult iCommandResult = context.successResult();
                return iCommandResult;
            }
            ICommandResult iCommandResult = context.errorResult("command.spawnother.fail", target.getName(), world.getWorldName());
            return iCommandResult;
        }
    }

    private ICommandResult isOffline(ICommandContext<? extends CommandSource> context, User user, Transform<World> worldTransform) throws CommandException {
        if (!context.testPermission("nucleus.spawn.other.offline")) {
            return context.errorResult("command.spawnother.offline.permission", new Object[0]);
        }
        user.setLocation(worldTransform.getPosition(), ((World)worldTransform.getExtent()).getUniqueId());
        context.sendMessage("command.spawnother.offline.sendonlogin", user.getName(), ((World)worldTransform.getExtent()).getName());
        return context.successResult();
    }
}

