/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.warp.commands;

import io.github.nucleuspowered.nucleus.api.module.warp.data.Warp;
import io.github.nucleuspowered.nucleus.api.teleport.data.TeleportResult;
import io.github.nucleuspowered.nucleus.api.teleport.data.TeleportScanners;
import io.github.nucleuspowered.nucleus.modules.warp.config.WarpConfig;
import io.github.nucleuspowered.nucleus.modules.warp.event.UseWarpEvent;
import io.github.nucleuspowered.nucleus.modules.warp.services.WarpService;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandContext;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandExecutor;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandResult;
import io.github.nucleuspowered.nucleus.scaffold.command.NucleusParameters;
import io.github.nucleuspowered.nucleus.scaffold.command.annotation.Command;
import io.github.nucleuspowered.nucleus.scaffold.command.annotation.CommandModifier;
import io.github.nucleuspowered.nucleus.scaffold.command.annotation.EssentialsEquivalent;
import io.github.nucleuspowered.nucleus.services.INucleusServiceCollection;
import io.github.nucleuspowered.nucleus.services.interfaces.IEconomyServiceProvider;
import io.github.nucleuspowered.nucleus.services.interfaces.INucleusTeleportService;
import io.github.nucleuspowered.nucleus.services.interfaces.IReloadableService;
import java.util.Optional;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.command.args.GenericArguments;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.Event;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.action.ClickAction;
import org.spongepowered.api.text.action.HoverAction;
import org.spongepowered.api.text.action.TextActions;
import org.spongepowered.api.text.channel.MessageReceiver;
import org.spongepowered.api.util.annotation.NonnullByDefault;
import org.spongepowered.api.world.storage.WorldProperties;
import org.spongepowered.api.world.teleport.TeleportHelperFilter;

@NonnullByDefault
@EssentialsEquivalent(value={"warp", "warps"}, isExact=false, notes="Use '/warp' for warping, '/warps' to list warps.")
@Command(aliases={"warp"}, basePermission={"nucleus.warp.base"}, commandDescriptionKey="warp", modifiers={@CommandModifier(value="nucleus:has_warmup", exemptPermission="nucleus.warp.exempt.warmup"), @CommandModifier(value="nucleus:has_cooldown", exemptPermission="nucleus.warp.exempt.cooldown")}, associatedPermissions={"nucleus.warps", "nucleus.warp.others"})
public class WarpCommand
implements ICommandExecutor<CommandSource>,
IReloadableService.Reloadable {
    private boolean isSafeTeleport = true;
    private double defaultCost = 0.0;

    @Override
    public void onReload(INucleusServiceCollection serviceCollection) {
        WarpConfig wc = serviceCollection.moduleDataProvider().getModuleConfig(WarpConfig.class);
        this.defaultCost = wc.getDefaultWarpCost();
        this.isSafeTeleport = wc.isSafeTeleport();
    }

    @Override
    public CommandElement[] parameters(INucleusServiceCollection serviceCollection) {
        return new CommandElement[]{GenericArguments.onlyOne((CommandElement)GenericArguments.optionalWeak((CommandElement)GenericArguments.flags().flag(new String[]{"y", "a", "-accept"}).flag(new String[]{"f", "-force"}).setAnchorFlags(false).buildWith(GenericArguments.none()))), GenericArguments.optionalWeak((CommandElement)serviceCollection.commandElementSupplier().createPermissionParameter(NucleusParameters.OPTIONAL_ONE_PLAYER.get(serviceCollection), "nucleus.warp.others", false)), GenericArguments.onlyOne((CommandElement)serviceCollection.getServiceUnchecked(WarpService.class).warpElement(true))};
    }

    @Override
    public Optional<ICommandResult> preExecute(ICommandContext.Mutable<? extends CommandSource> context) throws CommandException {
        Player target = context.getPlayerFromArgs();
        IEconomyServiceProvider economyServiceProvider = context.getServiceCollection().economyServiceProvider();
        if (!context.is(target)) {
            context.removeModifier("nucleus:has_cooldown");
            return Optional.empty();
        }
        if (!economyServiceProvider.serviceExists() || context.testPermission("nucleus.warp.exempt.cost") || context.hasAny("y")) {
            return Optional.empty();
        }
        Warp wd = context.requireOne("warp", Warp.class);
        Optional<Double> i = wd.getCost();
        double cost = i.orElse(this.defaultCost);
        if (cost <= 0.0) {
            return Optional.empty();
        }
        String costWithUnit = economyServiceProvider.getCurrencySymbol(cost);
        if (economyServiceProvider.hasBalance(target, cost)) {
            String command = String.format("/warp -y %s", wd.getName());
            context.sendMessage("command.warp.cost.details", wd.getName(), costWithUnit);
            context.sendMessageText(context.getMessage("command.warp.cost.clickaccept", new Object[0]).toBuilder().onClick((ClickAction)TextActions.runCommand((String)command)).onHover((HoverAction)TextActions.showText((Text)context.getMessage("command.warp.cost.clickhover", command))).append(new Text[]{context.getMessage("command.warp.cost.alt", new Object[0])}).build());
        } else {
            context.sendMessage("command.warp.cost.nomoney", wd.getName(), costWithUnit);
        }
        return Optional.of(context.failResult());
    }

    @Override
    public ICommandResult execute(ICommandContext<? extends CommandSource> context) throws CommandException {
        Player player = context.getPlayerFromArgs();
        boolean isOther = !context.is(player);
        Warp wd = context.requireOne("warp", Warp.class);
        WorldProperties worldProperties = wd.getWorldProperties().orElseThrow(() -> context.createException("command.warp.worlddoesnotexist", new Object[0]));
        if (!wd.getTransform().isPresent()) {
            Sponge.getServer().loadWorld(worldProperties.getUniqueId()).orElseThrow(() -> context.createException("command.warp.worldnotloaded", new Object[0]));
        }
        try (CauseStackManager.StackFrame frame = Sponge.getCauseStackManager().pushCauseFrame();){
            frame.pushCause((Object)context.getCommandSource());
            UseWarpEvent event = new UseWarpEvent(frame.getCurrentCause(), (User)player, wd);
            if (Sponge.getEventManager().post((Event)event)) {
                ICommandResult iCommandResult = event.getCancelMessage().map(context::errorResultLiteral).orElseGet(() -> context.errorResult("nucleus.eventcancelled", new Object[0]));
                return iCommandResult;
            }
            Optional<Double> i = wd.getCost();
            double cost = i.orElse(this.defaultCost);
            boolean charge = false;
            IEconomyServiceProvider economyServiceProvider = context.getServiceCollection().economyServiceProvider();
            if (!isOther && economyServiceProvider.serviceExists() && cost > 0.0 && !context.testPermission("nucleus.warp.exempt.cost")) {
                if (economyServiceProvider.withdrawFromPlayer(player, cost, false)) {
                    charge = true;
                } else {
                    ICommandResult iCommandResult = context.errorResult("command.warp.cost.nomoney", wd.getName(), economyServiceProvider.getCurrencySymbol(cost));
                    return iCommandResult;
                }
            }
            if (isOther) {
                context.sendMessage("command.warps.namedstart", context.getDisplayName(player.getUniqueId()), wd.getName());
            } else {
                context.sendMessage("command.warps.start", wd.getName());
            }
            boolean isSafe = !context.hasAny("f") && this.isSafeTeleport;
            INucleusTeleportService safeLocationService = context.getServiceCollection().teleportService();
            TeleportHelperFilter filter = safeLocationService.getAppropriateFilter(player, isSafe);
            TeleportResult result = safeLocationService.teleportPlayer(player, wd.getLocation().get(), wd.getRotation(), false, TeleportScanners.NO_SCAN.get(), filter, new TeleportHelperFilter[0]);
            if (!result.isSuccessful()) {
                if (charge) {
                    economyServiceProvider.depositInPlayer((User)player, cost, false);
                }
                ICommandResult iCommandResult = context.errorResult(result == TeleportResult.FAIL_NO_LOCATION ? "command.warps.nosafe" : "command.warps.cancelled", new Object[0]);
                return iCommandResult;
            }
            if (isOther) {
                context.sendMessageTo((MessageReceiver)player, "command.warps.warped", wd.getName());
            } else if (charge) {
                context.sendMessage("command.warp.cost.charged", economyServiceProvider.getCurrencySymbol(cost));
            }
            ICommandResult iCommandResult = context.successResult();
            return iCommandResult;
        }
    }
}

